package jp.sourceforge.functional;

import jp.sourceforge.functional.pair.SamePair;

public abstract class SameBinaryConverter<T, R> extends
		BinaryConverter<T, T, R> {

	public NullaryConverter<R> bindBoth(T bind) {
		return bind(new SamePair<T>(bind, bind));
	}

	public <S> SameBinaryConverter<S, R> arrangeBoth(
			final Converter<? super S, ? extends T> converter) {
		return new SameBinaryConverter<S, R>() {
			@Override
			public R convert(S first, S second) {
				return SameBinaryConverter.this.convert(converter
						.convert(first), converter.convert(second));
			}
		};
	}
}
