/**
 * 
 */
package jp.sourceforge.functional;

/**
 * <p>
 * 引数を受け取って何らかの処理を実行する、戻り値の無いファンクタです。
 * </p>
 * <p>
 * これは通常、何らかの可変オブジェクト（多くは引数で受け取った値）の状態を 変更する、またはユーザーインターフェースへの出力を行うなどの、いわゆる
 * ”副作用のある”処理を行うときに使用します。<BR>
 * 「問い合わせと更新を分離する」と言う設計原則を守るため（通常は守るべきだと思いますが） には、<code>Void</code>
 * 以外の戻り値を持つファンクタにおいて、このインターフェイスを安易に実装するべきではありません。
 * </p>
 * <p>
 * なお、<code>Visitor</code> に関しては、<code>Converter</code>に対する<code>Getter</code>
 * のような”引数を持たないインターフェイス ”を用意していません。 代わりに<code>Runnable</code>でも使っておいてください。<BR>
 * これは、普及度の高いインターフェイスを適用したほうがクラスの汎用性は高まるとの判断によるものです。
 * </p>
 * 
 * @author Fujii Kenichi
 * 
 * @param <T>
 *            引数の型
 */
public interface Visitor<T> {
	public void visit(T object);
}
