package jp.sourceforge.functional.classifier;

import jp.sourceforge.functional.BinaryClassifier;
import jp.sourceforge.functional.Classifier;
import jp.sourceforge.functional.pair.Pair;

public class DelegateBinaryClassifier<T1, T2> extends BinaryClassifier<T1, T2> {

	private final Classifier<? super Pair<? extends T1, ? extends T2>> _classifier;

	public DelegateBinaryClassifier(
			Classifier<? super Pair<? extends T1, ? extends T2>> classifier) {
		_classifier = classifier;
	}

	@Override
	public boolean classify(T1 first, T2 second) {
		return _classifier.classify(Pair.makePair(first, second));
	}
}
