package jp.sourceforge.functional.pair;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ListPair<T, E1 extends T, E2 extends T> extends Pair<E1, E2>
		implements List<T> {

	private final List<T> _list;

	public static final int FIRST_INDEX = 0;
	public static final int SECOND_INDEX = 1;

	public static int oppositeIndex(int index) {
		switch (index) {
		case FIRST_INDEX:
			return SECOND_INDEX;
		case SECOND_INDEX:
			return FIRST_INDEX;
		default:
			throw new IndexOutOfBoundsException("index was " + index);
		}
	}

	public ListPair(final E1 first, final E2 second) {
		super(first, second);
		_list = new AbstractList<T>() {
			@Override
			public T get(int index) {
				switch (index) {
				case FIRST_INDEX:
					return first;
				case SECOND_INDEX:
					return second;
				default:
					throw new IndexOutOfBoundsException("index was " + index);
				}
			}

			@Override
			public int size() {
				return 2;
			}
		};
	}

	public ListPair(Pair<? extends E1, ? extends E2> pair) {
		this(pair.first, pair.second);
	}

	public ListPair(int index, T o) {
		this(index, o, null);
	}

	public ListPair(int index, T index_element, T opposite_element) {
		this(ListPair.<T, E1, E2> make(index, index_element, opposite_element));
	}

	@SuppressWarnings("unchecked")
	public static <T, E1 extends T, E2 extends T> ListPair<T, E1, E2> make(
			int index, T index_element, T opposite_element) {
		switch (index) {
		case FIRST_INDEX:
			return new ListPair<T, E1, E2>((E1) index_element,
					(E2) opposite_element);
		case SECOND_INDEX:
			return new ListPair<T, E1, E2>((E1) opposite_element,
					(E2) index_element);
		default:
			throw new IndexOutOfBoundsException("index was " + index);
		}
	}

	public T getOpposite(int index) {
		switch (index) {
		case FIRST_INDEX:
			return get(SECOND_INDEX);
		case SECOND_INDEX:
			return get(FIRST_INDEX);
		default:
			throw new IndexOutOfBoundsException("index was " + index);
		}
	}

	@Override
	public T getOpposite(Object value) {
		assert contains(value);
		return getOpposite(indexOf(value));
	}

	@SuppressWarnings("unchecked")
	public ListPair<T, E1, E2> arrange(int index, T o) {
		switch (index) {
		case FIRST_INDEX:
			return new ListPair<T, E1, E2>((E1) o, second);
		case SECOND_INDEX:
			return new ListPair<T, E1, E2>(first, (E2) o);
		default:
			throw new IndexOutOfBoundsException("index was " + index);
		}
	}

	public void add(int index, T element) {
		_list.add(index, element);
	}

	public boolean add(T e) {
		return _list.add(e);
	}

	public boolean addAll(Collection<? extends T> c) {
		return _list.addAll(c);
	}

	public boolean addAll(int index, Collection<? extends T> c) {
		return _list.addAll(index, c);
	}

	public void clear() {
		_list.clear();
	}

	public boolean contains(Object o) {
		return _list.contains(o);
	}

	public boolean containsAll(Collection<?> c) {
		return _list.containsAll(c);
	}

	public T get(int index) {
		return _list.get(index);
	}

	public int indexOf(Object o) {
		return _list.indexOf(o);
	}

	public boolean isEmpty() {
		return _list.isEmpty();
	}

	public Iterator<T> iterator() {
		return _list.iterator();
	}

	public int lastIndexOf(Object o) {
		return _list.lastIndexOf(o);
	}

	public ListIterator<T> listIterator() {
		return _list.listIterator();
	}

	public ListIterator<T> listIterator(int index) {
		return _list.listIterator(index);
	}

	public T remove(int index) {
		return _list.remove(index);
	}

	public boolean remove(Object o) {
		return _list.remove(o);
	}

	public boolean removeAll(Collection<?> c) {
		return _list.removeAll(c);
	}

	public boolean retainAll(Collection<?> c) {
		return _list.retainAll(c);
	}

	public T set(int index, T element) {
		return _list.set(index, element);
	}

	public int size() {
		return _list.size();
	}

	public List<T> subList(int fromIndex, int toIndex) {
		return _list.subList(fromIndex, toIndex);
	}

	public Object[] toArray() {
		return _list.toArray();
	}

	@SuppressWarnings("hiding")
	public <T> T[] toArray(T[] a) {
		return _list.toArray(a);
	}
}
