package jp.sourceforge.functional.visit;

import jp.sourceforge.functional.BinaryConverter;
import jp.sourceforge.functional.Visitor;
import jp.sourceforge.functional.pair.Pair;

public abstract class ReportableBinaryVisitor<T1, T2, R> extends
		BinaryConverter<T1, T2, R> implements
		Visitor<Pair<? extends T1, ? extends T2>> {

	@Override
	public void visit(Pair<? extends T1, ? extends T2> pair) {
		convert(pair);
	}

	@Override
	public ReportableVisitor<T2, R> bindFirst(final T1 first) {
		return new ReportableVisitor<T2, R>() {
			@Override
			public R convert(T2 second) {
				return ReportableBinaryVisitor.this.convert(first, second);
			}
		};
	}

	@Override
	public ReportableVisitor<T1, R> bindSecond(final T2 second) {
		return new ReportableVisitor<T1, R>() {
			@Override
			public R convert(T1 first) {
				return ReportableBinaryVisitor.this.convert(first, second);
			}
		};
	}
}
