/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.net.SocketWrapper;

public class UpgradeAprProcessor
extends UpgradeProcessor<Long> {
    private final long socket;

    public UpgradeAprProcessor(SocketWrapper<Long> wrapper, UpgradeInbound upgradeInbound) {
        super(upgradeInbound);
        this.socket = wrapper.getSocket();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(int b) throws IOException {
        Socket.send(this.socket, new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Socket.send(this.socket, b, off, len);
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int result = Socket.recv(this.socket, bytes, 0, 1);
        if (result == -1) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(boolean block, byte[] bytes, int off, int len) throws IOException {
        if (!block) {
            Socket.optSet(this.socket, 8, -1);
        }
        try {
            int result = Socket.recv(this.socket, bytes, off, len);
            if (result > 0) {
                int n = result;
                return n;
            }
            if (-result == 120002) {
                int n = 0;
                return n;
            }
            throw new IOException(sm.getString("apr.error", new Object[]{-result}));
        }
        finally {
            if (!block) {
                Socket.optSet(this.socket, 8, 0);
            }
        }
    }
}

