/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.visitors;

import java.lang.annotation.Annotation;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.PluginVisitorStrategy;
import org.apache.logging.log4j.core.config.plugins.visitors.PluginVisitor;
import org.apache.logging.log4j.status.StatusLogger;

public final class PluginVisitors {
    private static final Logger LOGGER = StatusLogger.getLogger();

    private PluginVisitors() {
    }

    public static <A extends Annotation> PluginVisitor<A> findVisitor(Class<A> annotation) {
        PluginVisitorStrategy strategy = annotation.getAnnotation(PluginVisitorStrategy.class);
        if (strategy == null) {
            LOGGER.debug("No PluginVisitorStrategy found on annotation [{}]. Ignoring.", new Object[]{annotation});
            return null;
        }
        Class<? extends PluginVisitor<? extends Annotation>> visitorClass = strategy.value();
        try {
            return visitorClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Error loading PluginVisitor [{}] for annotation [{}].", new Object[]{visitorClass, annotation, e});
            return null;
        }
    }
}

