/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;

final class DynaBeanFormatter
implements Formatter {
    public static final DynaBeanFormatter INSTANCE = new DynaBeanFormatter();
    private static final Class<?> target = DynaBean.class;

    DynaBeanFormatter() {
    }

    public boolean accept(Object o) {
        return o != null && target.isAssignableFrom(o.getClass());
    }

    public boolean isStruct() {
        return true;
    }

    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        out.append('{');
        int count = 0;
        String key = null;
        try {
            DynaBean bean = (DynaBean)o;
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            if (props == null) {
                props = new DynaProperty[]{};
            }
            JSONHint hint = context.getHint();
            for (DynaProperty dp : props) {
                Object value;
                key = dp.getName();
                if (key == null || (value = bean.get(key)) == src || context.isSuppressNull() && value == null) continue;
                if (count != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    context.appendIndent(out, context.getDepth() + 1);
                }
                StringFormatter.serialize(context, key, out);
                out.append(':');
                if (context.isPrettyPrint()) {
                    out.append(' ');
                }
                context.enter(key, hint);
                key = null;
                value = context.preformatInternal(value);
                context.formatInternal(value, out);
                context.exit();
                ++count;
            }
        }
        catch (Exception e) {
            if (key != null) {
                context.enter(key, null);
            }
            throw e;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            context.appendIndent(out, context.getDepth());
        }
        out.append('}');
    }
}

