/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.parse;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.arnx.jsonic.JSONEventType;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.util.LocalCache;

public class JSONParser {
    static final int BEFORE_ROOT = 0;
    static final int AFTER_ROOT = 1;
    static final int BEFORE_NAME = 2;
    static final int AFTER_NAME = 3;
    static final int BEFORE_VALUE = 4;
    static final int AFTER_VALUE = 5;
    private static final int[] ESCAPE_CHARS = new int[128];
    private InputSource in;
    private int maxDepth;
    private boolean interpretterMode;
    private boolean ignoreWhirespace;
    private LocalCache cache;
    private int state = 0;
    private List<JSONEventType> stack = new ArrayList<JSONEventType>();
    private JSONEventType type;
    private Object value;
    private boolean first;
    private boolean active;

    public JSONParser(InputSource in, int maxDepth, boolean interpretterMode, boolean ignoreWhirespace, LocalCache cache) {
        this.in = in;
        this.maxDepth = maxDepth;
        this.interpretterMode = interpretterMode;
        this.ignoreWhirespace = ignoreWhirespace;
        this.cache = cache;
        this.active = this.stack.size() < maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean isInterpretterMode() {
        return this.interpretterMode;
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhirespace;
    }

    public Object getValue() {
        return this.value;
    }

    public int getDepth() {
        if (this.type == JSONEventType.START_OBJECT || this.type == JSONEventType.START_ARRAY) {
            return this.stack.size();
        }
        return this.stack.size() + 1;
    }

    public JSONEventType next() throws IOException {
        JSONEventType type = null;
        do {
            this.set(null, null, false);
            switch (this.state) {
                case 0: {
                    this.state = this.beforeRoot();
                    break;
                }
                case 1: {
                    this.state = this.afterRoot();
                    break;
                }
                case 2: {
                    this.state = this.beforeName();
                    break;
                }
                case 3: {
                    this.state = this.afterName();
                    break;
                }
                case 4: {
                    this.state = this.beforeValue();
                    break;
                }
                case 5: {
                    this.state = this.afterValue();
                }
            }
            if (this.getDepth() > this.getMaxDepth()) continue;
            type = this.getType();
        } while (this.state != -1 && type == null);
        return type;
    }

    int beforeRoot() throws IOException {
        int n = this.in.next();
        if (n == 65279) {
            n = this.in.next();
        }
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 0;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case -1: {
                if (this.isInterpretterMode()) {
                    return -1;
                }
                throw this.createParseException(this.in, "json.parse.EmptyInputError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterRoot() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 1;
            }
            case -1: {
                return -1;
            }
            case 91: 
            case 123: {
                if (!this.isInterpretterMode()) break;
                this.in.back();
                return 0;
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int beforeName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 2;
            }
            case 34: {
                this.in.back();
                this.set(JSONEventType.NAME, this.parseString(false), false);
                return 3;
            }
            case 125: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 3;
            }
            case 58: {
                return 4;
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int beforeValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 4;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case 34: {
                this.in.back();
                this.set(JSONEventType.STRING, this.parseString(false), true);
                return 5;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                this.set(JSONEventType.NUMBER, this.parseNumber(), true);
                return 5;
            }
            case 116: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("true", Boolean.TRUE), true);
                return 5;
            }
            case 102: {
                this.in.back();
                this.set(JSONEventType.BOOLEAN, this.parseLiteral("false", Boolean.FALSE), true);
                return 5;
            }
            case 110: {
                this.in.back();
                this.set(JSONEventType.NULL, this.parseLiteral("null", null), true);
                return 5;
            }
            case 93: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    int afterValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 5;
            }
            case 44: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    return 2;
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    return 4;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 125: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 93: {
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    void push(JSONEventType type) {
        this.type = type;
        this.stack.add(type);
        this.first = true;
        this.active = this.stack.size() < this.maxDepth;
    }

    void set(JSONEventType type, Object value, boolean isValue) {
        this.type = type;
        this.value = value;
        if (isValue) {
            this.first = false;
        }
    }

    void pop() {
        JSONEventType beginType = this.stack.remove(this.stack.size() - 1);
        if (beginType == JSONEventType.START_OBJECT) {
            this.type = JSONEventType.END_OBJECT;
        } else if (beginType == JSONEventType.START_ARRAY) {
            this.type = JSONEventType.END_ARRAY;
        } else {
            throw new IllegalStateException();
        }
        this.first = false;
        this.active = this.stack.size() < this.maxDepth;
    }

    JSONEventType getBeginType() {
        return !this.stack.isEmpty() ? this.stack.get(this.stack.size() - 1) : null;
    }

    JSONEventType getType() {
        return this.type;
    }

    boolean isFirst() {
        return this.first;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object parseString(boolean any) throws IOException {
        StringBuilder sb = this.active ? this.cache.getCachedBuffer() : null;
        int start = this.in.next();
        int rest = this.in.mark();
        int len = 0;
        int n = -1;
        while ((n = this.in.next()) != -1) {
            --rest;
            ++len;
            if (n < ESCAPE_CHARS.length) {
                int type = ESCAPE_CHARS[n];
                if (type == 0) {
                    if (rest == 0 && sb != null) {
                        this.in.copy(sb, len);
                    }
                } else if (type == 1) {
                    if (n == start) {
                        if (len <= 1 || sb == null) break;
                        this.in.copy(sb, len - 1);
                        break;
                    }
                    if (rest == 0 && sb != null) {
                        this.in.copy(sb, len);
                    }
                } else if (type == 2) {
                    if (len > 0 && sb != null) {
                        this.in.copy(sb, len - 1);
                    }
                    rest = 0;
                    this.in.back();
                    char c = this.parseEscape();
                    if (sb != null) {
                        sb.append(c);
                    }
                } else {
                    if (!any) throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                    if (rest == 0 && sb != null) {
                        this.in.copy(sb, len);
                    }
                }
            } else if (rest == 0 && sb != null) {
                this.in.copy(sb, len);
            }
            if (rest != 0) continue;
            rest = this.in.mark();
            len = 0;
        }
        if (n != start) {
            throw this.createParseException(this.in, "json.parse.StringNotClosedError");
        }
        if (sb == null) return null;
        String string = this.cache.getString(sb);
        return string;
    }

    char parseEscape() throws IOException {
        int point = 1;
        int escape = 0;
        int n = this.in.next();
        block8: while ((n = this.in.next()) != -1) {
            int hex;
            char c = (char)n;
            if (point == 1) {
                switch (c) {
                    case 'b': {
                        escape = 8;
                        break;
                    }
                    case 'f': {
                        escape = 12;
                        break;
                    }
                    case 'n': {
                        escape = 10;
                        break;
                    }
                    case 'r': {
                        escape = 13;
                        break;
                    }
                    case 't': {
                        escape = 9;
                        break;
                    }
                    case 'u': {
                        point = 2;
                        continue block8;
                    }
                    default: {
                        escape = c;
                        break;
                    }
                }
                break;
            }
            int n2 = c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (hex = c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
            if (hex != -1) {
                escape = (char)(escape | hex << (5 - point) * 4);
                if (point == 5) break;
                ++point;
                continue;
            }
            throw this.createParseException(this.in, "json.parse.IllegalUnicodeEscape", Character.valueOf(c));
        }
        return (char)escape;
    }

    Object parseNumber() throws IOException {
        int point = 0;
        StringBuilder sb = this.active ? this.cache.getCachedBuffer() : null;
        int sp = -1;
        int ep = -1;
        int n = -1;
        int rest = this.in.mark();
        int len = 0;
        int count = 0;
        block7: while ((n = this.in.next()) != -1) {
            --rest;
            ++len;
            ++count;
            char c = (char)n;
            switch (c) {
                case '+': {
                    if (point == 7) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 8;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf(c));
                }
                case '-': {
                    if (point == 0) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 1;
                        break;
                    }
                    if (point == 7) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 8;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf(c));
                }
                case '.': {
                    if (point == 2 || point == 3) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 4;
                        sp = count - 1;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf(c));
                }
                case 'E': 
                case 'e': {
                    if (point == 2 || point == 3 || point == 5 || point == 6) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 7;
                        ep = count - 1;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf(c));
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (point == 0 || point == 1) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = c == '0' ? 3 : 2;
                        break;
                    }
                    if (point == 2 || point == 5 || point == 9) {
                        if (rest != 0 || sb == null) break;
                        this.in.copy(sb, len);
                        break;
                    }
                    if (point == 4) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 5;
                        break;
                    }
                    if (point == 7 || point == 8) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 9;
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf(c));
                }
                default: {
                    if (point == 2 || point == 3 || point == 5 || point == 6 || point == 9) {
                        if (len > 1 && sb != null) {
                            this.in.copy(sb, len - 1);
                        }
                        this.in.back();
                        break block7;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf(c));
                }
            }
            if (rest != 0) continue;
            rest = this.in.mark();
            len = 0;
        }
        if (sb != null) {
            int s;
            if (sp == -1 && ep == -1) {
                int n2 = s = sb.charAt(0) == '-' ? 1 : 0;
                if (sb.length() == s + 1) {
                    long num = sb.charAt(s) - 48;
                    if (sb.charAt(0) == '-') {
                        num *= -1L;
                    }
                    return BigDecimal.valueOf(num);
                }
                if (sb.length() < s + 19) {
                    long num = 0L;
                    for (int i = s; i < sb.length(); ++i) {
                        num = num * 10L + (long)(sb.charAt(i) - 48);
                    }
                    if (sb.charAt(0) == '-') {
                        num *= -1L;
                    }
                    return BigDecimal.valueOf(num);
                }
            } else {
                int e;
                s = sb.charAt(0) == '-' ? 1 : 0;
                int n3 = e = ep >= 0 ? ep : sb.length();
                if (e < s + 19) {
                    long num = 0L;
                    for (int i = s; i < e; ++i) {
                        if (i == sp) continue;
                        num = num * 10L + (long)(sb.charAt(i) - 48);
                    }
                    if (sb.charAt(0) == '-') {
                        num *= -1L;
                    }
                    int scale = 0;
                    if (ep >= 0) {
                        int es;
                        for (int i = es = sb.charAt(ep + 1) == '+' || sb.charAt(ep + 1) == '-' ? ep + 2 : ep + 1; i < sb.length(); ++i) {
                            scale = scale * 10 + (sb.charAt(i) - 48);
                        }
                        if (sb.charAt(ep + 1) == '-') {
                            scale *= -1;
                        }
                    }
                    if (sp >= 0) {
                        scale -= e - (sp + 1);
                    }
                    return BigDecimal.valueOf(num, -scale);
                }
            }
            return new BigDecimal(sb.toString());
        }
        return null;
    }

    Object parseLiteral(String expected, Object result) throws IOException {
        int pos = 0;
        int n = -1;
        while ((n = this.in.next()) != -1) {
            char c = (char)n;
            if (pos >= expected.length() || c != expected.charAt(pos++)) break;
            if (pos != expected.length()) continue;
            return this.stack.size() < this.maxDepth ? result : null;
        }
        throw this.createParseException(this.in, "json.parse.UnrecognizedLiteral", expected.substring(0, pos));
    }

    Object parseLiteral(boolean asValue) throws IOException {
        String str;
        boolean point = false;
        StringBuilder sb = this.active ? this.cache.getCachedBuffer() : null;
        int n = -1;
        while ((n = this.in.next()) != -1) {
            if (n == 92) {
                this.in.back();
                n = this.parseEscape();
            }
            if (!point) {
                if (Character.isJavaIdentifierStart(n)) {
                    if (!(this.active || n != 110 && n != 116 && n != 102 || sb == null)) {
                        sb = this.cache.getCachedBuffer();
                    }
                    if (sb != null) {
                        sb.append((char)n);
                    }
                    point = true;
                    continue;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            if (point && (Character.isJavaIdentifierPart(n) || n == 46)) {
                if (!this.active && sb != null && sb.length() == 5) {
                    sb = null;
                }
                if (sb == null) continue;
                sb.append((char)n);
                continue;
            }
            this.in.back();
            break;
        }
        String string = str = sb != null ? this.cache.getString(sb) : null;
        if (asValue && str != null) {
            if ("null".equals(str)) {
                this.type = JSONEventType.NULL;
                return null;
            }
            if ("true".equals(str)) {
                this.type = JSONEventType.BOOLEAN;
                return this.active ? Boolean.TRUE : null;
            }
            if ("false".equals(str)) {
                this.type = JSONEventType.BOOLEAN;
                return this.active ? Boolean.FALSE : null;
            }
        }
        this.type = JSONEventType.STRING;
        return this.active ? str : null;
    }

    String parseComment() throws IOException {
        int point = 0;
        StringBuilder sb = !this.isIgnoreWhitespace() ? this.cache.getCachedBuffer() : null;
        int n = -1;
        int rest = this.in.mark();
        int len = 0;
        block5: while ((n = this.in.next()) != -1) {
            --rest;
            ++len;
            switch (n) {
                case 47: {
                    if (point == 0) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 1;
                        break;
                    }
                    if (point == 1) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 4;
                        break;
                    }
                    if (point == 3) {
                        if (len <= 1 || sb == null) break block5;
                        this.in.copy(sb, len);
                        break block5;
                    }
                    if (point == 2 || point == 4) {
                        if (rest != 0 || sb == null) break;
                        this.in.copy(sb, len);
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                case 42: {
                    if (point == 1) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 2;
                        break;
                    }
                    if (point == 2) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 3;
                        break;
                    }
                    if (point == 3 || point == 4) {
                        if (rest != 0 || sb == null) break;
                        this.in.copy(sb, len);
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                case 10: 
                case 13: {
                    if (point == 2 || point == 3) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 2;
                        break;
                    }
                    if (point == 4) {
                        if (n == 13) {
                            n = this.in.next();
                            this.in.back();
                            if (n == 10) {
                                if (rest != 0 || sb == null) break;
                                this.in.copy(sb, len);
                                break;
                            }
                        }
                        if (len <= 1 || sb == null) break block5;
                        this.in.copy(sb, len);
                        break block5;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                default: {
                    if (point == 3) {
                        if (rest == 0 && sb != null) {
                            this.in.copy(sb, len);
                        }
                        point = 2;
                        break;
                    }
                    if (point == 2 || point == 4) {
                        if (rest != 0 || sb == null) break;
                        this.in.copy(sb, len);
                        break;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
            }
            if (rest != 0) continue;
            rest = this.in.mark();
            len = 0;
        }
        return sb != null ? this.cache.getString(sb) : null;
    }

    String parseWhitespace() throws IOException {
        StringBuilder sb = !this.isIgnoreWhitespace() ? this.cache.getCachedBuffer() : null;
        int n = -1;
        int rest = this.in.mark();
        int len = 0;
        while ((n = this.in.next()) != -1) {
            --rest;
            ++len;
            if (n == 32 || n == 9 || n == 13 || n == 10) {
                if (rest == 0 && sb != null) {
                    this.in.copy(sb, len);
                }
            } else {
                if (len > 1 && sb != null) {
                    this.in.copy(sb, len - 1);
                }
                this.in.back();
                break;
            }
            if (rest != 0) continue;
            rest = this.in.mark();
            len = 0;
        }
        return sb != null ? this.cache.getString(sb) : null;
    }

    JSONException createParseException(InputSource in, String id) {
        return this.createParseException(in, id, null);
    }

    JSONException createParseException(InputSource in, String id, Object ... args) {
        String message = this.cache.getMessage(id, args);
        return new JSONException("" + in.getLineNumber() + ": " + message + "\n" + in.toString() + " <- ?", 200, in.getLineNumber(), in.getColumnNumber(), in.getOffset());
    }

    static {
        for (int i = 0; i < 32; ++i) {
            JSONParser.ESCAPE_CHARS[i] = 3;
        }
        JSONParser.ESCAPE_CHARS[34] = 1;
        JSONParser.ESCAPE_CHARS[39] = 1;
        JSONParser.ESCAPE_CHARS[92] = 2;
        JSONParser.ESCAPE_CHARS[127] = 3;
    }
}

