/*
 * Decompiled with CFR 0.152.
 */
package org.hanei.jaxcel.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.hssf.record.cf.CellRangeUtil;
import org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFTable;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hanei.jaxcel.exception.JaxcelInputException;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTDrawing;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTTwoCellAnchor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTablePart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String INSIDE = "inside";
    public static final String OVERLAP = "overlap";
    public static final String ENCLOSES = "encloses";
    public static final String NO_INTERSECTION = "no_intersection";

    public static int getMaxRowIndex(Sheet sheet) {
        int max;
        log.trace("getMaxRowIndex start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        if (sheet instanceof HSSFSheet) {
            max = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        } else if (sheet instanceof XSSFSheet || sheet instanceof SXSSFSheet) {
            max = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        } else {
            log.error("sheet is unsupported type");
            throw new JaxcelInputException("sheet is unsupported type");
        }
        log.trace("getMaxRowIndex end: {}", (Object)max);
        return max;
    }

    public static int getMaxColumnIndex(Sheet sheet) {
        int max;
        log.trace("getMaxColumnIndex start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        if (sheet instanceof HSSFSheet) {
            max = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        } else if (sheet instanceof XSSFSheet || sheet instanceof SXSSFSheet) {
            max = SpreadsheetVersion.EXCEL2007.getLastColumnIndex();
        } else {
            log.error("sheet is unsupported type");
            throw new JaxcelInputException("sheet is null");
        }
        log.trace("getMaxColumnIndex end: {}", (Object)max);
        return max;
    }

    public static boolean validateRange(Sheet sheet, CellRangeAddress range) {
        log.trace("validateRange start");
        boolean ret = ExcelUtil.validateColumn(sheet, range) && ExcelUtil.validateRow(sheet, range);
        log.trace("validateRange end: {}", (Object)ret);
        return ret;
    }

    public static boolean validateColumn(Sheet sheet, CellRangeAddress range) {
        log.trace("validateColumn start");
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        boolean ret = false;
        int max = ExcelUtil.getMaxColumnIndex(sheet);
        int firstColumn = range.getFirstColumn();
        int lastColumn = range.getLastColumn();
        if (ExcelUtil.isFullRowRange(sheet, range) || firstColumn <= lastColumn && firstColumn >= 0 && firstColumn <= max && lastColumn >= 0 && lastColumn <= max) {
            ret = true;
        }
        log.trace("validateColumn end: {}", (Object)ret);
        return ret;
    }

    public static boolean validateRow(Sheet sheet, CellRangeAddress range) {
        log.trace("validateRow start");
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        boolean ret = false;
        int max = ExcelUtil.getMaxRowIndex(sheet);
        int firstRow = range.getFirstRow();
        int lastRow = range.getLastRow();
        if (ExcelUtil.isFullColumnRange(sheet, range) || firstRow <= lastRow && firstRow >= 0 && firstRow <= max && lastRow >= 0 && lastRow <= max) {
            ret = true;
        }
        log.trace("validateRow end: {}", (Object)ret);
        return ret;
    }

    public static boolean isFullRowRange(Sheet sheet, CellRangeAddress range) {
        log.trace("isFullRowRange start");
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        boolean ret = false;
        int max = ExcelUtil.getMaxColumnIndex(sheet);
        int firstColumn = range.getFirstColumn();
        int lastColumn = range.getLastColumn();
        if (log.isDebugEnabled()) {
            log.debug("sheet max column: {}", (Object)max);
            log.debug("range first column: {}", (Object)firstColumn);
            log.debug("range last column: {}", (Object)lastColumn);
        }
        if (firstColumn == 0 && lastColumn == max || firstColumn == -1 && lastColumn == -1) {
            ret = true;
        }
        log.trace("isFullRowRange end: {}", (Object)ret);
        return ret;
    }

    public static boolean isFullColumnRange(Sheet sheet, CellRangeAddress range) {
        log.trace("isFullColumnRange start");
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        boolean ret = false;
        int max = ExcelUtil.getMaxRowIndex(sheet);
        int firstRow = range.getFirstRow();
        int lastRow = range.getLastRow();
        if (log.isDebugEnabled()) {
            log.debug("sheet max row: {}", (Object)max);
            log.debug("range first row: {}", (Object)firstRow);
            log.debug("range last row: {}", (Object)lastRow);
        }
        if (firstRow == 0 && lastRow == max || firstRow == -1 && lastRow == -1) {
            ret = true;
        }
        log.trace("isFullColumnRange end: {}", (Object)ret);
        return ret;
    }

    public static int getLastColNum(Sheet sheet) {
        log.trace("getLastColNum start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        int maxColNum = ExcelUtil.getLastColNum(sheet, sheet.getFirstRowNum(), sheet.getLastRowNum());
        log.trace("getLastColNum end: {}", (Object)maxColNum);
        return maxColNum;
    }

    public static int getLastColNum(Sheet sheet, int firstRow, int lastRow) {
        log.trace("getLastColNum start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        int fRow = firstRow;
        int lRow = lastRow;
        if (fRow == -1 && lRow == -1) {
            log.info("firstRow and lastRow is -1. set full row range");
            fRow = 0;
            lRow = sheet.getLastRowNum();
        } else {
            if (fRow < 0) {
                log.error("firstRow is lt 0: {}", (Object)fRow);
                throw new JaxcelInputException("firstRow is lt 0");
            }
            if (lRow < 0) {
                log.error("lastRow is lt 0: {}", (Object)lRow);
                throw new JaxcelInputException("lastRow is lt 0");
            }
        }
        if (fRow > lRow) {
            log.warn("firstRow gt lastRow: {}, {}. swap", (Object)fRow, (Object)lRow);
            int tmp = fRow;
            fRow = lRow;
            lRow = tmp;
        }
        short maxColNum = -1;
        for (int i = fRow; i <= lRow; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            maxColNum = row.getLastCellNum() > maxColNum ? row.getLastCellNum() : maxColNum;
        }
        log.trace("getLastColNum end: {}", (Object)maxColNum);
        return maxColNum;
    }

    public static void shift(Sheet sheet, CellRangeAddress range, String direction, int distance) {
        ExcelUtil.shift(sheet, range, direction, distance, true);
    }

    public static void shift(Sheet sheet, CellRangeAddress range, String direction, int distance, boolean block) {
        int colDistance;
        int rowDistance;
        CellRangeAddress fromRange;
        String _direction;
        log.trace("shift start");
        String ROW = "row";
        String COL = "col";
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        CellRangeAddress _range = range;
        if (!ExcelUtil.validateRange(sheet, range)) {
            _range = ExcelUtil.getIntersectRange(sheet, range);
            if (_range == null) {
                log.error("range is illegal: [{}]", (Object)range.formatAsString());
                throw new JaxcelInputException("range is illegal");
            }
            log.info("resize range: [{}]", (Object)_range.formatAsString());
        }
        if (distance == 0) {
            log.debug("distance is 0");
            log.trace("shift end");
            return;
        }
        if (direction == null) {
            log.debug("direction is null. set default: {}", (Object)"row");
            _direction = "row";
        } else if (!"col".equalsIgnoreCase(direction) && !"row".equalsIgnoreCase(direction)) {
            log.debug("direction is illegal argument. set default: {}", (Object)"row");
            _direction = "row";
        } else {
            _direction = direction.toLowerCase();
        }
        if (log.isDebugEnabled()) {
            log.debug("sheet: {}", (Object)sheet.getSheetName());
            log.debug("range: [{}]", (Object)_range.formatAsString());
            log.debug("distance: {}", (Object)distance);
            log.debug("direction: {}", (Object)_direction);
            log.debug("block: {}", (Object)block);
        }
        if ("col".equals(_direction)) {
            int firstIdx = _range.getFirstColumn();
            int lastIdx = block ? ExcelUtil.getLastColNum(sheet, _range.getFirstRow(), _range.getLastRow()) : ExcelUtil.getLastColNum(sheet);
            lastIdx = lastIdx > firstIdx ? lastIdx : firstIdx;
            fromRange = block ? new CellRangeAddress(_range.getFirstRow(), _range.getLastRow(), firstIdx, lastIdx) : new CellRangeAddress(sheet.getFirstRowNum(), sheet.getLastRowNum(), firstIdx, lastIdx);
            rowDistance = 0;
            colDistance = distance;
        } else {
            int firstIdx = _range.getFirstRow();
            int lastIdx = sheet.getLastRowNum() > firstIdx ? sheet.getLastRowNum() : firstIdx;
            fromRange = block ? new CellRangeAddress(firstIdx, lastIdx, _range.getFirstColumn(), _range.getLastColumn()) : new CellRangeAddress(firstIdx, lastIdx, 0, ExcelUtil.getLastColNum(sheet));
            rowDistance = distance;
            colDistance = 0;
        }
        ExcelUtil.moveRange(sheet, fromRange, rowDistance, colDistance, block);
        log.trace("shift end");
    }

    public static String getMoveFormula(Sheet sheet, String formula, int rowDistance, int colDistance) {
        String returnFormula;
        HSSFEvaluationWorkbook fpBook;
        log.trace("getMoveFormula start");
        if (sheet == null) {
            log.warn("sheet is null");
            return formula;
        }
        if (formula == null) {
            log.warn("formula is null");
            return formula;
        }
        if (rowDistance == 0 && colDistance == 0) {
            log.debug("rowDistance and colDistance is 0");
            log.trace("getMoveFormula end");
            return formula;
        }
        if (log.isDebugEnabled()) {
            log.debug("sheet: {}", (Object)sheet.getSheetName());
            log.debug("formula: {}", (Object)formula);
            log.debug("rowDistance: {}", (Object)rowDistance);
            log.debug("colDistance: {}", (Object)colDistance);
        }
        if (sheet instanceof HSSFSheet) {
            fpBook = HSSFEvaluationWorkbook.create((HSSFWorkbook)((HSSFWorkbook)sheet.getWorkbook()));
        } else if (sheet instanceof XSSFSheet) {
            fpBook = XSSFEvaluationWorkbook.create((XSSFWorkbook)((XSSFWorkbook)sheet.getWorkbook()));
        } else {
            log.warn("sheet is unsupported type");
            log.trace("getMoveFormula end");
            return formula;
        }
        boolean parseFlg = false;
        try {
            Ptg[] ptg = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpBook, (int)0, (int)sheet.getWorkbook().getSheetIndex(sheet));
            for (int i = 0; i < ptg.length; ++i) {
                log.trace("from ptg: {}", (Object)ptg[i]);
                if (ptg[i] instanceof AreaPtg) {
                    AreaPtg aPtg = (AreaPtg)ptg[i];
                    if (aPtg.isFirstRowRelative()) {
                        aPtg.setFirstRow(aPtg.getFirstRow() + rowDistance);
                        parseFlg = true;
                    }
                    if (aPtg.isFirstColRelative()) {
                        aPtg.setFirstColumn(aPtg.getFirstColumn() + colDistance);
                        parseFlg = true;
                    }
                    if (aPtg.isLastRowRelative()) {
                        aPtg.setLastRow(aPtg.getLastRow() + rowDistance);
                        parseFlg = true;
                    }
                    if (aPtg.isLastColRelative()) {
                        aPtg.setLastColumn(aPtg.getLastColumn() + colDistance);
                        parseFlg = true;
                    }
                } else if (ptg[i] instanceof RefPtg) {
                    RefPtg rPtg = (RefPtg)ptg[i];
                    if (rPtg.isRowRelative()) {
                        rPtg.setRow(rPtg.getRow() + rowDistance);
                        parseFlg = true;
                    }
                    if (rPtg.isColRelative()) {
                        rPtg.setColumn(rPtg.getColumn() + colDistance);
                        parseFlg = true;
                    }
                }
                log.trace("to ptg: {}", (Object)ptg[i]);
            }
            returnFormula = parseFlg ? FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)((FormulaRenderingWorkbook)fpBook), (Ptg[])ptg) : formula;
        }
        catch (Exception e) {
            log.error("formula parse error: {}", (Object)e.getMessage(), (Object)e);
            returnFormula = formula;
        }
        log.trace("getMoveFormula end: {}", (Object)returnFormula);
        return returnFormula;
    }

    public static void clearRange(Sheet sheet, CellRangeAddress range, boolean clearStyle, boolean clearMerge) {
        int ii;
        CellRangeAddress tmpRange;
        log.trace("clearRange start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        CellRangeAddress _range = range;
        if (!ExcelUtil.validateRange(sheet, range)) {
            _range = ExcelUtil.getIntersectRange(sheet, range);
            if (_range == null) {
                log.error("range is illegal: [{}]", (Object)range.formatAsString());
                throw new JaxcelInputException("range is illegal");
            }
            log.info("resize range: [{}]", (Object)_range.formatAsString());
        }
        if (log.isDebugEnabled()) {
            log.debug("sheet: {}", (Object)sheet.getSheetName());
            log.debug("range: [{}]", (Object)_range.formatAsString());
            log.debug("clearStyle: {}", (Object)clearStyle);
            log.debug("clearMerge: {}", (Object)clearMerge);
        }
        if (clearMerge && sheet.getNumMergedRegions() > 0) {
            for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                tmpRange = sheet.getMergedRegion(i);
                log.trace("mergedRegion renge: [{}]", (Object)tmpRange.formatAsString());
                if (1 == CellRangeUtil.intersect((CellRangeAddress)_range, (CellRangeAddress)tmpRange)) continue;
                log.debug("mergedRegion {}. clear: [{}]", (Object)ExcelUtil.getIntersectString(_range, tmpRange), (Object)tmpRange.formatAsString());
                sheet.removeMergedRegion(i);
                i = -1;
            }
        }
        if (sheet instanceof XSSFSheet) {
            String ref;
            XSSFSheet xSheet = (XSSFSheet)sheet;
            CTAutoFilter af = xSheet.getCTWorksheet().getAutoFilter();
            if (af != null) {
                ref = af.getRef();
                log.trace("auto filter renge: [{}]", (Object)ref);
                tmpRange = CellRangeAddress.valueOf((String)ref);
                switch (CellRangeUtil.intersect((CellRangeAddress)_range, (CellRangeAddress)tmpRange)) {
                    case 2: 
                    case 3: {
                        xSheet.getCTWorksheet().unsetAutoFilter();
                        log.debug("auto filter {}. clear: [{}]", (Object)ExcelUtil.getIntersectString(_range, tmpRange), (Object)ref);
                    }
                }
            }
            for (POIXMLDocumentPart part : xSheet.getRelations()) {
                int i;
                if (part == null) continue;
                log.debug("documentPart class: {}", (Object)part.getClass().getName());
                if (part instanceof XSSFTable) {
                    CTTable table = ((XSSFTable)part).getCTTable();
                    ref = table.getRef();
                    log.trace("table range: [{}]", (Object)ref);
                    tmpRange = CellRangeAddress.valueOf((String)ref);
                    block3 : switch (CellRangeUtil.intersect((CellRangeAddress)_range, (CellRangeAddress)tmpRange)) {
                        case 2: 
                        case 3: {
                            List tableList = xSheet.getCTWorksheet().getTableParts().getTablePartList();
                            for (i = 0; i < tableList.size(); ++i) {
                                if (((CTTablePart)tableList.get(i)).getId() == null || !((CTTablePart)tableList.get(i)).getId().equalsIgnoreCase(part.getPackageRelationship().getId())) continue;
                                xSheet.getCTWorksheet().getTableParts().removeTablePart(i);
                                log.debug("table {}. clear: [{}]", (Object)ExcelUtil.getIntersectString(_range, tmpRange), (Object)ref);
                                break block3;
                            }
                            break;
                        }
                    }
                    continue;
                }
                if (!(part instanceof XSSFDrawing)) continue;
                CTDrawing drawing = ((XSSFDrawing)part).getCTDrawing();
                for (i = 0; i < drawing.getTwoCellAnchorList().size(); ++i) {
                    CTTwoCellAnchor anchor = (CTTwoCellAnchor)drawing.getTwoCellAnchorList().get(i);
                    tmpRange = new CellRangeAddress(anchor.getFrom().getRow(), anchor.getTo().getRow(), anchor.getFrom().getCol(), anchor.getTo().getCol());
                    log.debug("object range: [{}]", (Object)tmpRange.formatAsString());
                    if (1 == CellRangeUtil.intersect((CellRangeAddress)_range, (CellRangeAddress)tmpRange)) continue;
                    drawing.removeTwoCellAnchor(i);
                    log.debug("object {}. delete: [{}]", (Object)ExcelUtil.getIntersectString(_range, tmpRange), (Object)tmpRange.formatAsString());
                    i = -1;
                }
            }
        }
        int n = ii = range.getLastRow() == -1 ? ExcelUtil.getMaxRowIndex(sheet) : range.getLastRow();
        for (int i = range.getFirstRow() == -1 ? 0 : range.getFirstRow(); i <= ii; ++i) {
            int cc;
            Row row = sheet.getRow(i);
            if (row == null) continue;
            int n2 = cc = range.getLastColumn() == -1 ? ExcelUtil.getMaxColumnIndex(sheet) : range.getLastColumn();
            for (int c = range.getFirstColumn() == -1 ? 0 : range.getFirstColumn(); c <= cc; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                ExcelUtil.clearHyperlink(sheet, cell);
                if (clearStyle) {
                    row.removeCell(cell);
                } else {
                    cell.setCellType(3);
                }
                log.debug("cell clear: [{}]", (Object)new CellReference(cell).formatAsString());
            }
        }
        log.trace("clearRange end");
    }

    public static String getIntersectString(CellRangeAddress rangeA, CellRangeAddress rangeB) {
        switch (CellRangeUtil.intersect((CellRangeAddress)rangeA, (CellRangeAddress)rangeB)) {
            case 1: {
                return NO_INTERSECTION;
            }
            case 3: {
                return INSIDE;
            }
            case 4: {
                return ENCLOSES;
            }
        }
        return OVERLAP;
    }

    public static CellRangeAddress getIntersectRange(Sheet sheet, CellRangeAddress range) {
        log.trace("getIntersectRange start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        CellRangeAddress tmpRange = ExcelUtil.getIntersectRange(sheet, new CellRangeAddress(0, ExcelUtil.getMaxRowIndex(sheet), 0, ExcelUtil.getMaxColumnIndex(sheet)), range);
        log.trace("getIntersectRange end : [{}]", (Object)(tmpRange == null ? null : tmpRange.formatAsString()));
        return tmpRange;
    }

    public static CellRangeAddress getIntersectRange(Sheet sheet, CellRangeAddress rangeA, CellRangeAddress rangeB) {
        CellRangeAddress tmpRange;
        log.trace("getIntersectRange start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        if (rangeA == null) {
            log.error("rangeA is null");
            throw new JaxcelInputException("rangeA is null");
        }
        if (rangeB == null) {
            log.error("rangeB is null");
            throw new JaxcelInputException("rangeA is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("sheet: {}", (Object)sheet.getSheetName());
            log.debug("rangeA: [{}]", (Object)rangeA.formatAsString());
            log.debug("rangeB: [{}]", (Object)rangeB.formatAsString());
        }
        if (!ExcelUtil.validateRange(sheet, tmpRange = new CellRangeAddress(rangeA.getFirstRow() >= rangeB.getFirstRow() ? rangeA.getFirstRow() : rangeB.getFirstRow(), rangeA.getLastRow() <= rangeB.getLastRow() ? rangeA.getLastRow() : rangeB.getLastRow(), rangeA.getFirstColumn() >= rangeB.getFirstColumn() ? rangeA.getFirstColumn() : rangeB.getFirstColumn(), rangeA.getLastColumn() <= rangeB.getLastColumn() ? rangeA.getLastColumn() : rangeB.getLastColumn()))) {
            log.debug("rangeA rangeB is not intersect");
            log.trace("getIntersectRange end");
            return null;
        }
        log.trace("getIntersectRange end : {}", (Object)tmpRange.formatAsString());
        return tmpRange;
    }

    public static void moveRange(Sheet sheet, CellRangeAddress range, int rowDistance, int colDistance, boolean block) {
        int r;
        CellRangeAddress tmpRange;
        int i;
        CellRangeAddress toRange;
        log.trace("moveRange start");
        if (sheet == null) {
            log.error("sheet is null");
            throw new JaxcelInputException("sheet is null");
        }
        if (range == null) {
            log.error("range is null");
            throw new JaxcelInputException("range is null");
        }
        if (!ExcelUtil.validateRange(sheet, range)) {
            log.error("range is illegal: [{}]", (Object)range.formatAsString());
            throw new JaxcelInputException("range is illegal");
        }
        if (rowDistance == 0 && colDistance == 0) {
            log.debug("distance is 0");
            log.trace("moveRange end");
            return;
        }
        if (!block && rowDistance != 0 && colDistance != 0) {
            log.info("change block mode");
            block = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("sheet: {}", (Object)sheet.getSheetName());
            log.debug("range: {}", (Object)range.formatAsString());
            log.debug("rowDistance: {}", (Object)rowDistance);
            log.debug("colDistance: {}", (Object)colDistance);
            log.debug("block: {}", (Object)block);
        }
        if ((toRange = ExcelUtil.getIntersectRange(sheet, new CellRangeAddress((range.getFirstRow() == -1 ? 0 : range.getFirstRow()) + rowDistance, (range.getLastRow() == -1 ? sheet.getLastRowNum() : range.getLastRow()) + rowDistance, (range.getFirstColumn() == -1 ? 0 : range.getFirstColumn()) + colDistance, (range.getLastColumn() == -1 ? ExcelUtil.getLastColNum(sheet) : range.getLastColumn()) + colDistance))) == null) {
            log.debug("toRange outside sheet. fromRange clear");
            ExcelUtil.clearRange(sheet, range, true, true);
            log.trace("moveRange end");
            return;
        }
        log.debug("toRange: {}", (Object)toRange.formatAsString());
        ArrayList<CellRangeAddress> mergedRegionList = new ArrayList<CellRangeAddress>();
        if (sheet.getNumMergedRegions() > 0) {
            log.trace("fromRange mergedRegion check");
            block35: for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
                tmpRange = sheet.getMergedRegion(i);
                log.trace("mergedRegion renge: [{}]", (Object)tmpRange.formatAsString());
                switch (CellRangeUtil.intersect((CellRangeAddress)range, (CellRangeAddress)tmpRange)) {
                    case 3: {
                        log.debug("mergedRegion {}. save: [{}]", (Object)ExcelUtil.getIntersectString(range, tmpRange), (Object)tmpRange.formatAsString());
                        mergedRegionList.add(tmpRange);
                        sheet.removeMergedRegion(i);
                        i = -1;
                        continue block35;
                    }
                    case 2: 
                    case 4: {
                        log.debug("mergedRegion {}. remove: [{}]", (Object)ExcelUtil.getIntersectString(range, tmpRange), (Object)tmpRange.formatAsString());
                        sheet.removeMergedRegion(i);
                        i = -1;
                    }
                }
            }
        }
        if (sheet.getNumMergedRegions() > 0) {
            log.trace("toRange mergedRegion check");
            for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
                tmpRange = sheet.getMergedRegion(i);
                log.trace("mergedRegion renge: [{}]", (Object)tmpRange.formatAsString());
                if (1 == CellRangeUtil.intersect((CellRangeAddress)toRange, (CellRangeAddress)tmpRange)) continue;
                log.debug("mergedRegion {}. remove: [{}]", (Object)ExcelUtil.getIntersectString(toRange, tmpRange), (Object)tmpRange.formatAsString());
                sheet.removeMergedRegion(i);
                i = -1;
            }
        }
        if (!mergedRegionList.isEmpty()) {
            for (CellRangeAddress mergedRegion : mergedRegionList) {
                tmpRange = ExcelUtil.getIntersectRange(sheet, new CellRangeAddress(mergedRegion.getFirstRow() + rowDistance, mergedRegion.getLastRow() + rowDistance, mergedRegion.getFirstColumn() + colDistance, mergedRegion.getLastColumn() + colDistance));
                if (tmpRange != null) {
                    sheet.addMergedRegion(tmpRange);
                    log.debug("mergedRegion move. from: [{}] to: [{}]", (Object)mergedRegion.formatAsString(), (Object)tmpRange.formatAsString());
                    continue;
                }
                log.debug("mergedRegion move to outside sheet. clear: [{}]", (Object)mergedRegion.formatAsString());
            }
        }
        if (sheet instanceof XSSFSheet) {
            XSSFSheet xSheet = (XSSFSheet)sheet;
            try {
                String ref;
                CTAutoFilter af = xSheet.getCTWorksheet().getAutoFilter();
                if (af != null) {
                    ref = af.getRef();
                    log.trace("auto filter range: [{}]", (Object)ref);
                    tmpRange = CellRangeAddress.valueOf((String)ref);
                    switch (CellRangeUtil.intersect((CellRangeAddress)range, (CellRangeAddress)tmpRange)) {
                        case 2: {
                            xSheet.getCTWorksheet().unsetAutoFilter();
                            log.debug("auto filter clear: [{}]", (Object)ref);
                            break;
                        }
                        case 3: {
                            tmpRange.setFirstRow(tmpRange.getFirstRow() + rowDistance);
                            tmpRange.setLastRow(tmpRange.getLastRow() + rowDistance);
                            tmpRange.setFirstColumn(tmpRange.getFirstColumn() + colDistance);
                            tmpRange.setLastColumn(tmpRange.getLastColumn() + colDistance);
                            if (ExcelUtil.validateRange((Sheet)xSheet, tmpRange)) {
                                xSheet.setAutoFilter(tmpRange);
                                log.debug("auto filter move from: [{}] to: [{}]", (Object)ref, (Object)tmpRange.formatAsString());
                                break;
                            }
                            xSheet.getCTWorksheet().unsetAutoFilter();
                            log.debug("auto filter move to outside sheet. clear: [{}]", (Object)ref);
                            break;
                        }
                        case 1: {
                            switch (CellRangeUtil.intersect((CellRangeAddress)toRange, (CellRangeAddress)tmpRange)) {
                                case 2: 
                                case 3: {
                                    xSheet.getCTWorksheet().unsetAutoFilter();
                                    log.debug("auto filter clear: [{}]", (Object)ref);
                                }
                            }
                        }
                    }
                }
                for (POIXMLDocumentPart part : xSheet.getRelations()) {
                    CTDrawing ctDrawing;
                    if (part == null) continue;
                    log.debug("DocumentPart class: {}", (Object)part.getClass().getName());
                    if (part instanceof XSSFTable) {
                        CTTable ctTable = ((XSSFTable)part).getCTTable();
                        ref = ctTable.getRef();
                        log.debug("table ref: [{}]", (Object)ref);
                        tmpRange = CellRangeAddress.valueOf((String)ref);
                        switch (CellRangeUtil.intersect((CellRangeAddress)range, (CellRangeAddress)tmpRange)) {
                            case 2: {
                                ExcelUtil.clearTable((Sheet)xSheet, part.getPackageRelationship().getId());
                                log.debug("table clear: [{}]", (Object)ref);
                                break;
                            }
                            case 3: {
                                tmpRange.setFirstRow(tmpRange.getFirstRow() + rowDistance);
                                tmpRange.setLastRow(tmpRange.getLastRow() + rowDistance);
                                tmpRange.setFirstColumn(tmpRange.getFirstColumn() + colDistance);
                                tmpRange.setLastColumn(tmpRange.getLastColumn() + colDistance);
                                if (ExcelUtil.validateRange((Sheet)xSheet, tmpRange)) {
                                    ctTable.setRef(tmpRange.formatAsString());
                                    log.debug("table move from: [{}] to: [{}]", (Object)ref, (Object)tmpRange.formatAsString());
                                    break;
                                }
                                ExcelUtil.clearTable((Sheet)xSheet, part.getPackageRelationship().getId());
                                log.debug("table clear: [{}]", (Object)ref);
                                break;
                            }
                            case 1: {
                                switch (CellRangeUtil.intersect((CellRangeAddress)toRange, (CellRangeAddress)tmpRange)) {
                                    case 2: 
                                    case 3: {
                                        ExcelUtil.clearTable((Sheet)xSheet, part.getPackageRelationship().getId());
                                        log.debug("table clear: [{}]", (Object)ref);
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    if (!(part instanceof XSSFDrawing) || (ctDrawing = ((XSSFDrawing)part).getCTDrawing()) == null) continue;
                    block39: for (int i2 = 0; i2 < ctDrawing.getTwoCellAnchorList().size(); ++i2) {
                        CTTwoCellAnchor fAnchor = (CTTwoCellAnchor)ctDrawing.getTwoCellAnchorList().get(i2);
                        CTMarker from = fAnchor.getFrom();
                        int r1 = from.getRow();
                        int c1 = from.getCol();
                        CTMarker to = fAnchor.getTo();
                        int r2 = to.getRow();
                        int c2 = to.getCol();
                        tmpRange = new CellRangeAddress(r1, r2, c1, c2);
                        switch (CellRangeUtil.intersect((CellRangeAddress)toRange, (CellRangeAddress)tmpRange)) {
                            case 2: 
                            case 3: {
                                if (CellRangeUtil.intersect((CellRangeAddress)range, (CellRangeAddress)tmpRange) == 1) {
                                    ctDrawing.removeTwoCellAnchor(i2);
                                    log.debug("object delete : [{}]", (Object)tmpRange.formatAsString());
                                    --i2;
                                    continue block39;
                                }
                            }
                            default: {
                                switch (CellRangeUtil.intersect((CellRangeAddress)range, (CellRangeAddress)tmpRange)) {
                                    case 2: 
                                    case 3: {
                                        from.setRow(r1 + rowDistance);
                                        to.setRow(r2 + rowDistance);
                                        from.setCol(c1 + colDistance);
                                        to.setCol(c2 + colDistance);
                                        if (!ExcelUtil.validateRange((Sheet)xSheet, new CellRangeAddress(from.getRow(), to.getRow(), from.getCol(), to.getCol()))) {
                                            ctDrawing.removeTwoCellAnchor(i2);
                                            log.debug("object delete : [{}]", (Object)tmpRange.formatAsString());
                                            --i2;
                                            continue block39;
                                        }
                                        log.debug("object move from: [{}] to: [{}]", (Object)tmpRange.formatAsString(), (Object)new CellRangeAddress(from.getRow(), to.getRow(), from.getCol(), to.getCol()).formatAsString());
                                        continue block39;
                                    }
                                }
                                log.debug("object not move: [{}]", (Object)tmpRange.formatAsString());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("object move error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        int n = r = rowDistance < 0 ? range.getFirstRow() : range.getLastRow();
        while (rowDistance < 0 && r <= range.getLastRow() || rowDistance >= 0 && r >= range.getFirstRow()) {
            int c;
            Row tRow;
            Row fRow;
            Row row = fRow = sheet.getRow(r) == null ? sheet.createRow(r) : sheet.getRow(r);
            if (r + rowDistance < 0 || r + rowDistance > ExcelUtil.getMaxRowIndex(sheet)) {
                tRow = null;
            } else {
                Row row2 = tRow = sheet.getRow(r + rowDistance) == null ? sheet.createRow(r + rowDistance) : sheet.getRow(r + rowDistance);
                if (!block && rowDistance != 0) {
                    tRow.setHeight(fRow.getHeight());
                }
            }
            int n2 = c = colDistance < 0 ? range.getFirstColumn() : range.getLastColumn();
            while (colDistance < 0 && c <= range.getLastColumn() || colDistance >= 0 && c >= range.getFirstColumn()) {
                Cell tCell;
                Cell fCell = fRow.getCell(c);
                if (tRow == null || c + colDistance < 0 || c + colDistance > ExcelUtil.getMaxColumnIndex(sheet)) {
                    tCell = null;
                } else {
                    Cell cell = tCell = tRow.getCell(c + colDistance) == null ? tRow.createCell(c + colDistance) : tRow.getCell(c + colDistance);
                    if (!block && colDistance != 0 && c == (colDistance < 0 ? range.getFirstColumn() : range.getLastColumn())) {
                        sheet.setColumnWidth(tCell.getColumnIndex(), sheet.getColumnWidth(c));
                    }
                }
                if (fCell != null || tCell != null) {
                    if (fCell == null && tCell != null) {
                        log.debug("clear cell: [{}]", (Object)new CellReference(tCell).formatAsString());
                        ExcelUtil.clearHyperlink(sheet, tCell);
                        tRow.removeCell(tCell);
                    } else if (fCell != null && tCell == null) {
                        log.debug("cell move to outside sheet. clear cell: [{}]", (Object)new CellReference(fCell).formatAsString());
                        ExcelUtil.clearHyperlink(sheet, fCell);
                        fRow.removeCell(fCell);
                    } else {
                        log.debug("move cell. from: [{}] to: [{}]", (Object)new CellReference(fCell).formatAsString(), (Object)new CellReference(tCell).formatAsString());
                        tCell.setCellType(3);
                        tCell.setCellStyle(fCell.getCellStyle());
                        switch (fCell.getCellType()) {
                            case 4: {
                                tCell.setCellType(4);
                                tCell.setCellValue(fCell.getBooleanCellValue());
                                break;
                            }
                            case 5: {
                                tCell.setCellType(5);
                                tCell.setCellErrorValue(fCell.getErrorCellValue());
                                break;
                            }
                            case 2: {
                                tCell.setCellType(2);
                                tCell.setCellFormula(ExcelUtil.getMoveFormula(sheet, fCell.getCellFormula(), rowDistance, colDistance));
                                break;
                            }
                            case 0: {
                                tCell.setCellType(0);
                                tCell.setCellValue(fCell.getNumericCellValue());
                                break;
                            }
                            case 1: {
                                tCell.setCellType(1);
                                tCell.setCellValue(fCell.getRichStringCellValue());
                            }
                        }
                        ExcelUtil.moveHyperlink(sheet, fCell, tCell);
                        fRow.removeCell(fCell);
                    }
                }
                c = colDistance < 0 ? c + 1 : c - 1;
            }
            r = rowDistance < 0 ? r + 1 : r - 1;
        }
        log.trace("moveRange end");
    }

    private static void clearTable(Sheet sheet, String tableId) {
        if (sheet instanceof XSSFSheet) {
            XSSFSheet xSheet = (XSSFSheet)sheet;
            List tableList = xSheet.getCTWorksheet().getTableParts().getTablePartList();
            for (int i = 0; i < tableList.size(); ++i) {
                if (((CTTablePart)tableList.get(i)).getId() == null || !((CTTablePart)tableList.get(i)).getId().equalsIgnoreCase(tableId)) continue;
                xSheet.getCTWorksheet().getTableParts().removeTablePart(i);
                break;
            }
        }
    }

    private static void moveHyperlink(Sheet sheet, Cell fromCell, Cell toCell) {
        if (fromCell.getHyperlink() != null && sheet instanceof XSSFSheet) {
            toCell.setHyperlink(fromCell.getHyperlink());
            log.debug("hyperlink move. from: [{}] to: [{}]", (Object)new CellReference(fromCell).formatAsString(), (Object)new CellReference(toCell).formatAsString());
            ExcelUtil.clearHyperlink(sheet, fromCell);
        }
    }

    private static void clearHyperlink(Sheet sheet, Cell cell) {
        if (sheet instanceof XSSFSheet && cell.getHyperlink() != null) {
            try {
                Field field = XSSFSheet.class.getDeclaredField("hyperlinks");
                field.setAccessible(true);
                List hyperlinks = (List)field.get(sheet);
                hyperlinks.remove(cell.getHyperlink());
                log.debug("hyperlink clear: [{}]", (Object)new CellReference(cell).formatAsString());
            }
            catch (Exception e) {
                log.error("hyperlink clear error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

