<?php
/*
 * Jeans CMS (GPL license)
 * $Id: install.php 259 2010-08-30 07:16:40Z kmorimatsu $
 */

class install extends jeans{
	static private $language=array();
	static private $default=false;
	static public function init(){
		// List up available language files.
		$dir = dir(dirname(__FILE__).'/install/language');
		while (false !== ($entry = $dir->read())) {
			if (preg_match('/^(.+)\.php$/',$entry,$m)) self::$language[]=$m[1];
		}
		$dir->close();
		// Load language file
		if (isset($_GET['language']) && in_array($_GET['language'],self::$language)) {
			self::include_local(dirname(__FILE__).'/install/language/',$_GET['language'].'.php');
		}
		// Detemine user's default language from header from browser.
		if (preg_match_all('/[a-z\-]+/i',$_SERVER['HTTP_ACCEPT_LANGUAGE'],$matches,PREG_SET_ORDER)) {
			foreach($matches as $m){
				$lang=self::language($m[0]);
				if (!in_array($lang,self::$language)) continue;
				self::$default=$lang;
				break;
			}
		}
		if (self::$default && !defined('_INSTALL_WELCOME')) {
			self::include_local(dirname(__FILE__).'/install/language/',self::$default.'.php');
		}
	}
	static public function selector(){
		if (!isset($_GET['language'])) $template='language';
		elseif (!in_array($_GET['language'],self::$language)) $template='language';
		elseif (count($_POST)) {
			// Posted values are handled here.
			// Action cannot be used because ticket class is not available.
			self::posted();
			if (!core::error_exists()) $template='done';
			elseif (error::fatal()) $template='failed';
			else $template='install';
		} else $template='install';
		$skin='/install/skin.inc';
		$parent_skin=false;
		$data=false;
		view::parse_skin($skin,$parent_skin,$data,$template);
	}
	static public function tag_setdata(&$data){
		$data['sitename']='My Jeans CMS';
		$data['timezone']=@date_default_timezone_get();
		foreach(self::item_from_post() as $key=>$value) $data[$key]=$value;
	}
	static private function item_from_post(){
		$post=array();
		foreach($_POST as $key=>$value){
			if (substr($key,-5)=='_text') $key=substr($key,0,-5);
			$post[$key]=$value;
		}
		return $post;
	}
	static private function posted(){
		// Check values
		$post=self::item_from_post();
		if (empty($post['sitename'])) error::note('_INSTALL_NO_SITE_NAME');
		if (!@date_default_timezone_set($post['timezone'])) error::note('_INSTALL_INVALIED_TIME_ZONE');
		if (empty($post['email'])) error::note('_INSTALL_NO_EMAIL');
		if (empty($post['loginname'])) error::note('_INSTALL_NO_LOGIN_NAME');
		if (empty($post['name'])) error::note('_INSTALL_NO_NAME');
		if (strlen($post['password1'])<6) error::note('_INSTALL_PASSWORD_TOO_SHORT');
		if ($post['password1']!=$post['password2']) error::note('_INSTALL_PASSWORD_MISMATCH');
		if (core::error_exists()) return;
		$post['password']=hash('sha512',_HASH_SALT.$post['password1']);
		unset($post['password1']);
		unset($post['password2']);
		
		// Add additional information
		$url=substr(_DIR_ROOT,strlen(realpath($_SERVER['SCRIPT_FILENAME']))-strlen($_SERVER['SCRIPT_NAME']));
		$url=strtr($url,'\\','/');
		$url='/'.preg_replace('#(^/+|/+$)#','',$url).'/';
		if ($url=='//') $url='/';
		$url=self::hsc('http://'.$_SERVER['HTTP_HOST'].$url);
		$post['url_index']=$url;
		$post['url_skins']=$url.'skins/';
		$post['url_admin']=$url.'jeans/';
		$post['url_plugins']=$url.'jeans/plugins/';
		$post['cookie_prefix']='jeans_'.preg_replace('/[0-9]/','',sha1(__FILE__)).'_';
		
		// Construct main DB
		ob_start();
		view::parse_skin('/install/sqlmain.inc',false,$post);
		$query=ob_get_clean();
		if (!self::query($query,'main')) return;
		
		// Construct member DB
		sql::init('member',_CONF_DB_LOGIN);
		ob_start();
		view::parse_skin('/install/sqlmember.inc',false,$post);
		$query=ob_get_clean();
		if (!self::query($query,'member')) return;

		// Save the default settings
		$query='SELECT d.name as name, d.defvalue as value, c.id as id 
			FROM jeans_config_desc as d 
			LEFT JOIN jeans_config as c 
			ON d.name=c.name AND c.type="global" AND c.owner="jeans" and c.contextid=0 
			WHERE d.configtype="global" AND d.owner="jeans" AND NOT d.type="separator"';
		$res=sql::query($query);
		$query='INSERT OR REPLACE INTO jeans_config(name,value) VALUES (<%name%>,<%value%>)';
		while ($row=$res->fetch()) {
			if (!$row['id']) sql::register_shutdown_query($query,$row);
		}
	}
	static private function query($query,$mode='main'){
		if (preg_match_all("/((?:[^';]*|'[^']*')*);/",$query,$matches,PREG_SET_ORDER)) {
			sql::begin($mode);
			foreach($matches as $m){
				sql::select_pdo($mode);
				$res=sql::query($m[1]);
				if (sql::pdo($mode)->errorCode()=='0000') continue;
				sql::commit($mode);
				$e=sql::pdo($mode)->errorInfo();
				error::fatal('SQLite error: <%0%>',$e[2]);
				error::fatal('<%0%>',$m[1]);
				return false;
			}
			sql::commit($mode);
		}
		return true;
	}
	static public function tag_langlist(&$data,$skin){
		$array=array();
		foreach(self::$language as $lang) {
			$row=array('language'=>$lang);
			if ($lang==self::$default) $row['selected']=true;
			$array[]=$row;
		}
		view::show_using_array($data,$array,$skin);
	}
	static public function if_dbok(){
		$file=dirname(_CONF_DB_LOGIN.'/.htdummy');
		$handle=@fopen($file,'w');
		if ($handle) {
			fclose($handle);
			unlink($file);
			return true;
		} else {
			return false;
		}
	}
	static private function language($shortname){
		switch(strtolower($shortname)){
			case 'af':     return 'afrikaans';
			case 'sq':     return 'albanian';
			case 'ar-dz':  return 'arabic-dz';
			case 'ar-bh':  return 'arabic-bh';
			case 'ar-eg':  return 'arabic-eg';
			case 'ar-iq':  return 'arabic-iq';
			case 'ar-jo':  return 'arabic-jo';
			case 'ar-kw':  return 'arabic-kw';
			case 'ar-lb':  return 'arabic-lb';
			case 'ar-ly':  return 'arabic-ly';
			case 'ar-ma':  return 'arabic-ma';
			case 'ar-om':  return 'arabic-om';
			case 'ar-qa':  return 'arabic-qa';
			case 'ar-sa':  return 'arabic-sa';
			case 'ar-sy':  return 'arabic-sy';
			case 'ar-tn':  return 'arabic-tn';
			case 'ar-ae':  return 'arabic-ae';
			case 'ar-ye':  return 'arabic-ye';
			case 'ar':     return 'arabic';
			case 'hy':     return 'armenian';
			case 'as':     return 'assamese';
			case 'az':     return 'azeri';
			case 'az':     return 'azeri';
			case 'eu':     return 'basque';
			case 'be':     return 'belarusian';
			case 'bn':     return 'bengali';
			case 'bg':     return 'bulgarian';
			case 'ca':     return 'catalan';
			case 'zh-cn':  return 'chinese-cn';
			case 'zh-hk':  return 'chinese-hk';
			case 'zh-mo':  return 'chinese-mo';
			case 'zh-sg':  return 'chinese-sg';
			case 'zh-tw':  return 'chinese-tw';
			case 'zh':     return 'chinese';
			case 'hr':     return 'croatian';
			case 'cs':     return 'chech';
			case 'da':     return 'danish';
			case 'div':    return 'divehi';
			case 'nl-be':  return 'dutch-be';
			case 'nl':     return 'dutch';
			case 'en-au':  return 'english-au';
			case 'en-bz':  return 'english-bz';
			case 'en-ca':  return 'english-ca';
			case 'en-ie':  return 'english-ie';
			case 'en-jm':  return 'english-jm';
			case 'en-nz':  return 'english-nz';
			case 'en-ph':  return 'english-ph';
			case 'en-za':  return 'english-za';
			case 'en-tt':  return 'english-tt';
			case 'en-gb':  return 'english-gb';
			case 'en-us':  return 'english-us';
			case 'en-zw':  return 'english-zw';
			case 'en':     return 'english';
			case 'et':     return 'estonian';
			case 'fo':     return 'faeroese';
			case 'fa':     return 'farsi';
			case 'fi':     return 'finnish';
			case 'fr-be':  return 'french-be';
			case 'fr-ca':  return 'french-ca';
			case 'fr':     return 'french';
			case 'fr-lu':  return 'french-lu';
			case 'fr-mc':  return 'french-mc';
			case 'fr-ch':  return 'french-ch';
			case 'mk':     return 'fyro';
			case 'gd':     return 'gaelic';
			case 'ka':     return 'georgian';
			case 'de-at':  return 'german-at';
			case 'de':     return 'german';
			case 'de-li':  return 'german-li';
			case 'de-lu':  return 'german-lu';
			case 'de-ch':  return 'german-ch';
			case 'el':     return 'greek';
			case 'gu':     return 'gujarati';
			case 'he':     return 'hebrew';
			case 'hi':     return 'hindi';
			case 'hu':     return 'hungarian';
			case 'is':     return 'icelandic';
			case 'id':     return 'indonesian';
			case 'it':     return 'italian';
			case 'it-ch':  return 'italian-ch';
			case 'ja':     return 'japanese';
			case 'kn':     return 'kannada';
			case 'kk':     return 'kazakh';
			case 'kok':    return 'konkani';
			case 'ko':     return 'korean';
			case 'kz':     return 'kyrgyz';
			case 'lv':     return 'latvian';
			case 'lt':     return 'lithuanian';
			case 'ms':     return 'malay';
			case 'ms':     return 'malay';
			case 'ml':     return 'malayalam';
			case 'mt':     return 'maltese';
			case 'mr':     return 'marathi';
			case 'mn':     return 'mongolian';
			case 'ne':     return 'nepali';
			case 'nb-no':  return 'norwegian-nb';
			case 'no':     return 'norwegian';
			case 'nn-no':  return 'norwegian-nn';
			case 'or':     return 'oriya';
			case 'pl':     return 'polish';
			case 'pt-br':  return 'portuguese-br';
			case 'pt':     return 'portuguese';
			case 'pa':     return 'punjabi';
			case 'rm':     return 'rhaeto';
			case 'ro-md':  return 'romanian-md';
			case 'ro':     return 'romanian';
			case 'ru-md':  return 'russian-md';
			case 'ru':     return 'russian';
			case 'sa':     return 'sanskrit';
			case 'sr':     return 'serbian';
			case 'sr':     return 'serbian';
			case 'sk':     return 'slovak';
			case 'ls':     return 'slovenian';
			case 'sb':     return 'sorbian';
			case 'es-ar':  return 'spanish-ar';
			case 'es-bo':  return 'spanish-bo';
			case 'es-cl':  return 'spanish-cl';
			case 'es-co':  return 'spanish-co';
			case 'es-cr':  return 'spanish-cr';
			case 'es-do':  return 'spanish-do';
			case 'es-ec':  return 'spanish-ec';
			case 'es-sv':  return 'spanish-sv';
			case 'es-gt':  return 'spanish-gt';
			case 'es-hn':  return 'spanish-hn';
			case 'es':     return 'spanish';
			case 'es-mx':  return 'spanish-mx';
			case 'es-ni':  return 'spanish-ni';
			case 'es-pa':  return 'spanish-pa';
			case 'es-py':  return 'spanish-py';
			case 'es-pe':  return 'spanish-pe';
			case 'es-pr':  return 'spanish-pr';
			case 'es':     return 'spanish';
			case 'es-us':  return 'spanish-us';
			case 'es-uy':  return 'spanish-uy';
			case 'es-ve':  return 'spanish-ve';
			case 'sx':     return 'sutu';
			case 'sw':     return 'swahili';
			case 'sv-fi':  return 'swedish-fi';
			case 'sv':     return 'swedish';
			case 'syr':    return 'syriac';
			case 'ta':     return 'tamil';
			case 'tt':     return 'tatar';
			case 'te':     return 'telugu';
			case 'th':     return 'thai';
			case 'ts':     return 'tsonga';
			case 'tn':     return 'tswana';
			case 'tr':     return 'turkish';
			case 'uk':     return 'ukrainian';
			case 'ur':     return 'urdu';
			case 'uz':     return 'uzbek';
			case 'uz':     return 'uzbek';
			case 'vi':     return 'vietnamese';
			case 'xh':     return 'xhosa';
			case 'yi':     return 'yiddish';
			default:       return false;
		}
	}
}