<?php
/*
 * Jeans CMS (GPL license)
 * $Id: admin_media.php 283 2010-09-23 23:38:46Z kmorimatsu $
 */

class admin_media extends jeans {
	static private $max_size,$accepted;
	static public function init(){
		// Authority check for the action.
		$warning=self::translate('_ADMIN_NO_PERMISSION');
		$mid=isset($_GET['mid']) ? intval($_GET['mid']) : member::setting('id');
		if (!_CONF_ALLOW_FILE_UPLOAD || !member::logged_in()) error::quit($warning);
		if (member::is_admin()) {
			self::$max_size=_CONF_MAX_UPLOAD_SIZE;
		} elseif ($mid==member::setting('id')) {
			$max_size=_CONF_MAX_UPLOAD_SIZE;
			$max_total=_CONF_MAX_UPLOAD_TOTAL;
			$res=sql::query('SELECT binsize FROM jeans_binary WHERE type="media" AND contextid=<%0%>',member::setting('id'));
			while ($row=$res->fetch()) $max_total=$max_total-$row['binsize'];
			if ($max_total < $max_size) $max_size=$max_total;
		} else error::quit($warning);
		self::member_id($mid);
		self::$accepted=preg_split('/[^a-zA-Z0-9]+/',strtolower(_CONF_ALLOW_FILE_TYPES),-1,PREG_SPLIT_NO_EMPTY);
		// Thumbnail
		if (!defined('_CONF_THUMBNAIL_SIZE')) define('_CONF_THUMBNAIL_SIZE',64);
	}
	static private function member_id($set=false){
		static $mid;
		if ($set && !isset($mid)) $mid=$set;
		return $mid;
	}
	static public function action_post_upload(){
		// Get information of uploaded file
		if (!isset($_FILES['binfile'])) return error::note('_ADMIN_MEDIA_FILE_NOT_FOUND');
		$file=&$_FILES['binfile'];
		switch ($file['error']) {
			case UPLOAD_ERR_OK:
				break;
			case UPLOAD_ERR_INI_SIZE: case UPLOAD_ERR_FORM_SIZE:
				@unlink($file['tmp_name']);
				return error::note('_ADMIN_MEDIA_FILE_TOO_LARGE');
			default:
				@unlink($file['tmp_name']);
				return error::note('_ADMIN_MEDIA_UNKNOWN_ERROR');
		}
		// Check if upload is accepted to this file.
		$size=filesize($file['tmp_name']);
		if (self::$max_size < $size) {
			@unlink($file['tmp_name']);
			return error::note(self::translate('_ADMIN_MEDIA_FILE_TOO_LARGE').'(max: '.self::$max_size.')');
		}
		if (!preg_match('/^(.+\.)([a-zA-Z0-9]+)$/',trim($file['name']),$m)) {
			@unlink($file['tmp_name']);
			return error::note('_ADMIN_MEDIA_INVALID_FILENAME');
		}
		$m[2]=strtolower($m[2]);
		if (!in_array($m[2],self::$accepted)) {
			@unlink($file['tmp_name']);
			return error::note('_ADMIN_MEDIA_INVALID_FILE_TYPE');
		}
		$m[1]=self::utf8($m[1]);
		if (strlen($m[1])==0) {
			@unlink($file['tmp_name']);
			return error::note('_ADMIN_MEDIA_INVALID_FILENAME');
		}
		// Get image information and thumbnail if possible
		$mime=self::mime($m[2]);
		$xml=new SimpleXMLElement(_XML_BLANC);
		if (preg_match('#^image/#i',$mime)) {
			$gd=self::gd($file['tmp_name'],$mime);
			if ($gd) {
				$thumbnail=$gd[2];
			} else {
				$gd=@getimagesize($file['tmp_name']);
				$thumbnail=false;
			}
			if ($size) {
				$xml->width=$gd[0];
				$xml->height=$gd[1];
			}
		} else $thumbnail=false;
		// Save image to DB
		$file_name=$m[1].$m[2];
		$file_name=preg_replace(_PREG_NON_SAFE_CHAR,'_',$file_name);
		if (_CONF_PREFIX_UPLOADED_FILES) $file_name=substr(_NOW,0,10).'-'.$file_name;
		$query='INSERT INTO jeans_binary (<%key:row%>) VALUES (<%row%>)';
		$row=array('type'=>'media','name'=>$file_name,'contextid'=>self::member_id(),'time'=>_NOW,
			'bindata'=>file_get_contents($file['tmp_name']),'binsize'=>$size,'mime'=>$mime,'xml'=>$xml->asXML());
		$res=sql::query($query,array('row'=>$row));
		unlink($file['tmp_name']);
		// Save thumbnail if available
		if ($thumbnail) {
			$xml->width=$thumbnail['width'];
			$xml->height=$thumbnail['height'];
			$row=array('type'=>'thumbnail','name'=>$file_name,'contextid'=>self::member_id(),'time'=>_NOW,
				'bindata'=>$thumbnail['file'],'binsize'=>strlen($thumbnail['file']),'mime'=>$thumbnail['mime'],'xml'=>$xml->asXML());
			sql::query($query,array('row'=>$row));
		}
		if ($res->rowCount()) {
			error::note('_ADMIN_MEDIA_UPLOAD_DONE');
			$array=array('name'=>$file_name,'size'=>$size,'mime'=>$mime,'time'=>_NOW);
			foreach($xml as $key=>$value) $array[$key]=$value;
			$array['type']=isset($array['width']) ? 'image':'media';
			// Set information of the uploaded file
			self::uploaded_file($array);
		} else {
			error::note('_ADMIN_MEDIA_UPLOAD_FAILED');
		}
	}
	static public function gd($file,$mime){
		// Check if GD is available.
		switch ($mime) {
			case 'image/gif':
				$func='imagecreatefromgif';
				break;
			case 'image/jpeg':
				$func='imagecreatefromjpeg';
				break;
			case 'image/png':
				$func='imagecreatefrompng';
				break;
			case 'image/bmp':
				$func='imagecreatefromwbmp';
				break;
			case 'image/x-xbitmap':
				$func='imagecreatefromxbm';
				break;
			case 'image/x-xpixmap':
				$func='imagecreatefromxpm';
				break;
			default:
				return false;
		}
		if (!function_exists($func)) return false;
		$image=call_user_func_array($func,array($file));
		if (!$image) return false;
		// Determine the size.
		$width=imagesx($image);
		$height=imagesy($image);
		// Decide the new size.
		if ($width>$height) {
			$new_width=intval(_CONF_THUMBNAIL_SIZE);
			$new_height=intval($height * _CONF_THUMBNAIL_SIZE / $width);
		} else {
			$new_width=intval($width * _CONF_THUMBNAIL_SIZE / $height);
			$new_height=intval(_CONF_THUMBNAIL_SIZE);
		}
		// Create new image.
		$new_image = ImageCreateTrueColor($new_width, $new_height);
		ImageCopyResampled($new_image,$image,0,0,0,0,$new_width,$new_height,$width,$height);
		$types=imagetypes();
		if ($types & IMG_PNG) {
			$thumbnail=array(
				'mime'=>'image/png',
				'width'=>$new_width,
				'height'=>$new_height,
				'file'=>self::gd_image('imagepng',$new_image));	
		} elseif ($types & IMG_JPG) {
			$thumbnail=array(
				'mime'=>'image/png',
				'width'=>$new_width,
				'height'=>$new_height,
				'file'=>self::gd_image('imagejpeg',$new_image));
		} elseif ($types & IMG_GIF) {
			$thumbnail=array(
				'mime'=>'image/png',
				'width'=>$new_width,
				'height'=>$new_height,
				'file'=>self::gd_image('imagegif',$new_image));
		} else $thumbnail=false;
		// Return original size and thumbnail.
		return array($width,$height,$thumbnail);
	}
	static public function gd_image($func,&$res){
		ob_start();
		call_user_func_array($func,array($res));
		return ob_get_clean();
	}
	static public function uploaded_file($info=false){
		static $cache;
		if (!isset($cache)) {
			if (is_array($info)) $cahe=$info;
			return false;
		}
		if ($info===false) return $cache;
		return isset($cache[$info])?$cache[$info]:false;
	}
	static public function tag_list(&$data,$skin=false,$limit=10){
		$offset=isset($_GET['offset'])?(int)$_GET['offset']:0;
		$query='SELECT m.id as id, m.name as name, m.mime as mime, m.binsize as size, m.time as time, 
			ExtractValue(m.xml,"width") as width, ExtractValue(m.xml,"height") as height, 
			ExtractValue(t.xml,"width") as twidth, ExtractValue(t.xml,"height") as theight 
			FROM jeans_binary as m LEFT JOIN jeans_binary as t 
			ON m.name=t.name AND m.contextid=t.contextid AND t.type="thumbnail" 
			WHERE m.type="media" AND m.contextid=<%id%>
			GROUP BY m.name ORDER BY m.time DESC 
			LIMIT <%limit%> OFFSET <%offset%>';
		$array=array('id'=>self::member_id(),'limit'=>$limit,'offset'=>$offset);
		$items=sql::count_query($query,$array);
		$data['libs']['page']=array('items'=>$items,'offset'=>$offset,'limit'=>$limit);
		view::show_using_query($data,$query,$array,$skin,array('admin_media','cb_tag_list'));
	}
	static public function cb_tag_list(&$row){
		$row['file']=self::member_id().'-'.$row['name'];
		if (substr($row['mime'],0,6)=='image/') {
			$row['type']='image';
			if (empty($row['twidth'])) {
				if ($row['width']<$row['height']) {
					$row['twidth']=intval($row['width'] * _CONF_THUMBNAIL_SIZE / $row['height']);
					$row['theight']=intval(_CONF_THUMBNAIL_SIZE);
				} else {
					$row['theight']=intval($row['height'] * _CONF_THUMBNAIL_SIZE / $row['width']);
					$row['twidth']=intval(_CONF_THUMBNAIL_SIZE);
				}
				
			}
			$row['thumbnail']='?action=media.thumbnail&file='.$row['file'];
		} else {
			$row['type']='media';
			
		}
	}
	static public function mime($extension){
		static $cache=array (
			  'ez' => 'application/andrew-inset',
			  'atom' => 'application/atom+xml',
			  'hqx' => 'application/mac-binhex40',
			  'cpt' => 'application/mac-compactpro',
			  'mathml' => 'application/mathml+xml',
			  'doc' => 'application/msword',
			  'bin' => 'application/octet-stream',
			  'dms' => 'application/octet-stream',
			  'lha' => 'application/octet-stream',
			  'lzh' => 'application/octet-stream',
			  'exe' => 'application/octet-stream',
			  'class' => 'application/octet-stream',
			  'so' => 'application/octet-stream',
			  'dll' => 'application/octet-stream',
			  'dmg' => 'application/octet-stream',
			  'oda' => 'application/oda',
			  'ogg' => 'application/ogg',
			  'pdf' => 'application/pdf',
			  'ai' => 'application/postscript',
			  'eps' => 'application/postscript',
			  'ps' => 'application/postscript',
			  'rdf' => 'application/rdf+xml',
			  'smi' => 'application/smil',
			  'smil' => 'application/smil',
			  'gram' => 'application/srgs',
			  'grxml' => 'application/srgs+xml',
			  'mif' => 'application/vnd.mif',
			  'xul' => 'application/vnd.mozilla.xul+xml',
			  'xls' => 'application/vnd.ms-excel',
			  'ppt' => 'application/vnd.ms-powerpoint',
			  'wbxml' => 'application/vnd.wap.wbxml',
			  'wmlc' => 'application/vnd.wap.wmlc',
			  'wmlsc' => 'application/vnd.wap.wmlscriptc',
			  'vxml' => 'application/voicexml+xml',
			  'bcpio' => 'application/x-bcpio',
			  'vcd' => 'application/x-cdlink',
			  'pgn' => 'application/x-chess-pgn',
			  'cpio' => 'application/x-cpio',
			  'csh' => 'application/x-csh',
			  'dcr' => 'application/x-director',
			  'dir' => 'application/x-director',
			  'dxr' => 'application/x-director',
			  'dvi' => 'application/x-dvi',
			  'spl' => 'application/x-futuresplash',
			  'gtar' => 'application/x-gtar',
			  'hdf' => 'application/x-hdf',
			  'js' => 'application/x-javascript',
			  'skp' => 'application/x-koan',
			  'skd' => 'application/x-koan',
			  'skt' => 'application/x-koan',
			  'skm' => 'application/x-koan',
			  'latex' => 'application/x-latex',
			  'nc' => 'application/x-netcdf',
			  'cdf' => 'application/x-netcdf',
			  'sh' => 'application/x-sh',
			  'shar' => 'application/x-shar',
			  'swf' => 'application/x-shockwave-flash',
			  'sit' => 'application/x-stuffit',
			  'sv4cpio' => 'application/x-sv4cpio',
			  'sv4crc' => 'application/x-sv4crc',
			  'tar' => 'application/x-tar',
			  'tcl' => 'application/x-tcl',
			  'tex' => 'application/x-tex',
			  'texinfo' => 'application/x-texinfo',
			  'texi' => 'application/x-texinfo',
			  't' => 'application/x-troff',
			  'tr' => 'application/x-troff',
			  'roff' => 'application/x-troff',
			  'man' => 'application/x-troff-man',
			  'me' => 'application/x-troff-me',
			  'ms' => 'application/x-troff-ms',
			  'ustar' => 'application/x-ustar',
			  'src' => 'application/x-wais-source',
			  'xhtml' => 'application/xhtml+xml',
			  'xht' => 'application/xhtml+xml',
			  'xslt' => 'application/xslt+xml',
			  'xml' => 'application/xml',
			  'xsl' => 'application/xml',
			  'dtd' => 'application/xml-dtd',
			  'zip' => 'application/zip',
			  'au' => 'audio/basic',
			  'snd' => 'audio/basic',
			  'mid' => 'audio/midi',
			  'midi' => 'audio/midi',
			  'kar' => 'audio/midi',
			  'mpga' => 'audio/mpeg',
			  'mp2' => 'audio/mpeg',
			  'mp3' => 'audio/mpeg',
			  'aif' => 'audio/x-aiff',
			  'aiff' => 'audio/x-aiff',
			  'aifc' => 'audio/x-aiff',
			  'm3u' => 'audio/x-mpegurl',
			  'ram' => 'audio/x-pn-realaudio',
			  'ra' => 'audio/x-pn-realaudio',
			  'rm' => 'application/vnd.rn-realmedia',
			  'wav' => 'audio/x-wav',
			  'pdb' => 'chemical/x-pdb',
			  'xyz' => 'chemical/x-xyz',
			  'bmp' => 'image/bmp',
			  'cgm' => 'image/cgm',
			  'gif' => 'image/gif',
			  'ief' => 'image/ief',
			  'jpeg' => 'image/jpeg',
			  'jpg' => 'image/jpeg',
			  'jpe' => 'image/jpeg',
			  'png' => 'image/png',
			  'svg' => 'image/svg+xml',
			  'tiff' => 'image/tiff',
			  'tif' => 'image/tiff',
			  'djvu' => 'image/vnd.djvu',
			  'djv' => 'image/vnd.djvu',
			  'wbmp' => 'image/vnd.wap.wbmp',
			  'ras' => 'image/x-cmu-raster',
			  'ico' => 'image/x-icon',
			  'pnm' => 'image/x-portable-anymap',
			  'pbm' => 'image/x-portable-bitmap',
			  'pgm' => 'image/x-portable-graymap',
			  'ppm' => 'image/x-portable-pixmap',
			  'rgb' => 'image/x-rgb',
			  'xbm' => 'image/x-xbitmap',
			  'xpm' => 'image/x-xpixmap',
			  'xwd' => 'image/x-xwindowdump',
			  'igs' => 'model/iges',
			  'iges' => 'model/iges',
			  'msh' => 'model/mesh',
			  'mesh' => 'model/mesh',
			  'silo' => 'model/mesh',
			  'wrl' => 'model/vrml',
			  'vrml' => 'model/vrml',
			  'ics' => 'text/calendar',
			  'ifb' => 'text/calendar',
			  'css' => 'text/css',
			  'html' => 'text/html',
			  'htm' => 'text/html',
			  'asc' => 'text/plain',
			  'txt' => 'text/plain',
			  'rtx' => 'text/richtext',
			  'rtf' => 'text/rtf',
			  'sgml' => 'text/sgml',
			  'sgm' => 'text/sgml',
			  'tsv' => 'text/tab-separated-values',
			  'wml' => 'text/vnd.wap.wml',
			  'wmls' => 'text/vnd.wap.wmlscript',
			  'etx' => 'text/x-setext',
			  'mpeg' => 'video/mpeg',
			  'mpg' => 'video/mpeg',
			  'mpe' => 'video/mpeg',
			  'qt' => 'video/quicktime',
			  'mov' => 'video/quicktime',
			  'mxu' => 'video/vnd.mpegurl',
			  'm4u' => 'video/vnd.mpegurl',
			  'avi' => 'video/x-msvideo',
			  'movie' => 'video/x-sgi-movie',
			  'ice' => 'x-conference/x-cooltalk',
			);
		$extension=strtolower($extension);
		if (isset($cache[$extension])) return $cache[$extension];
		return 'application/unknown';
	}
}