using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;

// TODO: replace these with the processor input and output types.
using TInput = System.String;
using TOutput = System.String;
using System.ComponentModel;
using Microsoft.Xna.Framework.Content.Pipeline.Serialization.Compiler;
using Microsoft.Xna.Framework.Content;
using System.Drawing;

namespace GroundImporter
{
    /// <summary>
    /// This class will be instantiated by the XNA Framework Content Pipeline
    /// to apply custom processing to content data, converting an object of
    /// type TInput to TOutput. The input and output types may be the same if
    /// the processor wishes to alter data without changing its type.
    ///
    /// This should be part of a Content Pipeline Extension Library project.
    ///
    /// TODO: change the ContentProcessor attribute to specify the correct
    /// display name for this processor.
    /// </summary>
    [ContentProcessor(DisplayName = "GroundImporter")]
    public class GroundImporter : ModelProcessor
    {

        /// <summary>vZp_Xg̕B傫قvZ͑Ȃ邪Ax</summary>
        int BpoSegment1 =30;

        /// <summary>vZp̗]TBΌvZ͑Ȃ邪Ax</summary>
        float BpoSegment2 = 30.0f;

        /// <summary>
        /// ŏIIɏo͂}`̕
        /// </summary>
        ushort Dividecount = 512;
        // Kl̎w
        [DefaultValue(512)]
        // \镶̎w
        [DisplayName("Divide Count")]
        // p[^[̐
        [Description("}`̕BΑقǐx͂邪AvZ͏dȂs̃BW512")]
        // vZbTp[^[
        public ushort DivideCount
        {
            get { return Dividecount; }
            set { Dividecount = value; }
        }


        /// <summary>
        /// Փ˓_ołȂꍇ̓tO
        /// </summary>
        bool UnHitfill = true;
        // Kl̎w
        [DefaultValue(true)]
        // \镶̎w
        [DisplayName("UnHit Fill LowestPoint")]
        // p[^[̐
        [Description("Փ˓_ołȂꍇ̓B@truełꍇA݂_̒̍łႢ_gpBfalsȅꍇ float.MinValue gp")]
        // vZbTp[^[
        public bool UnHitFill
        {
            get { return UnHitfill; }
            set { UnHitfill = value; }
        }


        /// <summary>
        /// }bvoʂ摜Ƃďo͂邩ǂ̃tO
        /// </summary>
        bool Putheightfile = false;
        // Kl̎w
        [DefaultValue(false)]
        // \镶̎w
        [DisplayName("Put HeightProcessed Image")]
        // p[^[̐
        [Description("}bvoʂ摜Ƃďo͂邩ǂ̃tOBtrueȂAAZbg+ _h.png ̃t@C쐬B ")]
        // vZbTp[^[
        public bool PutHeightFile
        {
            get { return Putheightfile; }
            set { Putheightfile = value; }
        }


        /// <summary>
        /// CvZX
        /// </summary>
        /// <param name="input"></param>
        /// <param name="context"></param>
        /// <returns></returns>
        public override ModelContent Process(NodeContent input, ContentProcessorContext context)
        {
            if (System.Diagnostics.Debugger.IsAttached)
                System.Diagnostics.Debugger.Break();

                // ͂ꂽbVɐڋԊǉ
                ProcessTangents(input, context);
              ModelContent model = base.Process(input, context);
              putObj = new HeightMapSetter();

              putObj.SetedFact = new float[2];
              putObj.P_pos = new float[(int)Ground_Pos_ID.maxval];
              //ei[n̏
              putObj.P_pos[(int)Ground_Pos_ID.X_max] = float.MinValue;
              putObj.P_pos[(int)Ground_Pos_ID.X_min] = float.MaxValue;
              putObj.P_pos[(int)Ground_Pos_ID.Z_max] = float.MinValue;
              putObj.P_pos[(int)Ground_Pos_ID.Z_min] = float.MaxValue;
              putObj.P_pos[(int)Ground_Pos_ID.Y_max] = float.MinValue;
              putObj.P_pos[(int)Ground_Pos_ID.Y_min] = float.MaxValue;

              try
              {
                  //_Xg擾
                  TraverseHierarchy(input);

                  putObj.HeightMap = new float[DivideCount][];
                  process2();

                  if(PutHeightFile)   process3(input.Identity.SourceFilename);
              }
              catch(Exception e)
              {
                  String s = e.Message;
                  // TODO: process the input object, and return the modified data.
                  throw new NotImplementedException(e.Message);
              }
              model.Tag = putObj;
              return model;
        }

        void ProcessTangents(NodeContent input, ContentProcessorContext context)
        {
            // NodeContentMeshContentȂAڋԏ𐶐
            MeshContent mesh = input as MeshContent;
            if (mesh != null)
            {
                MeshHelper.CalculateTangentFrames(
                    mesh,                                   // ΏۂƂȂ郁bV
                    VertexChannelNames.TextureCoordinate(0),// ڋԏ𐶐鎞ɎQƂeNX`W̃`l
                    VertexChannelNames.Tangent(0),          // (Tangent)i[`l
                    VertexChannelNames.Binormal(0)          // @(Binormal)i[`l
                );
            }

            // NodeContentc[񂷂
            foreach (NodeContent child in input.Children)
            {
                ProcessTangents(child, context);
            }
        }

        /// <summary>_i[Xg</summary>
        //List<Vector3> VerList = new List<Vector3>();

        /// <summary>tagŕt</summary>
        HeightMapSetter putObj;

        /// <summary>Rp`̒_\</summary>
        private struct Triangle
        {
            public Vector3[] vx;
            public Vector3 center;
        }

        /// <summary>|S̊i[</summary>
        List<Triangle> TriangleList = new List<Triangle>();


        /// <summary>xꂽXg</summary>
        List<Triangle>[][] BpoLists;

        /// <summary>
        /// őlƍŏl̍ABpoSegment1Ŋ
        /// </summary>
        float divideFactX, divideFactZ;

        float BPOtoAllay_X, BPOtoAllay_Z;

        int missingCount = 0;

        /// <summary>
        /// w肳ꂽNodeContentc[񂷂
        /// </summary>
        void TraverseHierarchy(NodeContent node)
        {

            // qm[h񂷂
            foreach (NodeContent child in node.Children)
            {
                TraverseHierarchy(child);
            }

            // ̃m[hMeshContentH
            MeshContent mesh = node as MeshContent;

            if (mesh != null)
            {
                // MeshContent̃WIg[vB
                foreach (GeometryContent geometry in mesh.Geometry)
                {
                    IList<int> indices = geometry.Indices;

                    // _擾
                    IList<Microsoft.Xna.Framework.Vector3> positions = geometry.Vertices.Positions;

                    for (int triangle = 0; triangle < indices.Count; triangle += 3)
                    {
                        // Op`̃CfbNX擾
                        int i1 = indices[triangle];
                        int i2 = indices[triangle + 1];
                        int i3 = indices[triangle + 2];

                        // Op`_AtriPos1 .. 3擾
                        Vector3 triPos1 = positions[i1];
                        Vector3 triPos2 = positions[i2];
                        Vector3 triPos3 = positions[i3];

                        // ŎOp`̏g

                        //Op`̂܂܃Xg֊i[
                        Triangle t = new Triangle();
                        t.vx = new Vector3[3];
                        t.vx[0] = positions[i1];
                        t.vx[1] = positions[i2];
                        t.vx[2] = positions[i3];

                        t.center = Vector3.Add(positions[i1], positions[i2]);
                        t.center = Vector3.Add(t.center, positions[i3]);
                        t.center = t.center / 3.0f;
                        TriangleList.Add(t);

                        //łłɁA_XǵAőlƍŏlZbg
                        foreach (Vector3 v in t.vx)
                        {
                            if (putObj.P_pos[(int)Ground_Pos_ID.X_max] < v.X) putObj.P_pos[(int)Ground_Pos_ID.X_max] = v.X;
                            if (putObj.P_pos[(int)Ground_Pos_ID.X_min] > v.X) putObj.P_pos[(int)Ground_Pos_ID.X_min] = v.X;

                            if (putObj.P_pos[(int)Ground_Pos_ID.Y_max] < v.Y) putObj.P_pos[(int)Ground_Pos_ID.Y_max] = v.Y;
                            if (putObj.P_pos[(int)Ground_Pos_ID.Y_min] > v.Y) putObj.P_pos[(int)Ground_Pos_ID.Y_min] = v.Y;

                            if (putObj.P_pos[(int)Ground_Pos_ID.Z_max] < v.Z) putObj.P_pos[(int)Ground_Pos_ID.Z_max] = v.Z;
                            if (putObj.P_pos[(int)Ground_Pos_ID.Z_min] > v.Z) putObj.P_pos[(int)Ground_Pos_ID.Z_min] = v.Z;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// _XǵAőlƍŏlZbg
        /// </summary>
        /// <param name="putObj"></param>
        void getmaxes()
        {
            foreach (Triangle t in TriangleList)
            {
                foreach (Vector3 v in t.vx)
                {
                    if (putObj.P_pos[(int)Ground_Pos_ID.X_max] < v.X) putObj.P_pos[(int)Ground_Pos_ID.X_max] = v.X;
                    if (putObj.P_pos[(int)Ground_Pos_ID.X_min] > v.X) putObj.P_pos[(int)Ground_Pos_ID.X_min] = v.X;

                    if (putObj.P_pos[(int)Ground_Pos_ID.Y_max] < v.Y) putObj.P_pos[(int)Ground_Pos_ID.Y_max] = v.Y;
                    if (putObj.P_pos[(int)Ground_Pos_ID.Y_min] > v.Y) putObj.P_pos[(int)Ground_Pos_ID.Y_min] = v.Y;

                    if (putObj.P_pos[(int)Ground_Pos_ID.Z_max] < v.Z) putObj.P_pos[(int)Ground_Pos_ID.Z_max] = v.Z;
                    if (putObj.P_pos[(int)Ground_Pos_ID.Z_min] > v.Z) putObj.P_pos[(int)Ground_Pos_ID.Z_min] = v.Z;
                }
            }
        }

        /// <summary>
        /// vZx𑬂߂邽߁A|SXgO[vɕ
        /// </summary>
        void DivideTriangle()
        {
            //B\̂pӂ
            //őlƍŏl̍ABpoSegment1ŊAz񐔂ɂȂi+1́A܂lÔ߂̂́j
            divideFactX = (putObj.P_pos[(int)Ground_Pos_ID.X_MintoMax] / BpoSegment1);
            divideFactZ = (putObj.P_pos[(int)Ground_Pos_ID.Z_MintoMax] / BpoSegment1);
            BpoLists = new List<Triangle>[BpoSegment1 + 1][];
            for (int z = 0; z < BpoLists.Length; z++)
            {
                BpoLists[z] = new List<Triangle>[BpoSegment1 + 1];
                for (int x = 0; x < BpoLists[z].Length; x++)
                {
                    BpoLists[z][x] = new List<Triangle>();
                }
            }

            //|S̕
            //P̃|SList̒ɓ邱Ƃ邪ACɂȂĂ悢B
            float tmpFZ,tmpFX, difMax;
            foreach (Triangle t in TriangleList)
            {
                bool intoFlg = false;
                int nowZ, nowX;
                for (int z = 0; z < BpoLists.Length; z++)
                {
                    tmpFZ = putObj.P_pos[(int)Ground_Pos_ID.Z_min] + z * divideFactZ;
                    tmpFZ = t.center.Z - tmpFZ;

                    if (Math.Abs(tmpFZ) <divideFactZ*2 + BpoSegment2)
                    {
                        //ZBXZo
                        for (int x = 0; x < BpoLists[0].Length; x++)
                        {
                            tmpFX = putObj.P_pos[(int)Ground_Pos_ID.X_min] + x * divideFactX;
                            tmpFX = t.center.X - tmpFX;
                            if (Math.Abs(tmpFX) < divideFactX*2 + BpoSegment2)
                            {
                                //XBɓ
                                intoFlg = true;
                                BpoLists[z][x].Add(t);
                            }
                        }
                    }
                }
                if (!intoFlg)
                {
                    throw new Exception("VertexList Divide Err!!");
                }
            }
           
        }

        /// <summary>
        /// heightmap̌vZ
        /// </summary>
        void process2()
        {
            putObj.SetedFact = new float[2];

            //factor

            //wƂýAuŏlől܂ł̊Ԃ̒lv擾
            float tmpf = putObj.P_pos[(int)Ground_Pos_ID.X_max] - putObj.P_pos[(int)Ground_Pos_ID.X_min];
            putObj.P_pos[(int)Ground_Pos_ID.X_MintoMax] = tmpf;

            // Lŋ߂lŊƁAuz1ړƂ́Aẅړʁv
            //ALŎgu|SXg1ړƂւ̑Ήnv́AʂɂȂB
            BPOtoAllay_X = tmpf / DivideCount;
            putObj.SetedFact[0] = DivideCount / tmpf;

            //yɂĂl̂Ƃ
            tmpf = putObj.P_pos[(int)Ground_Pos_ID.Z_max] - putObj.P_pos[(int)Ground_Pos_ID.Z_min];
            putObj.P_pos[(int)Ground_Pos_ID.Z_MintoMax] = tmpf;
            BPOtoAllay_Z = tmpf / DivideCount;
            putObj.SetedFact[1] = DivideCount / tmpf;

            //Y
            tmpf = putObj.P_pos[(int)Ground_Pos_ID.Y_max] - putObj.P_pos[(int)Ground_Pos_ID.Y_min];
            putObj.P_pos[(int)Ground_Pos_ID.Y_MintoMax] = tmpf;

            //ŃxNg肵Ă
            putObj.SetedfactLength = new Vector2(putObj.SetedFact[0], putObj.SetedFact[1]).Length();

            //tmpf = putObj.P_pos[(int)Ground_Pos_ID.Y_max] - putObj.P_pos[(int)Ground_Pos_ID.Y_min];

            //vZx̂߁AXg𕪊
            DivideTriangle();
            //Lŋ߂lgAzɁu̒n_̍vЂLĂ

            float nowX, nowZ, nowY, nowY2;
            bool hitflg;
            nowY = putObj.P_pos[(int)Ground_Pos_ID.Y_max] + 100;
            nowY2 = putObj.P_pos[(int)Ground_Pos_ID.Y_min] - 100;

            bool[][] allHitFlg = new bool[DivideCount][];

            for (int z = 0; z < DivideCount; z++)
            {
                putObj.HeightMap[z] = new float[DivideCount];
                allHitFlg[z] = new bool[DivideCount];
                nowZ = putObj.P_pos[(int)Ground_Pos_ID.Z_min] + BPOtoAllay_Z * z + (BPOtoAllay_Z*0.5f);
                for (int x = 0; x < DivideCount; x++)
                {
                    nowX = putObj.P_pos[(int)Ground_Pos_ID.X_min] + BPOtoAllay_X * x + (BPOtoAllay_X*0.5f);
                    putObj.HeightMap[z][x] = getHeight(nowX, nowY2, nowY, nowZ, out hitflg);
                    allHitFlg[z][x] = hitflg;
                }
            }

            //ŏIIɌołȂA͂̓_ۊǂ邵Ȃ
            if (UnHitfill)
            {
                pb_count = 0;
                process_2_2(ref allHitFlg);
            }
            else
            {
                
            }
            

        }

        int pb_count;

        private bool process_2_2(ref bool[][] allHitFlg)
        {
            int distHit = 0;
            pb_count++;
            for (int z = 1; z < DivideCount-1; z++)
            {
                for (int x = 1; x < DivideCount-1; x++)
                {
                    if (!allHitFlg[z][x])
                    {
                        {
                            //ŏIIɌołȂA͂̓_ۊǂ邵Ȃ
                            //͓_̔A߂郍WbNǉ
                            int sumC = 0;
                            int tgtX_Max, tgtX_Min, tgtZ_Max, tgtZ_Min;
                            float tmpH = 0;


                            tgtZ_Max = Math.Min(z + 2, DivideCount);
                            tgtZ_Min = Math.Max(z - 1, 0);

                            tgtX_Max = Math.Min(x + 2, DivideCount);
                            tgtX_Min = Math.Max(x - 1, 0);
                            for (int tmpZ = tgtZ_Min; tmpZ < tgtZ_Max; tmpZ++)
                            {
                                for (int tmpX = tgtX_Min; tmpX < tgtX_Max; tmpX++)
                                {
                                    if ((tmpX != x || tmpZ != z) && allHitFlg[tmpZ][tmpX])
                                    {
                                        sumC++;
                                        tmpH += putObj.HeightMap[tmpZ][tmpX];
                                    }
                                }
                            }
                            if (sumC > 6)
                            {
                                putObj.HeightMap[z][x] = tmpH / sumC;
                                allHitFlg[z][x] = true;
                            }
                            else
                            {
                                distHit++;
                            }
                        }
                    }
                }
            }

            return true;

            if (distHit == 0) return true;
            else
            {
                if (pb_count > 5) return true;
                return process_2_2(ref allHitFlg);
            }

        }

        void process3(String FileName)
        {
            //t@Cɏo
            String fileName = FileName + @"_h.png";
            using (Bitmap putImg = new Bitmap(putObj.HeightMap[0].Length, putObj.HeightMap.Length))
            {
                System.Drawing.Color nowC = new System.Drawing.Color();
                for (int z = 0; z < Dividecount; z++)
                {
                    for (int x = 0; x < Dividecount; x++)
                    {
                        float nowF = putObj.HeightMap[z][x];
                        //nowFAőlPAŏl0ƂƂAǂ̂炢̈ʒuɂȂ邩Zo
                        nowF -= putObj.P_pos[(int)Ground_Pos_ID.Y_min];
                        double tmpD = 0;
                        if (nowF != 0)
                        {
                            tmpD = nowF / putObj.P_pos[(int)Ground_Pos_ID.Y_MintoMax];
                        }
                        byte nowB = (byte)(byte.MaxValue * tmpD);
                        putImg.SetPixel(putObj.HeightMap[0].Length - x - 1, putObj.HeightMap.Length - z - 1, System.Drawing.Color.FromArgb(255, nowB, nowB, nowB));
                    }
                }
                putImg.Save(fileName, System.Drawing.Imaging.ImageFormat.Png);
            }
           
        }

        /// <summary>
        /// ̒n_ɏՓ˂Rp`߂
        /// </summary>
        /// <param name="x"></param>
        /// <param name="z"></param>
        /// <returns></returns>
        float getHeight(float x, float y_s, float y_e, float z, out bool o_hitflg)
        {
            bool m_hitglf = false;
            float nowHeight = putObj.P_pos[(int)Ground_Pos_ID.Y_min];
            Vector3 v_s, v_e, refV;
            v_s = new Vector3(x, y_s, z);
            v_e = new Vector3(x, y_e, z);

            
            float tmpFZ, tmpFX;
            int prosessedX=0, prosessedZ=0;
            //ꂽ|SXgAՓˌoΏۂ̃|ST
            for (int loopZ = 0; loopZ < BpoLists.Length; loopZ++)
            {
                tmpFZ = putObj.P_pos[(int)Ground_Pos_ID.Z_min] + loopZ * divideFactZ;
                tmpFZ = z - tmpFZ;
                if (Math.Abs(tmpFZ) < divideFactZ + BpoSegment2)
                {
                    prosessedZ = loopZ;
                    for (int loopX = 0; loopX < BpoLists.Length; loopX++)
                    {
                        tmpFX = putObj.P_pos[(int)Ground_Pos_ID.X_min] + loopX * divideFactX;
                        tmpFX = x - tmpFX;
                        if (Math.Abs(tmpFX) < divideFactX + BpoSegment2)
                        {
                            prosessedX = loopX;
                            foreach (Triangle t in BpoLists[loopZ][loopX])
                            {
                                bool l_hitflg = false;
                                refV = Vector3.Zero;
                                Judge_Line_Plane(ref v_s, ref v_e, t, ref refV, ref l_hitflg);

                                if (putObj.P_pos[(int)Ground_Pos_ID.Y_min] >= refV.Y) l_hitflg = false;

                                //Փ˓_Au̓_ԍ_łvmFi|S̏dȂlj
                                //dȂl邽߁AՓ˓_Ăbreak͂ȂB̂߁Ȁ͂񂰁[Ԃ
                                if (l_hitflg)
                                {
                                    m_hitglf = true;
                                    if (nowHeight < refV.Y) nowHeight = refV.Y;
                                }
                            }
                            break;
                        }
                    }
                    break;
                }               
            }

            if (!m_hitglf)
            {
                //ołȂAאڂZOg
                int tgtX_Max, tgtX_Min, tgtZ_Max, tgtZ_Min;

                tgtZ_Max = Math.Min(prosessedZ + 2, BpoLists.Length);
                tgtZ_Min = Math.Max(prosessedZ - 1, 0);

                tgtX_Max = Math.Min(prosessedX + 2, BpoLists[0].Length);
                tgtX_Min = Math.Max(prosessedX - 1, 0);

                for (int z2 = tgtZ_Min; z2 < tgtZ_Max; z2++)
                {
                    for (int x2 = tgtX_Min; x2 < tgtX_Max; x2++)
                    {
                        //̃[vŌꏊ́AKv͂ȂB
                        if (z2 != prosessedZ || x2 != prosessedX)
                        {
                            foreach (Triangle t in BpoLists[z2][x2])
                            {
                                bool l_hitflg = false;
                                refV = Vector3.Zero;
                                Judge_Line_Plane(ref v_s, ref v_e, t, ref refV, ref l_hitflg);

                                if (putObj.P_pos[(int)Ground_Pos_ID.Y_min] >= refV.Y) l_hitflg = false;

                                if (l_hitflg)
                                {
                                    m_hitglf = true;
                                    if (nowHeight < refV.Y) nowHeight = refV.Y;
                                }
                            }
                            if (m_hitglf) break;
                        }
                    }
                    if (m_hitglf) break;
                }

            }
            
            /*
            foreach (Triangle t in TriangleList)
            {
                bool l_hitflg = false;
                refV = Vector3.Zero;
                Judge_Line_Plane(ref v_s,ref v_e, t,ref refV,ref l_hitflg);

                //Փ˓_Au̓_ԍ_łvmFi|S̏dȂlj
                //dȂl邽߁AՓ˓_Ăbreak͂ȂB̂߁Ȁ͂񂰁[Ԃ
                //ƂŁu񂰁[vāAČQnفH
                if (l_hitflg)
                {
                    if (nowHeight < refV.Y) nowHeight = refV.Y;
                }
            }
            */
            //ǂɂȂꍇAx̍ŒnԂ饥
            //[Ȃ܂ԂȂ̂ŁAG[ԂƂɂ?
            if (!m_hitglf)
            {
                if (z != putObj.P_pos[(int)Ground_Pos_ID.Z_min] && x != putObj.P_pos[(int)Ground_Pos_ID.X_min])
                {
                    missingCount++;
                    //throw new Exception("oG[FX:" + x.ToString() + ", Z:" + z.ToString());
                }
            }


            o_hitflg = m_hitglf;
            return nowHeight;
        }




        /// <summary>
        /// w肳ꂽƂR̒_̏Փ˓_o@@͂
        /// </summary>
        /// <param name="p">Jnʒu</param>
        /// <param name="q">I_ʒu</param>
        /// <param name="v">_iz񐔁FRj</param>
        /// <param name="refV">Փ˓_</param>
        /// <param name="flg">ۂɏՓ˂ǂ̃tO</param>
        void Judge_Line_Plane(ref Vector3 p, ref Vector3 q, Triangle triangle, ref Vector3 refV, ref bool flg)
       {
           Vector3 l;    //_̈ʒuxNg
           // ʂ̕ ni@xNgj߂
           // ax + bx + cz + d = 0
           Vector3 n = (triangle.vx[1] - triangle.vx[0]), p2 = (triangle.vx[2] - triangle.vx[0]);
           Vector3 p1 = n;
 
           Vector3.Cross(ref p1, ref p2, out  n);    //iOρj

           // ̕ u ߂
           // l = p + tu
           Vector3 u = q - p;

           // t߂邱ƂŁA_߂
           float top = n.X * (triangle.vx[0].X - p.X) + n.Y * (triangle.vx[0].Y - p.Y) + n.Z * (triangle.vx[0].Z - p.Z);
           float bottom = Vector3.Dot(n, u);    //iρj

           // s
           if (bottom == 0.0f) { flg = false; return; }    //słB

           // t߂
           float t = top / bottom;

           // 0 =< t =< 1 ȊȌꍇAĂȂ̂Ŕ
           if (t < 0.0f || t > 1.0f) { flg = false; return; }

           // ʂƐ̌_߂
           l = p + t * u;
           // Op`O    //triangle n(@xNg)Kv
           for (int i = 0; i < 3; i++)
           {
               // Oς𗘗pēO
               Vector3 pn = (triangle.vx[((i + 1) == 3) ? 0 : i + 1] - triangle.vx[i]);
               //n = new Vector3(0, 1, 0);
               p1 = pn;
               p2 = (l - triangle.vx[i]);
               //Vector3.Cross(ref pn, ref p1, out p2);    //iOρj
               Vector3.Cross(ref p1, ref p2, out pn);    //iOρj

               // @̕p
               pn.X = pn.X * n.X;
               pn.Y = pn.Y * n.Y;
               pn.Z = pn.Z * n.Z;

               // ׂĂ̏ꍇ̖@Ȃ΁Al ͎Op|Sɑ݂
               // -0.0001 ͌덷l
               if ((pn.X < -0.0001) || (pn.Y < -0.0001) || (pn.Z < -0.0001)) { flg = false; return; }
           }
           refV = l;
           flg = true;    //_L
       }

    }


    [ContentTypeWriter]
    public class HeightMapSetterWriter : ContentTypeWriter<HeightMapSetter>
    {
        protected override void Write(ContentWriter output, HeightMapSetter tagObj)
        {
            output.WriteObject<float[]>(tagObj.SetedFact);
            output.WriteObject<float>(tagObj.SetedfactLength);
            output.WriteObject<float[]>(tagObj.P_pos);
            output.WriteObject<float[][]>(tagObj.HeightMap);
        }

        public override string GetRuntimeType(TargetPlatform targetPlatform)
        {
            //return "GroundImporter.HeightMapSetter, GroundImporter";
            return typeof(HeightMapSetter).AssemblyQualifiedName;
        }

        public override string GetRuntimeReader(TargetPlatform targetPlatform)
        {
            //return "GroundImporter.HeightMapReader, GroundImporter";
            if (targetPlatform == TargetPlatform.Windows)
            {
                return typeof(HeightMapReader).AssemblyQualifiedName;
            }
            else 
            {
                return "Junk_XNA.HeightMapReader, Junk_XNA";
            }
        } 
    }

    
}