﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;



namespace J_ColPicker
{
    public static class clsPickerData
    {
        /// <summary>
        /// 配列関連付けenum
        /// </summary>
        private enum colID : int
        {
            R=0,
            G,
            B,
            /// <summary>通算index(開始)</summary>
            srtI,
            /// <summary>通算index(終了の)</summary>
            endI,

            maxval,
        }

        /// <summary>
        /// 色彩ターゲット配列
        /// </summary>
        private static int[][] paletSetter_Hue;

        static clsPickerData()
        {
            paletSetter_Hue = new int[6][];
            for (int i = 0; i < 6; i++)
            {
                paletSetter_Hue[i] = new int[(int)colID.maxval];
            }

            int id = 0;
            //
            paletSetter_Hue[id][(int)colID.R] = 255;
            paletSetter_Hue[id][(int)colID.G] = 0;
            paletSetter_Hue[id][(int)colID.B] = 0;
            paletSetter_Hue[id][(int)colID.srtI] = id * 256;
            paletSetter_Hue[id][(int)colID.endI] = (id + 1) * 256;

            //
            id = 1;
            paletSetter_Hue[id][(int)colID.R] = 255;
            paletSetter_Hue[id][(int)colID.G] = 255;
            paletSetter_Hue[id][(int)colID.B] = 0;
            paletSetter_Hue[id][(int)colID.srtI] = id * 256;
            paletSetter_Hue[id][(int)colID.endI] = (id + 1) * 256;
            //
            id = 2;
            paletSetter_Hue[id][(int)colID.R] = 0;
            paletSetter_Hue[id][(int)colID.G] = 255;
            paletSetter_Hue[id][(int)colID.B] = 0;
            paletSetter_Hue[id][(int)colID.srtI] = id * 256;
            paletSetter_Hue[id][(int)colID.endI] = (id + 1) * 256;
            //
            id = 3;
            paletSetter_Hue[id][(int)colID.R] = 0;
            paletSetter_Hue[id][(int)colID.G] = 255;
            paletSetter_Hue[id][(int)colID.B] = 255;
            paletSetter_Hue[id][(int)colID.srtI] = id * 256;
            paletSetter_Hue[id][(int)colID.endI] = (id + 1) * 256;
            //
            id = 4;
            paletSetter_Hue[id][(int)colID.R] = 0;
            paletSetter_Hue[id][(int)colID.G] = 0;
            paletSetter_Hue[id][(int)colID.B] = 255;
            paletSetter_Hue[id][(int)colID.srtI] = id * 256;
            paletSetter_Hue[id][(int)colID.endI] = (id + 1) * 256;
            //
            id = 5;
            paletSetter_Hue[id][(int)colID.R] = 255;
            paletSetter_Hue[id][(int)colID.G] = 0;
            paletSetter_Hue[id][(int)colID.B] = 255;
            paletSetter_Hue[id][(int)colID.srtI] = id * 256;
            paletSetter_Hue[id][(int)colID.endI] = (id + 1) * 256;
            //
        }

        /// <summary>
        /// 倍率floatから、画像の大きさを取得する
        /// </summary>
        /// <param name="Pow">縦横の倍率。灰列数は２でx,y</param>
        /// <returns></returns>
        public static Point GetMaxPoints(ref float[] Pow)
        {
            int x, y;
            x = (int)(Pow[0] * paletSetter_Hue[paletSetter_Hue.Length - 1][(int)colID.endI]);
            y = (int)(Pow[1] * 512);

            return new Point(x+1,y);
        }

        /// <summary>
        /// カラーピッカーの位置（XY）から、RGB要素となるByte配列を返す
        /// </summary>
        /// <param name="xy"></param>
        /// <param name="Pow">縦横の倍率。灰列数は２でx,yの順</param>
        /// <returns>[XNA]形式のColor.</returns>
        public static Color PickerXYtoRGB(ref Point xy,ref float[] Pow)
        {
            Color refC = new Color();

            Color tmpCol_1,tmpCol_2;

            //描画の倍率から配列Index指定
            int[] CurrentPow　= new int[2];

            for (int i = 0; i < 2; i++)
            {
                CurrentPow[i] = 1;
                if (Pow[i] == 0.5f) CurrentPow[i] = 2;
                if (Pow[i] == 0.25f) CurrentPow[i] = 4;
                if (Pow[i] == 0.125f) CurrentPow[i] = 8;
            }

            int TgtX = (int)(xy.X * CurrentPow[0]);
            int TgtY = (int)(xy.Y * CurrentPow[1]);
            int cul1 = 0;
            int nextI = 0;
            float f1 = 0;

            if (TgtY == 0) return Color.White;
            if (TgtY == 512) return Color.Black;

            for (int i = 0; i < paletSetter_Hue.Length; i++)
            {
                //X軸（彩度）から決定させる
                if (paletSetter_Hue[i][(int)colID.srtI] <= TgtX &&
                    paletSetter_Hue[i][(int)colID.endI] >= TgtX)
                {
                    //次のIndexをセット
                    nextI = i + 1;
                    if (nextI >= paletSetter_Hue.Length) nextI = 0;

                    cul1 = TgtX - paletSetter_Hue[i][(int)colID.srtI];
                    if (cul1 > 0) f1 = cul1 / 255.0f;

                    //色情報を作業用Colorにセット
                    tmpCol_1 = new Color(paletSetter_Hue[i][(int)colID.R],
                                         paletSetter_Hue[i][(int)colID.G],
                                         paletSetter_Hue[i][(int)colID.B]);

                    tmpCol_2 = new Color(paletSetter_Hue[nextI][(int)colID.R],
                                        paletSetter_Hue[nextI][(int)colID.G],
                                        paletSetter_Hue[nextI][(int)colID.B]);

                    //２つの作業用カラーから、X軸の値で色を決定させる
                    refC = Color.Lerp(tmpCol_1, tmpCol_2, f1);

                    //////////////////////////////////////////////////////////
                    //X軸は決定。光度を反映させる

                    //Y軸は中間(256)がそのターゲットの色。それ以外は、
                    //Y<256ならばゼロに向かうにつれ白、
                    //Y>256ならばMAX(512)に向かうにつれ黒になっていく
                    //////////////////////////////////////////////////////////
                    tmpCol_1 = refC;

                    if (TgtY == 256) return refC;
                    else
                    {
                        if (TgtY < 256)
                        {
                            tmpCol_2 = Color.White;
                            f1 = TgtY / 256.0f;
                            //白⇒ターゲット色なので、col_2が左辺
                            refC = Color.Lerp(tmpCol_2, tmpCol_1, f1);
                        }
                        else
                        {
                            tmpCol_2 = Color.Black;
                            f1 = (TgtY - 256) / 256.0f;
                            //ターゲット色⇒黒なので、col_2が右辺
                            refC = Color.Lerp(tmpCol_1, tmpCol_2, f1);
                        }
                    }
                    break;
                }
            }

            return refC;
        }
        
    }
}
