package org.torikiri.jexpression.expression;

import org.torikiri.jexpression.expression.optimizer.CommandXXD;
import org.torikiri.jexpression.expression.optimizer.CommandXDD;
import org.torikiri.jexpression.expression.optimizer.CommandDXX;
import org.torikiri.jexpression.expression.optimizer.CommandDXD;
import org.torikiri.jexpression.expression.optimizer.CommandDDX;
import org.torikiri.jexpression.expression.optimizer.CommandDDD;


public interface Optimizer {

	public void optimize(CompositeExpression expr);

	public static final class Factory {
		public static Optimizer createOptimizer() {
			return new CommandXXD()
				.addChain(new CommandXDD())
				.addChain(new CommandDXX())
				.addChain(new CommandDXD())
				.addChain(new CommandDDX())
				.addChain(new CommandDDD());
		}
	}
}
