package org.torikiri.jexpression.expression;

import java.math.BigDecimal;

import org.torikiri.jexpression.JEContext;
import org.torikiri.jexpression.JEUtils;
import org.torikiri.jexpression.JExpression;


public class StringValueExpression implements JExpression {

	private String val;

	public StringValueExpression(String val) {
		this.val = val;
	}

	public BigDecimal calculate(JEContext ctx) {
		if (JEUtils.isNumeric(val)) {
			return new BigDecimal(val);
		} else {
			if (ctx == null) {
				throw new NullPointerException("No context.");
			}
			return ctx.getFunc(val).calculate(ctx);
		}
	}

	public String toString() {
		return val;
	}
}
