package org.torikiri.jexpression.expression.optimizer;

import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.Operation;
import org.torikiri.jexpression.expression.CompositeExpression;
import org.torikiri.jexpression.operation.DivideOperation;
import org.torikiri.jexpression.operation.MultiplyOperation;

/**
 * (a / b) / (c + d) -> a / (b * (c + d))
 * <pre>
 * <li>before</li>
 *         (/)
 *       /    |
 *    (/)     (+)
 *   /  |    /  |
 * (a) (b) (c) (d)
 * 
 * <li>after</li>
 *      (/)
 *    /   |
 * (a)    (*)
 *      /    |
 *     (b)  (+)
 *         /  |
 *       (c) (d)
 * </pre>
 * @author Kiyotaka
 *
 */
public class CommandDDX extends OptimizeCommand {

	protected void execute(CompositeExpression expr, JExpression a,
			JExpression b, JExpression c, JExpression d, Operation op0,
			Operation op1, Operation op2) {

		CompositeExpression ce = new CompositeExpression(
				b,
				new CompositeExpression(c, d, op2),
				new MultiplyOperation());

		expr.setExpr1(a);
		expr.setExpr2(ce);
		expr.setOp(new DivideOperation());
	}

	protected OptimizePattern[] getOptimizePatterns() {
		return new OptimizePattern[] {
			OptimizePattern.DIVIDE,
			OptimizePattern.DIVIDE,
			OptimizePattern.ALL
		};
	}

}
