package org.torikiri.jexpression.expression.optimizer;

import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.Operation;
import org.torikiri.jexpression.expression.CompositeExpression;
import org.torikiri.jexpression.operation.DivideOperation;
import org.torikiri.jexpression.operation.MultiplyOperation;

/**
 * (a / b) + (c / d) -> ((a * d) + (b * c)) / (b * d)
 * <pre>
 * <li>before</li>
 *         (+)
 *       /    |
 *    (/)     (/)
 *   /  |    /  |
 * (a) (b) (c) (d)
 * 
 * <li>after</li>
 *               (/)
 *            /      |
 *          (+)      (*)
 *       /     |    /  |
 *    (*)     (*) (b) (d)
 *   /  |    /  |
 * (a) (d) (b) (c)
 * </pre>
 * @author Kiyotaka
 *
 */
public class CommandDXD extends OptimizeCommand {

	protected void execute(CompositeExpression expr, JExpression a,
			JExpression b, JExpression c, JExpression d, Operation op0,
			Operation op1, Operation op2) {

		JExpression ad = new CompositeExpression(a, d, new MultiplyOperation());
		JExpression bc = new CompositeExpression(b, c, new MultiplyOperation());
		JExpression bd = new CompositeExpression(b, d, new MultiplyOperation());

		expr.setExpr1(new CompositeExpression(ad, bc, op1));
		expr.setExpr2(bd);
		expr.setOp(new DivideOperation());
	}

	protected OptimizePattern[] getOptimizePatterns() {
		return new OptimizePattern[] {
			OptimizePattern.DIVIDE,
			OptimizePattern.ADD_SUB,
			OptimizePattern.DIVIDE
		};
	}
}
