package org.torikiri.jexpression.expression.optimizer;

import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.Operation;
import org.torikiri.jexpression.expression.CompositeExpression;
import org.torikiri.jexpression.operation.DivideOperation;
import org.torikiri.jexpression.operation.MultiplyOperation;

/**
 * (a + b) + (c / d) -> (((a + b) * d) + c) / d
 * <pre>
 * <li>before</li>
 *         (+)
 *       /    |
 *    (+)     (/)
 *   /  |    /  |
 * (a) (b) (c) (d)
 * 
 * <li>after</li>
 *             (/)
 *            /  |
 *          (+) (d)
 *         /  |
 *       (*) (c)
 *      /  |
 *    (+) (d)
 *   /  |
 * (a) (b)
 * </pre>
 * @author Kiyotaka
 *
 */
public class CommandXXD extends OptimizeCommand {

	protected void execute(CompositeExpression expr, JExpression a,
			JExpression b, JExpression c, JExpression d, Operation op0,
			Operation op1, Operation op2) {

		JExpression expr1 = new CompositeExpression(
				new CompositeExpression(
						new CompositeExpression(a, b, op0),
						d,
						new MultiplyOperation()
				),
				c,
				op1);

		expr.setExpr1(expr1);
		expr.setExpr2(d);
		expr.setOp(new DivideOperation());
	}

	protected OptimizePattern[] getOptimizePatterns() {
		return new OptimizePattern[] {
			OptimizePattern.ADD_SUB,
			OptimizePattern.ADD_SUB,
			OptimizePattern.DIVIDE
		};
	}
}
