package org.torikiri.jexpression.expression.optimizer;

import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.Operation;
import org.torikiri.jexpression.expression.BigDecimalValueExpression;
import org.torikiri.jexpression.expression.CompositeExpression;
import org.torikiri.jexpression.expression.Optimizer;
import org.torikiri.jexpression.operation.MultiplyOperation;

public abstract class OptimizeCommand implements Optimizer{

	private OptimizeCommand next;

	public final void optimize(CompositeExpression expr0) {

		CompositeExpression expr1 = toOptimizedExpression(expr0.getExpr1());
		CompositeExpression expr2 = toOptimizedExpression(expr0.getExpr2());

		JExpression a = expr1.getExpr1();
		JExpression b = expr1.getExpr2();
		JExpression c = expr2.getExpr1();
		JExpression d = expr2.getExpr2();

		Operation op0 = expr1.getOp();
		Operation op1 = expr0.getOp();
		Operation op2 = expr2.getOp();

		optimize(expr0, a, b, c, d, op0, op1, op2);
	}

	protected final void optimize(CompositeExpression expr, JExpression a, JExpression b, JExpression c, JExpression d, Operation op0, Operation op1, Operation op2) {
		OptimizePattern[] pattern = getOptimizePatterns();
		Operation[] operations = new Operation[] {op0, op1, op2};
		boolean matches = true;
		for (int i=0; i<pattern.length; i++) {
			if (!pattern[i].matches(operations[i])) {
				matches = false;
				break;
			}
		}
		if (matches) {
			execute(expr, a, b, c, d, op0, op1, op2);
		}
		if (next != null) {
			next.optimize(expr, a, b, c, d, op0, op1, op2);
		}
	}

	public OptimizeCommand addChain(OptimizeCommand next) {
		if (this.next == null) {
			this.next = next;
		} else {
			this.next.addChain(next);
		}
		return this;
	}

	private CompositeExpression toOptimizedExpression(JExpression expr) {
		CompositeExpression result;
		if (expr instanceof CompositeExpression) {
			result = (CompositeExpression) expr;
			result.optimize();
		} else {
			result = new CompositeExpression(expr, new BigDecimalValueExpression(1), new MultiplyOperation());
		}
		return result;
	}

	protected abstract OptimizePattern[] getOptimizePatterns();

	protected abstract void execute(CompositeExpression expr, JExpression a, JExpression b, JExpression c, JExpression d, Operation op0, Operation op1, Operation op2);

}
