/*
 * Decompiled with CFR 0.152.
 */
package org.torikiri.jexpression;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.torikiri.jexpression.JECompiler;
import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.expression.BigDecimalValueExpression;

public class JEContext {
    private Map ctx = new HashMap();
    private Integer roundingMode;
    private Integer scale;

    public JEContext() {
    }

    public JEContext(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public JEContext(int scale, int roundingMode) {
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public JEContext append(String varName, JExpression func) {
        this.ctx.put(varName, func);
        return this;
    }

    public JEContext append(String varName, String func) {
        return this.append(varName, JECompiler.compile(func));
    }

    public JEContext append(String varName, BigDecimal value) {
        return this.append(varName, new BigDecimalValueExpression(value));
    }

    public JEContext append(String varName, int value) {
        return this.append(varName, new BigDecimal(value));
    }

    public JEContext append(String varName, long value) {
        return this.append(varName, BigDecimal.valueOf(value));
    }

    public JExpression getFunc(String varName) {
        JExpression result = (JExpression)this.ctx.get(varName);
        if (result == null) {
            throw new IllegalArgumentException("No such variable. [" + varName + "]");
        }
        return result;
    }

    public JEContext roundingMode(int roundingMode) {
        this.roundingMode = new Integer(roundingMode);
        return this;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public boolean hasRoundingMode() {
        return this.roundingMode != null;
    }

    public JEContext scale(int scale) {
        this.scale = new Integer(scale);
        return this;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean hasScale() {
        return this.scale != null;
    }
}

