/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class BaseDialog
extends JDialog
implements WindowListener {
    private JButton okBtn = new JButton("\u8a2d\u5b9a");
    private JButton cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
    private boolean resultFlag;

    public BaseDialog(JFrame frame) {
        super(frame, null, true);
    }

    protected abstract void resultProcess();

    protected abstract JPanel createMainPanel();

    protected void setDialog(JFrame view, String title, String okLabel, String cancelLabel) {
        this.okBtn.setText(okLabel);
        this.cancelBtn.setText(cancelLabel);
        this.setDialog(view, title);
    }

    protected void setDialog(JFrame view, String title) {
        this.setTitle(title);
        JPanel pane = this.createMainPanel();
        this.getContentPane().add((Component)pane, "Center");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.dispose();
                BaseDialog.this.resultFlag = true;
                BaseDialog.this.resultProcess();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BaseDialog.this.dispose();
                BaseDialog.this.resultFlag = false;
            }
        });
        pane = new JPanel();
        pane.add(this.okBtn);
        pane.add(this.cancelBtn);
        this.getContentPane().add((Component)pane, "South");
        this.setDefaultCloseOperation(2);
        Dimension dim = this.getPreferredSize();
        int width = dim.width + 50;
        int height = dim.height + 50;
        int x = view.getLocationOnScreen().x;
        int y = view.getLocationOnScreen().y;
        x = x + view.getSize().width / 2 - width / 2;
        if (x < 0) {
            x = view.getLocationOnScreen().x;
        }
        this.setBounds(x, y, width, height);
        this.setResizable(false);
        this.setVisible(true);
    }

    protected void gridLayoutComponent(JPanel pane, GridBagLayout layout, GridBagConstraints gc, Component comp, int x, int y, boolean enabled) {
        gc.gridx = x;
        gc.gridy = y;
        layout.setConstraints(comp, gc);
        pane.add(comp);
        comp.setEnabled(enabled);
    }

    protected void enabledSetting(ItemEvent e, Component comp) {
        if (1 == e.getStateChange()) {
            comp.setEnabled(true);
            comp.requestFocusInWindow();
        } else {
            comp.setEnabled(false);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public boolean getResult() {
        return this.resultFlag;
    }
}

