/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class Ftp
implements Runnable {
    public static final int OPEN = 1;
    public static final int CLOSE = 2;
    public static final int CWD = 3;
    public static final int PWD = 4;
    public static final int TYPE_I = 5;
    public static final int TYPE_A = 6;
    public static final int LIST = 7;
    public static final int MKD = 8;
    public static final int RMD = 9;
    public static final int DELE = 10;
    public static final int REN = 11;
    public static final int RETR = 12;
    public static final int STOR = 13;
    private static final String FTP_OPEN_DATA_CONNECTION = "150";
    private static final String FTP_COMMAND_OK = "200";
    private static final String FTP_SYSTEM_NAME = "215";
    private static final String FTP_OPEN = "220";
    private static final String FTP_CLOSE = "221";
    private static final String FTP_CLOSE_DATA_CONNECTION = "226";
    private static final String FTP_PASV = "227";
    private static final String FTP_LOGIN = "230";
    private static final String FTP_ACTION_OK = "250";
    private static final String FTP_PATHNAME = "257";
    private static final String FTP_PASS = "331";
    private static final String FTP_OTHER_INFO = "350";
    private static final String FTP_NOT_LOGIN = "530";
    private static Ftp selfObj = null;
    private static Host host = null;
    private static String initDirectory = null;
    private static String encoding = null;
    private static boolean pasvMode = false;
    private static byte[] hostAddress;
    private static Socket ctrlSocket;
    private static BufferedReader ctrlInput;
    private static ControlWriter ctrlOutput;
    private static fHimeDialog view;
    private static String systemName;
    private int runParam = -1;
    private int param;
    private String para1;
    private String para2;
    private File[] uploadFiles;
    private InetAddress pasvIp = null;
    private int pasvPort = 0;

    private Ftp() {
        host = null;
        view = null;
    }

    private Socket passive(String command, String code) {
        Socket dataSocket = null;
        try {
            ctrlOutput.println("PASV");
            ctrlOutput.flush();
            if (!this.messageCheck(ctrlInput, FTP_PASV)) {
                return null;
            }
            dataSocket = new Socket(this.pasvIp, this.pasvPort);
            ctrlOutput.println(command);
            ctrlOutput.flush();
            if (!this.messageCheck(ctrlInput, code)) {
                return null;
            }
        }
        catch (Exception ex) {
            view.setText(ex + "\nPASSIVE MODE Exception\n");
        }
        return dataSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket active(String command, String code) {
        Socket dataSocket = null;
        ServerSocket ctrlDataSocket = null;
        try {
            ctrlDataSocket = this.ftpPortCommand();
            if (ctrlDataSocket == null) {
                Socket socket = null;
                return socket;
            }
            ctrlOutput.println(command);
            ctrlOutput.flush();
            if (!this.messageCheck(ctrlInput, code)) {
                Socket socket = null;
                return socket;
            }
            dataSocket = ctrlDataSocket.accept();
        }
        catch (Exception ex) {
            view.setText(ex + "\nACTIVE MODE Exception\n");
        }
        finally {
            try {
                if (ctrlDataSocket != null) {
                    ctrlDataSocket.close();
                }
            }
            catch (Exception ex) {
                view.setText(ex + "\nACTIVE MODE Exception\n");
            }
        }
        return dataSocket;
    }

    private String rightTrimAddSpace(String str, int len) {
        StringBuffer spc = new StringBuffer(str);
        for (int i = 0; i < len; ++i) {
            spc.append(" ");
        }
        return spc.toString().substring(0, len);
    }

    private String leftTrimAddSpace(String str, int len) {
        StringBuffer spc = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            spc.append(" ");
        }
        spc.append(str);
        return spc.toString().substring(spc.toString().length() - len);
    }

    private void dirListPrint(Vector list) {
        DirStruct dir;
        int i;
        int[] maxLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        for (i = 0; i < list.size(); ++i) {
            dir = (DirStruct)list.get(i);
            if (maxLen[1] < dir.getLink().length()) {
                maxLen[1] = dir.getLink().length();
            }
            if (maxLen[2] < dir.getOwner().length()) {
                maxLen[2] = dir.getOwner().length();
            }
            if (maxLen[3] < dir.getGroup().length()) {
                maxLen[3] = dir.getGroup().length();
            }
            if (maxLen[4] < dir.getSize().length()) {
                maxLen[4] = dir.getSize().length();
            }
            if (maxLen[5] < dir.getMonth().length()) {
                maxLen[5] = dir.getMonth().length();
            }
            if (maxLen[6] < dir.getDay().length()) {
                maxLen[6] = dir.getDay().length();
            }
            if (maxLen[7] >= dir.getYear().length()) continue;
            maxLen[7] = dir.getYear().length();
        }
        for (i = 0; i < list.size(); ++i) {
            dir = (DirStruct)list.get(i);
            StringBuffer buff = new StringBuffer();
            buff.append(dir.getAccess() + " ");
            buff.append(this.leftTrimAddSpace(dir.getLink(), maxLen[1]) + " ");
            buff.append(this.rightTrimAddSpace(dir.getOwner(), maxLen[2]) + " ");
            buff.append(this.rightTrimAddSpace(dir.getGroup(), maxLen[3]) + " ");
            buff.append(this.leftTrimAddSpace(dir.getSize(), maxLen[4]) + " ");
            buff.append(this.rightTrimAddSpace(dir.getMonth(), maxLen[5]) + " ");
            buff.append(this.leftTrimAddSpace(dir.getDay(), maxLen[6]) + " ");
            buff.append(this.leftTrimAddSpace(dir.getYear(), maxLen[7]) + " ");
            buff.append(dir.getName());
            view.setText(buff.toString() + "\n");
        }
    }

    private DirStruct unixDirString(String str) {
        String[] buff = new String[9];
        int len = str.length();
        int idx = 0;
        int i = 0;
        while (i < len) {
            int endIdx = str.indexOf(" ", i);
            if (endIdx == -1) {
                buff[8] = str;
                for (int j = 0; j < 8; ++j) {
                    buff[j] = "";
                }
                break;
            }
            buff[idx] = str.substring(i, endIdx);
            for (i = endIdx; str.charAt(i) == ' ' && i < len; ++i) {
            }
            if (++idx != 8) continue;
            buff[idx] = str.substring(i);
            break;
        }
        return new DirStruct(buff);
    }

    private void ftpStorCommand(File[] fromFiles) {
        for (int i = 0; i < fromFiles.length; ++i) {
            String fromName = fromFiles[i].getPath();
            String toName = fromFiles[i].getName();
            try {
                int c;
                Socket dataSocket = pasvMode ? this.passive("STOR " + toName, FTP_OPEN_DATA_CONNECTION) : this.active("STOR " + toName, FTP_OPEN_DATA_CONNECTION);
                if (dataSocket == null) {
                    return;
                }
                view.setText(fromName + " \u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u4e2d...\n");
                OutputStream os = dataSocket.getOutputStream();
                FileInputStream fis = new FileInputStream(fromName);
                while ((c = fis.read()) != -1) {
                    os.write(c);
                }
                fis.close();
                os.close();
                this.messageCheck(ctrlInput, FTP_CLOSE_DATA_CONNECTION);
                dataSocket.close();
                continue;
            }
            catch (Exception ex) {
                view.setText("Data Connection Exception\n");
            }
        }
    }

    private void ftpRetrCommand(String fromName, String toDir) {
        String toName = fromName.charAt(fromName.length() - 1) != '/' ? toDir + "/" + fromName : toDir + fromName;
        try {
            int c;
            Socket dataSocket = pasvMode ? this.passive("RETR " + fromName, FTP_OPEN_DATA_CONNECTION) : this.active("RETR " + fromName, FTP_OPEN_DATA_CONNECTION);
            if (dataSocket == null) {
                return;
            }
            view.setText(fromName + " \u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d...\n");
            InputStream is = dataSocket.getInputStream();
            FileOutputStream fos = new FileOutputStream(toName);
            while ((c = is.read()) != -1) {
                fos.write(c);
            }
            fos.close();
            is.close();
            this.messageCheck(ctrlInput, FTP_CLOSE_DATA_CONNECTION);
            dataSocket.close();
        }
        catch (Exception ex) {
            view.setText("Data Connection Exception\n");
        }
    }

    private void ftpRenCommand(String fromName, String toName) {
        ctrlOutput.println("RNFR " + fromName);
        ctrlOutput.flush();
        if (this.messageCheck(ctrlInput, FTP_OTHER_INFO)) {
            ctrlOutput.println("RNTO " + toName);
            ctrlOutput.flush();
            this.messageCheck(ctrlInput, FTP_ACTION_OK);
        }
    }

    private void ftpDeleCommand(String path) {
        ctrlOutput.println("DELE " + path);
        ctrlOutput.flush();
        this.messageCheck(ctrlInput, FTP_ACTION_OK);
    }

    private void ftpRmdCommand(String path) {
        ctrlOutput.println("RMD " + path);
        ctrlOutput.flush();
        this.messageCheck(ctrlInput, FTP_ACTION_OK);
    }

    private void ftpMkdCommand(String path) {
        ctrlOutput.println("MKD " + path);
        ctrlOutput.flush();
        this.messageCheck(ctrlInput, FTP_PATHNAME);
    }

    private ServerSocket ftpPortCommand() {
        ServerSocket ctrlDataSocket = null;
        try {
            String port = "PORT ";
            ctrlDataSocket = new ServerSocket(0, 1);
            for (int i = 0; i < 4; ++i) {
                port = port + (hostAddress[i] & 0xFF) + ",";
            }
            port = port + (ctrlDataSocket.getLocalPort() / 256 & 0xFF) + ",";
            port = port + (ctrlDataSocket.getLocalPort() & 0xFF);
            ctrlOutput.println(port);
            ctrlOutput.flush();
            if (!this.messageCheck(ctrlInput, FTP_COMMAND_OK)) {
                ctrlDataSocket = null;
            }
        }
        catch (Exception ex) {
            view.setText("message port Exception\n");
            ctrlDataSocket = null;
        }
        return ctrlDataSocket;
    }

    private void ftpListCommand() {
        try {
            String str;
            Socket dataSocket = pasvMode ? this.passive("LIST", FTP_OPEN_DATA_CONNECTION) : this.active("LIST", FTP_OPEN_DATA_CONNECTION);
            if (dataSocket == null) {
                return;
            }
            InputStream is = dataSocket.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
            Vector<DirStruct> list = new Vector<DirStruct>();
            while ((str = br.readLine()) != null) {
                if (systemName.equals("UNIX")) {
                    list.add(this.unixDirString(str));
                    continue;
                }
                view.setText(str + "\n");
            }
            br.close();
            is.close();
            if (systemName.equals("UNIX")) {
                this.dirListPrint(list);
            }
            view.setText("\n");
            this.messageCheck(ctrlInput, FTP_CLOSE_DATA_CONNECTION);
            dataSocket.close();
        }
        catch (Exception ex) {
            view.setText("Data Connection Exception\n");
        }
    }

    private void ftpPwdCommand() {
        ctrlOutput.println("PWD");
        ctrlOutput.flush();
        this.messageCheck(ctrlInput, FTP_PATHNAME);
    }

    private void ftpCwdCommand(String path) {
        ctrlOutput.println("CWD " + path);
        ctrlOutput.flush();
        this.messageCheck(ctrlInput, FTP_ACTION_OK);
        this.ftpPwdCommand();
    }

    private void ftpTypeCommand(boolean ascii) {
        if (ascii) {
            ctrlOutput.println("TYPE A");
        } else {
            ctrlOutput.println("TYPE I");
        }
        ctrlOutput.flush();
        this.messageCheck(ctrlInput, FTP_COMMAND_OK);
    }

    private void pasvSetting(String str) {
        try {
            int sPos = str.indexOf("(");
            int ePos = str.lastIndexOf(")");
            String ip_port = str.substring(sPos + 1, ePos);
            StringBuffer ip = new StringBuffer();
            int pos = 0;
            int cCnt = 0;
            while (cCnt < 4) {
                char c = ip_port.charAt(pos);
                if (c == ',') {
                    ++cCnt;
                    c = '.';
                }
                if (cCnt < 4) {
                    ip.append(c);
                }
                ++pos;
            }
            sPos = ip_port.indexOf(",", pos);
            String port1 = ip_port.substring(pos, sPos);
            String port2 = ip_port.substring(sPos + 1);
            this.pasvPort = Integer.parseInt(port1) * 256 + Integer.parseInt(port2);
            this.pasvIp = InetAddress.getByName(ip.toString());
        }
        catch (Exception ex) {
            view.setText(ex + "\nPASV IP | PORT Exception\n");
        }
    }

    private boolean messageCheck(BufferedReader br, String code) {
        boolean flag = true;
        try {
            String str = br.readLine();
            if (str.length() < 4) {
                view.setText("[\u30a8\u30e9\u30fc] " + str + "\n");
                return false;
            }
            if (str.substring(0, 3).compareTo(code) != 0) {
                flag = false;
                code = str.substring(0, 3);
            }
            if (str.charAt(3) == '-') {
                String catStr;
                do {
                    catStr = br.readLine();
                    str = str + "\n" + catStr;
                } while (catStr.substring(0, 3).compareTo(code) != 0);
            }
            if (!flag) {
                str = "[\u30a8\u30e9\u30fc] " + str;
            } else if (code.equals(FTP_PASV)) {
                this.pasvSetting(str);
            }
            if (!code.equals(FTP_SYSTEM_NAME)) {
                view.setText(str + "\n");
            } else {
                systemName = str.toUpperCase().indexOf("UNIX") != -1 ? "UNIX" : "OTHER";
            }
        }
        catch (Exception ex) {
            view.setText(ex + "\nmessage io Exception\n");
        }
        return flag;
    }

    private void disConnect() {
        try {
            if (ctrlOutput == null || ctrlInput == null) {
                return;
            }
            ctrlOutput.println("QUIT");
            ctrlOutput.flush();
            this.messageCheck(ctrlInput, FTP_CLOSE);
            ctrlOutput.close();
            ctrlInput.close();
            ctrlSocket.close();
            view.setText("\u5207\u65ad\u3057\u307e\u3057\u305f\u3002\n");
            ctrlOutput = null;
            ctrlInput = null;
            ctrlSocket = null;
        }
        catch (Exception ex) {
            view.setText(ex + "\n");
        }
    }

    private void connect() {
        if (host == null) {
            return;
        }
        if (ctrlSocket != null) {
            this.disConnect();
            return;
        }
        String hostName = host.getHost();
        String userName = host.getUser();
        String password = host.getPassword();
        initDirectory = host.getInitDirectory();
        encoding = host.getEncoding();
        pasvMode = host.getPasvMode().toLowerCase().equals("true");
        try {
            view.setText(host.getID() + " \u306b\u63a5\u7d9a\u4e2d...\n");
            ctrlSocket = new Socket(hostName, 21);
            ctrlInput = new BufferedReader(new InputStreamReader(ctrlSocket.getInputStream(), encoding));
            ctrlOutput = new ControlWriter(ctrlSocket.getOutputStream(), encoding, view);
            this.messageCheck(ctrlInput, FTP_OPEN);
        }
        catch (Exception ex) {
            view.setText("\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n");
            return;
        }
        hostAddress = ctrlSocket.getLocalAddress().getAddress();
        view.setText(hostName + " \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002\n");
        try {
            ctrlOutput.println("USER " + userName, true);
            ctrlOutput.flush();
            this.messageCheck(ctrlInput, FTP_PASS);
            ctrlOutput.println("PASS " + password, true);
            ctrlOutput.flush();
            if (!this.messageCheck(ctrlInput, FTP_LOGIN)) {
                view.setText(userName + " \u306e\u30ed\u30b0\u30a4\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n");
                this.disConnect();
                return;
            }
            view.setText(userName + " \u306b\u30ed\u30b0\u30a4\u30f3\u3057\u307e\u3057\u305f\u3002\n");
            ctrlOutput.println("SYST", false);
            ctrlOutput.flush();
            this.messageCheck(ctrlInput, FTP_SYSTEM_NAME);
            if (!initDirectory.equals("")) {
                this.ftpCwdCommand(initDirectory);
            } else {
                this.ftpPwdCommand();
            }
            this.ftpTypeCommand(false);
        }
        catch (Exception ex) {
            view.setText(ex + "\n");
        }
    }

    public boolean isStatus() {
        return ctrlSocket != null;
    }

    public static Ftp getInstance() {
        if (selfObj == null) {
            selfObj = new Ftp();
        }
        return selfObj;
    }

    public void setHost(Host host, fHimeDialog view) {
        Ftp.host = host;
        Ftp.view = view;
    }

    public void ftp(int param) {
        this.param = param;
    }

    public void ftp(int param, File[] files) {
        this.param = param;
        this.uploadFiles = files;
    }

    public void ftp(int param, String para1) {
        this.param = param;
        this.para1 = para1;
    }

    public void ftp(int param, String para1, String para2) {
        this.param = param;
        this.para1 = para1;
        this.para2 = para2;
    }

    public void run() {
        view.enableBtn(false);
        switch (this.param) {
            case 1: {
                this.connect();
                break;
            }
            case 2: {
                this.disConnect();
                break;
            }
            case 3: {
                this.ftpCwdCommand(this.para1);
                break;
            }
            case 4: {
                this.ftpPwdCommand();
                break;
            }
            case 5: {
                this.ftpTypeCommand(false);
                break;
            }
            case 6: {
                this.ftpTypeCommand(true);
                break;
            }
            case 7: {
                this.ftpListCommand();
                break;
            }
            case 8: {
                this.ftpMkdCommand(this.para1);
                break;
            }
            case 9: {
                this.ftpRmdCommand(this.para1);
                break;
            }
            case 10: {
                this.ftpDeleCommand(this.para1);
                break;
            }
            case 11: {
                this.ftpRenCommand(this.para1, this.para2);
                break;
            }
            case 12: {
                this.ftpRetrCommand(this.para1, this.para2);
                break;
            }
            case 13: {
                this.ftpStorCommand(this.uploadFiles);
            }
        }
        view.enableBtn(true);
    }

    static {
        ctrlSocket = null;
        ctrlInput = null;
        ctrlOutput = null;
    }
}

