/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Vector;
import jongs.JongScripter;
import jongs.jongsImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsDisplay
extends Canvas {
    public static final int EFE_NOEFFECT = 2000;
    public static final int EFE_ZOOMIN = 2001;
    public static final int EFE_MOSAIC = 2002;
    public static final int EFE_FADEIN = 2003;
    public static final int EFE_WIPE = 2004;
    public static final int EFE_HASH = 2005;
    public static final int EFE_BOOK_LEFT = 2006;
    public static final int EFE_BOOK_RIGHT = 2007;
    public static final int POS_UPPER = Integer.MAX_VALUE;
    public static final int POS_LOWER = 0x7FFFFFFE;
    public static final int POS_MIDDLE = 0x7FFFFFFD;
    public static final int POS_LEFT = 0x7FFFFFFC;
    public static final int POS_RIGHT = 0x7FFFFFFB;
    public static final int POS_CENTER = 0x7FFFFFFA;
    static final long serialVersionUID = 0x100001L;
    BufferedImage disp_buf00 = null;
    BufferedImage disp_buf01 = null;
    Graphics gpx;
    Graphics gdb00;
    Graphics gdb01;
    int width;
    int height;
    Font textFont;
    String fontName;
    int fontStyle;
    int fontSize;
    int fontCol1;
    int fontCol2;
    Color fontColor1;
    Color fontColor2;
    String text;
    Rectangle txtArea;
    HashMap<String, int[]> positionMap;
    jongsImage[] cellImages;
    char presskey;
    int clickx;
    int clicky;
    boolean mouseenter;
    int mouseX;
    int mouseY;
    Rectangle btnArea;
    int bc0;
    int bc1;
    int bc2;
    int bc3;
    Rectangle[] button;
    String[] buttonText;
    Font buttonFont;
    int buttonvalue;
    int cellvalue;
    int pressed;
    int overd;
    HashMap<String, int[]> transitionMap;
    JongScripter js;
    int transCode;
    int commandCode;
    int transition_wtime;
    boolean busy;

    public jongsDisplay() {
        this.initJongsDisplay(800, 600);
    }

    public jongsDisplay(int w, int h) {
        this.initJongsDisplay(w, h);
    }

    public void initJongsDisplay(int dispw, int disph) {
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent ke) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                if (jongsDisplay.this.commandCode == 1011) {
                    jongsDisplay.this.presskey = ke.getKeyChar();
                    jongsDisplay.this.commandCode = 0;
                } else if (jongsDisplay.this.commandCode == 2014) {
                    if (ke.getKeyCode() == 39) {
                        ++jongsDisplay.this.overd;
                        if (jongsDisplay.this.overd >= jongsDisplay.this.button.length) {
                            jongsDisplay.this.overd = 0;
                        }
                        jongsDisplay.this.buttonvalue = -1;
                        jongsDisplay.this.pressed = -1;
                        jongsDisplay.this.drawButtons(jongsDisplay.this.gdb01);
                        jongsDisplay.this.repaint();
                    } else if (ke.getKeyCode() == 37) {
                        --jongsDisplay.this.overd;
                        if (jongsDisplay.this.overd < 0) {
                            jongsDisplay.this.overd = jongsDisplay.this.button.length - 1;
                        }
                        jongsDisplay.this.buttonvalue = -1;
                        jongsDisplay.this.pressed = -1;
                        jongsDisplay.this.drawButtons(jongsDisplay.this.gdb01);
                        jongsDisplay.this.repaint();
                    } else if (ke.getKeyCode() == 10) {
                        if (jongsDisplay.this.overd < 0) {
                            jongsDisplay.this.overd = 0;
                            jongsDisplay.this.drawButtons(jongsDisplay.this.gdb01);
                            jongsDisplay.this.repaint();
                        } else {
                            jongsDisplay.this.buttonvalue = jongsDisplay.this.overd;
                            jongsDisplay.this.commandCode = 0;
                            jongsDisplay.this.pressed = -1;
                            jongsDisplay.this.drawButtons(jongsDisplay.this.gdb01);
                            jongsDisplay.this.repaint();
                        }
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                jongsDisplay.this.mouseX = e.getX();
                jongsDisplay.this.mouseY = e.getY();
                if (jongsDisplay.this.commandCode == 2014) {
                    jongsDisplay.this.buttonvalue = jongsDisplay.this.checkButtonClick(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.buttonvalue != -1) {
                        if (jongsDisplay.this.buttonvalue == jongsDisplay.this.pressed) {
                            jongsDisplay.this.commandCode = 0;
                        } else {
                            jongsDisplay.this.buttonvalue = -1;
                        }
                    }
                    jongsDisplay.this.pressed = -1;
                    jongsDisplay.this.drawButtons(jongsDisplay.this.gdb01);
                    jongsDisplay.this.repaint();
                } else if (jongsDisplay.this.commandCode == 1011) {
                    jongsDisplay.this.presskey = (char)32;
                    jongsDisplay.this.commandCode = 0;
                } else if (jongsDisplay.this.commandCode == 2021) {
                    jongsDisplay.this.cellvalue = jongsDisplay.this.checkCellClick(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.cellvalue != -1) {
                        if (jongsDisplay.this.cellvalue == jongsDisplay.this.pressed) {
                            jongsDisplay.this.commandCode = 0;
                        } else {
                            jongsDisplay.this.cellvalue = -1;
                        }
                    }
                    jongsDisplay.this.pressed = -1;
                    System.out.println("clickedCell=" + jongsDisplay.this.cellvalue);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (jongsDisplay.this.busy) {
                    return;
                }
                jongsDisplay.this.mouseX = e.getX();
                jongsDisplay.this.mouseY = e.getY();
                if (jongsDisplay.this.commandCode == 2014) {
                    jongsDisplay.this.pressed = jongsDisplay.this.checkButtonClick(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.pressed != -1) {
                        jongsDisplay.this.overd = -1;
                    }
                    jongsDisplay.this.drawButtons(jongsDisplay.this.gdb01);
                    jongsDisplay.this.repaint();
                } else if (jongsDisplay.this.commandCode == 2021) {
                    jongsDisplay.this.pressed = jongsDisplay.this.checkCellClick(jongsDisplay.this.mouseX, jongsDisplay.this.mouseY);
                    if (jongsDisplay.this.pressed != -1) {
                        jongsDisplay.this.overd = -1;
                    }
                }
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }
        });
        this.setBounds(dispw, disph);
        this.setTextFont("Selif", "plain", 14);
        this.setFontColor(0xFFFFFF, 0xAAAAAA);
        this.setCellNumber(3);
        this.text = "";
        this.setSelectArea(50, 400, 700, 40);
        this.setSelectColor(0xAAAAAA, 0xEEEEEE, 0xFFFFFF, 0);
        this.gpx = this.getGraphics();
        this.mouseenter = true;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.initTransitionCode();
        this.initPositionCode();
        this.commandCode = 0;
        this.busy = false;
        this.mouseY = -1;
        this.mouseX = -1;
    }

    private void initTransitionCode() {
        this.transitionMap = new HashMap();
        this.transitionMap.put("_noeffect", this.getIntArray(2000));
        this.transitionMap.put("_zoomin", this.getIntArray(2001));
        this.transitionMap.put("_mosaic", this.getIntArray(2002));
        this.transitionMap.put("_fadein", this.getIntArray(2003));
        this.transitionMap.put("_wipe", this.getIntArray(2004));
        this.transitionMap.put("_hash", this.getIntArray(2005));
        this.transitionMap.put("_bookleft", this.getIntArray(2006));
        this.transitionMap.put("_bookright", this.getIntArray(2007));
    }

    public int getTransitionCode(String tr) {
        String tstr = tr.trim().toLowerCase();
        if (this.transitionMap.containsKey(tstr)) {
            return this.transitionMap.get(tstr)[0];
        }
        return 2000;
    }

    private void initPositionCode() {
        this.positionMap = new HashMap();
        this.positionMap.put("_upper", this.getIntArray(Integer.MAX_VALUE));
        this.positionMap.put("_lower", this.getIntArray(0x7FFFFFFE));
        this.positionMap.put("_middle", this.getIntArray(0x7FFFFFFD));
        this.positionMap.put("_left", this.getIntArray(0x7FFFFFFC));
        this.positionMap.put("_right", this.getIntArray(0x7FFFFFFB));
        this.positionMap.put("_center", this.getIntArray(0x7FFFFFFA));
    }

    public int getPositionCode(String tr) {
        String tstr = tr.trim().toLowerCase();
        if (this.positionMap.containsKey(tstr)) {
            return this.positionMap.get(tstr)[0];
        }
        return 0;
    }

    public Point changePosition(int cell, int x, int y) {
        switch (x) {
            case 0x7FFFFFFC: {
                x = 0;
                break;
            }
            case 0x7FFFFFFB: {
                int w = this.cellImages[cell].getWidth();
                x = this.width - w;
                break;
            }
            case 0x7FFFFFFA: {
                int w = this.cellImages[cell].getWidth();
                x = (this.width - w) / 2;
            }
        }
        switch (y) {
            case 0x7FFFFFFF: {
                y = 0;
                break;
            }
            case 0x7FFFFFFE: {
                int h = this.cellImages[cell].getHeight();
                y = this.height - h;
                break;
            }
            case 0x7FFFFFFD: {
                int h = this.cellImages[cell].getHeight();
                y = (this.height - h) / 2;
            }
        }
        Point pt = new Point(x, y);
        return pt;
    }

    private int[] getIntArray(int cd) {
        int[] code = new int[]{cd};
        return code;
    }

    public void setBounds(int w, int h) {
        this.setVisible(false);
        this.setBounds(0, 0, w, h);
        this.disp_buf00 = new BufferedImage(w, h, 4);
        this.disp_buf01 = new BufferedImage(w, h, 4);
        this.gdb00 = this.disp_buf00.getGraphics();
        this.gdb01 = this.disp_buf01.getGraphics();
        this.setVisible(true);
        this.setTextArea(10, 30, w - 20, h - 60);
    }

    public void setTextArea(int x, int y, int w, int h) {
        this.txtArea = new Rectangle(x, y, w, h);
    }

    public void setFontColor(int fc1, int fc2) {
        this.fontColor1 = new Color(fc1);
        this.fontColor2 = new Color(fc2);
        this.fontCol1 = fc1;
        this.fontCol2 = fc2;
    }

    public void setTextFont(String fn, int fst, int fsz) {
        this.textFont = new Font(fn, fst, fsz);
        this.fontName = fn;
        this.fontStyle = fst;
        this.fontSize = fsz;
    }

    public void setTextFont(String fn, String fst, int fsz) {
        int style = 0;
        style = fst.toLowerCase().equals("plain") ? 0 : (fst.toLowerCase().equals("bold") ? 1 : (fst.toLowerCase().equals("italic") ? 2 : 0));
        this.setTextFont(fn, style, fsz);
    }

    public void setSelectArea(int x, int y, int w, int h) {
        this.btnArea = new Rectangle(x, y, w, h);
    }

    public void setButtonArea(int xnum, int ynum, int xspan, int yspan) {
        int bnum = xnum * ynum;
        int bwid = (this.btnArea.width - xspan * (xnum - 1)) / xnum;
        int bhei = (this.btnArea.height - yspan * (ynum - 1)) / ynum;
        if (bwid < 0) {
            bwid = this.btnArea.width / xnum;
            xspan = 0;
        }
        if (bhei < 0) {
            bhei = this.btnArea.height / ynum;
            yspan = 0;
        }
        this.button = new Rectangle[bnum];
        this.buttonText = new String[bnum];
        this.buttonFont = new Font("selif", 1, 8);
        int bn = 0;
        int bpy = this.btnArea.y;
        int by = 0;
        while (by < ynum) {
            int bpx = this.btnArea.x;
            int bx = 0;
            while (bx < xnum) {
                this.button[bn] = new Rectangle(bpx, bpy, bwid, bhei);
                ++bn;
                ++bx;
                bpx += bwid + xspan;
            }
            ++by;
            bpy += bhei + yspan;
        }
    }

    public void setSelectColor(int c1, int c2, int c3, int c4) {
        this.bc0 = c1;
        this.bc1 = c2;
        this.bc2 = c3;
        this.bc3 = c4;
    }

    public void setButtonParam(Vector<String> vct) {
        int n = vct.size();
        if (n < 5) {
            this.setButtonArea(vct.size(), 1, 20, 20);
        } else if (n % 5 == 0) {
            this.setButtonArea(5, n / 5, 20, 20);
        } else if (n % 4 == 0) {
            this.setButtonArea(4, n / 4, 20, 20);
        } else if (n % 3 == 0) {
            this.setButtonArea(3, n / 3, 20, 20);
        } else {
            this.setButtonArea(5, n / 5 + 1, 20, 20);
        }
        n = 0;
        while (n < vct.size() && n < this.button.length) {
            this.buttonText[n] = vct.get(n);
            ++n;
        }
        this.overd = -1;
        this.pressed = -1;
        this.buttonvalue = -1;
        this.commandCode = 2014;
        this.buttonsWrite();
    }

    public void cellClick() {
        int v = 0;
        int n = 0;
        while (n < this.cellImages.length) {
            if (this.cellImages[n] != null && this.cellImages[n].view) {
                ++v;
            }
            ++n;
        }
        if (v == 0) {
            this.cellvalue = -1;
            this.commandCode = 0;
            return;
        }
        this.overd = -1;
        this.pressed = -1;
        this.cellvalue = -1;
        this.commandCode = 2021;
    }

    public void buttonsWrite() {
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.textWrite();
        this.drawButtons(this.gdb01);
        this.repaint();
    }

    public void drawButtons(Graphics gp) {
        int n = 0;
        while (n < this.button.length) {
            if (this.buttonvalue == n || this.pressed == n) {
                this.drawButton(gp, n, 2);
            } else if (this.overd == n) {
                this.drawButton(gp, n, 1);
            } else {
                this.drawButton(gp, n, 0);
            }
            ++n;
        }
    }

    public void drawButton(Graphics g, int bnum, int stt) {
        boolean flag;
        int fc;
        Rectangle ra = this.button[bnum];
        String t = this.buttonText[bnum];
        int x = ra.x;
        int y = ra.y;
        int w = ra.width;
        int h = ra.height;
        switch (stt) {
            case 0: {
                fc = this.bc0;
                flag = true;
                break;
            }
            case 1: {
                fc = this.bc1;
                flag = true;
                break;
            }
            case 2: {
                fc = this.bc2;
                flag = false;
                break;
            }
            default: {
                return;
            }
        }
        g.setColor(new Color(fc));
        g.fill3DRect(x, y, w, h, flag);
        g.draw3DRect(x + 1, y + 1, w - 2, h - 2, flag);
        g.draw3DRect(x + 2, y + 2, w - 4, h - 4, flag);
        g.setColor(new Color(this.bc3));
        FontMetrics fm = g.getFontMetrics(this.buttonFont);
        int fh = fm.getHeight();
        int fy = y + fh + (h - fh) / 2;
        int fw = fm.stringWidth(t);
        int fx = x + (w - fw) / 2;
        g.drawString(t, fx, fy);
    }

    public int checkButtonClick(int zx, int zy) {
        int n = 0;
        while (n < this.button.length) {
            if (this.button[n] != null && this.button[n].contains(zx, zy)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int checkCellClick(int zx, int zy) {
        int n = this.cellImages.length - 1;
        while (n >= 0) {
            if (this.cellImages[n] != null && this.cellImages[n].checkImageClick(zx, zy)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void drawImageBuf() {
        if (this.busy) {
            System.out.println("can't make image buf.");
            System.out.println("drawImageBuf:cmd:" + this.commandCode + "/trcode:" + this.transCode);
            return;
        }
        Graphics dbg = this.gdb00;
        dbg.setColor(Color.black);
        dbg.fillRect(0, 0, this.disp_buf00.getWidth(), this.disp_buf00.getHeight());
        int n = 0;
        while (n < this.cellImages.length) {
            if (this.cellImages[n] != null && this.cellImages[n].view) {
                jongsImage ji = this.cellImages[n];
                dbg.drawImage(ji.image, ji.getX(), ji.getY(), ji.getWidth(), ji.getHeight(), this);
            }
            ++n;
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.busy) {
            return;
        }
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.transition(g);
        g.drawImage(this.disp_buf01, 0, 0, this);
        this.view(g);
    }

    public void drawText(String txt) {
        this.commandCode = 1011;
        this.text = txt.charAt(0) == '+' ? String.valueOf(this.text) + txt.substring(1) : txt;
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.textWrite();
        this.repaint();
    }

    public void drawNoWaitText(String txt) {
        this.commandCode = 1022;
        this.text = txt.charAt(0) == '+' ? String.valueOf(this.text) + txt.substring(1) : txt;
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.textWrite();
        this.repaint();
        this.commandCode = 0;
    }

    public void clearText() {
        this.text = "";
        this.gdb01.drawImage(this.disp_buf00, 0, 0, this);
        this.repaint();
        this.commandCode = 0;
    }

    public void textWrite() {
        int yz;
        Graphics2D sg = (Graphics2D)this.gdb01;
        String S = String.valueOf(this.text) + " ";
        sg.setFont(this.textFont);
        FontMetrics slffm = sg.getFontMetrics(this.textFont);
        int fhei = slffm.getHeight();
        int sx = this.txtArea.x;
        int sy = this.txtArea.y;
        int sw = this.txtArea.width;
        sg.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int c = 1;
        int e = 0;
        int b = 0;
        while (e < S.length()) {
            if (slffm.stringWidth(S.substring(b, e + 1)) > sw || S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                yz = c * fhei;
                sg.setColor(this.fontColor2);
                sg.drawString(S.substring(b, e), sx - 1, sy + yz - 1);
                sg.drawString(S.substring(b, e), sx + 1, sy + yz + 1);
                sg.drawString(S.substring(b, e), sx - 1, sy + yz + 1);
                sg.drawString(S.substring(b, e), sx + 1, sy + yz - 1);
                sg.setColor(this.fontColor1);
                sg.drawString(S.substring(b, e), sx, sy + yz);
                if (S.charAt(e) == '\\' && S.charAt(e + 1) == 'n') {
                    e = b = e + 2;
                } else {
                    b = e;
                }
                ++c;
            }
            ++e;
        }
        yz = c * fhei;
        sg.setColor(this.fontColor2);
        sg.drawString(S.substring(b), sx - 1, sy + yz - 1);
        sg.drawString(S.substring(b), sx + 1, sy + yz + 1);
        sg.drawString(S.substring(b), sx - 1, sy + yz + 1);
        sg.drawString(S.substring(b), sx + 1, sy + yz - 1);
        sg.setColor(this.fontColor1);
        sg.drawString(S.substring(b), sx, sy + yz);
    }

    public boolean setCellImage(int cell, String filename) {
        this.commandCode = 2002;
        if (this.cellImages[cell] == null) {
            this.cellImages[cell] = new jongsImage();
            this.cellImages[cell].setPoint(0, 0);
        }
        boolean ret = this.cellImages[cell].readImage(filename, this);
        this.commandCode = 0;
        return ret;
    }

    public void setTransColor(int cell, int tc) {
        this.commandCode = 2005;
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setTransColor(tc);
        }
        this.commandCode = 0;
    }

    public void setTransColor(int cell, int col, int alpha) {
        this.commandCode = 2005;
        if (this.cellImages[cell] != null) {
            int tc = alpha << 24 | col & 0xFFFFFF;
            this.cellImages[cell].setTransColor(tc);
        }
        this.commandCode = 0;
    }

    public void setTransColor(int cell, int x, int y, int alpha) {
        this.commandCode = 2005;
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setTransColor(x, y, alpha);
        }
        this.commandCode = 0;
    }

    public void setCellPosition(int cell, int x, int y) {
        this.commandCode = 2003;
        if (this.cellImages[cell] != null) {
            Point pt = this.changePosition(cell, x, y);
            this.cellImages[cell].setPoint(pt);
        }
        this.commandCode = 0;
    }

    public void setCellSize(int cell, int w, int h) {
        this.commandCode = 2004;
        if (this.cellImages[cell] != null) {
            this.cellImages[cell].setSize(w, h);
        }
        this.commandCode = 0;
    }

    public void setCellNumber(int cn) {
        this.cellImages = new jongsImage[cn];
    }

    public void viewDisplay(String flg) {
        this.commandCode = 2007;
        this.setCellView(flg);
        this.viewDisplay();
    }

    public void viewDisplay() {
        this.commandCode = 2007;
        this.drawImageBuf();
        this.repaint();
    }

    public void transitionDisplay(String flag, int tCode, JongScripter j) {
        this.commandCode = 2008;
        this.setCellView(flag);
        this.transitionDisplay(tCode, j);
    }

    public void transitionDisplay(int tCode, JongScripter j) {
        this.commandCode = 2008;
        this.transCode = tCode;
        this.js = j;
        this.drawImageBuf();
        this.repaint();
    }

    public void setCellView(String flagStr) {
        this.commandCode = 2006;
        int n = 0;
        while (n < flagStr.length() && n < this.cellImages.length) {
            char c = flagStr.charAt(n);
            if (this.cellImages[n] != null) {
                if (c == '0') {
                    this.cellImages[n].setView(false);
                } else if (c == '1') {
                    this.cellImages[n].setView(true);
                }
            }
            ++n;
        }
        this.commandCode = 0;
    }

    public void setCellView(int flag) {
        this.commandCode = 2006;
        int flagHex = flag;
        int n = 0;
        while (n < 32 && n < this.cellImages.length) {
            int c = flagHex & 1;
            if (this.cellImages[n] != null) {
                if (c == 0) {
                    this.cellImages[n].setView(false);
                } else if (c == 1) {
                    this.cellImages[n].setView(true);
                }
            }
            flagHex >>= 1;
            ++n;
        }
        this.commandCode = 0;
    }

    public void setCellView(int cell, int val) {
        this.commandCode = 2006;
        if (cell < this.cellImages.length && this.cellImages[cell] != null) {
            if (val == 0) {
                this.cellImages[cell].setView(false);
            } else if (val == 1) {
                this.cellImages[cell].setView(true);
            }
        }
        this.commandCode = 0;
    }

    public void setCellView(int cell, String val) {
        this.commandCode = 2006;
        if (cell < this.cellImages.length && this.cellImages[cell] != null) {
            if (val.trim().toLowerCase().equals("false")) {
                this.cellImages[cell].setView(false);
            } else if (val.trim().toLowerCase().equals("true")) {
                this.cellImages[cell].setView(true);
            }
        }
        this.commandCode = 0;
    }

    public void view(Graphics g) {
        if (this.commandCode != 2007) {
            return;
        }
        this.commandCode = 0;
    }

    public void transition(Graphics g) {
        if (this.commandCode != 2008) {
            return;
        }
        Image img1 = this.createImage(this.width, this.height);
        Graphics ig = img1.getGraphics();
        ig.drawImage(this.disp_buf01, 0, 0, this);
        Image img2 = this.createImage(this.width, this.height);
        ig = img2.getGraphics();
        ig.drawImage(this.disp_buf00, 0, 0, this);
        this.busy = true;
        int step = 100;
        this.transition_wtime = 10;
        switch (this.transCode) {
            case 2003: {
                this.EffectFadein(g, img1, img2);
                break;
            }
            case 2005: {
                this.EffectHash(g, img1, img2);
                break;
            }
            case 2002: {
                this.EffectMosaic(g, img1, img2);
                break;
            }
            case 2004: {
                this.EffectWipe(g, img1, img2, 3, step);
                break;
            }
            case 2001: {
                this.EffectZoomin(g, img1, img2, step);
                break;
            }
            case 2007: {
                this.EffectBook(g, img1, img2, 0, step);
                break;
            }
            case 2006: {
                this.EffectBook(g, img1, img2, 1, step);
                break;
            }
        }
        this.gdb01.drawImage(img2, 0, 0, this);
        img1 = null;
        img2 = null;
        System.gc();
        this.transCode = -1;
        this.busy = false;
        this.commandCode = 0;
    }

    public void waitMiliSec(int w) {
        if (this.js != null) {
            this.js.waitMiliSec(w);
        }
    }

    private void EffectFadein(Graphics g, Image img1, Image img2) {
        int iw = this.width;
        int ih = this.height;
        Image fbuf = this.createImage(iw, ih * 2);
        Graphics fg = fbuf.getGraphics();
        Image bbuf = this.createImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        fg.drawImage(img1, 0, 0, iw, ih, this);
        fg.drawImage(img2, 0, ih, iw, ih, this);
        int bkw = 5;
        int i = 0;
        while (i < bkw) {
            int x = i;
            while (x < iw) {
                fg.copyArea(x, 0 + ih, 1, ih, 0, -ih);
                x += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this);
            this.waitMiliSec(this.transition_wtime);
            int y = bkw - 1 - i;
            while (y < ih) {
                fg.copyArea(0, y + ih, iw, 1, 0, -ih);
                y += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this);
            this.waitMiliSec(this.transition_wtime);
            x = bkw - 1 - i;
            while (x < iw) {
                fg.copyArea(x, 0 + ih, 1, ih, 0, -ih);
                x += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this);
            this.waitMiliSec(this.transition_wtime);
            y = i;
            while (y < ih) {
                fg.copyArea(0, y + ih, iw, 1, 0, -ih);
                y += bkw;
            }
            bg.drawImage(fbuf, 0, 0, iw, ih * 2, this);
            g.drawImage(bbuf, 0, 0, this);
            this.waitMiliSec(this.transition_wtime);
            ++i;
        }
        g.drawImage(img2, 0, 0, this);
    }

    private void EffectHash(Graphics g, Image img1, Image img2) {
        int iw = this.width;
        int ih = this.height;
        int w = 20;
        int mw = iw / w;
        int wmw = w + mw;
        int wbh = ih * 2;
        Image wbuf = this.createImage(iw, wbh);
        Graphics wg = wbuf.getGraphics();
        Image bbuf = this.createImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        wg.drawImage(img1, 0, 0, iw, ih, this);
        wg.drawImage(img2, 0, ih, iw, ih, this);
        wg.copyArea(0, iw, 1, ih, 0, -ih);
        int x1 = 0;
        while (x1 < wmw) {
            int x2 = 0;
            int x3 = x1;
            while (x2 < x1) {
                int x = mw * (x1 - x3) + x3;
                wg.copyArea(x, ih, 1, ih, 0, -ih);
                ++x2;
                --x3;
            }
            bg.drawImage(wbuf, 0, 0, this);
            g.drawImage(bbuf, 0, 0, this);
            this.waitMiliSec(this.transition_wtime);
            ++x1;
        }
        g.drawImage(img2, 0, 0, this);
    }

    private void EffectMosaic(Graphics g, Image img1, Image img2) {
        Graphics wg;
        Image wimg;
        int fh;
        int fw;
        int iw = this.width;
        int ih = this.height;
        int f = 2;
        while (f <= 64) {
            fw = iw / f;
            fh = iw / f;
            wimg = this.createImage(fw, fh);
            wg = wimg.getGraphics();
            wg.drawImage(img1, 0, 0, fw, fh, this);
            g.drawImage(wimg, 0, 0, iw, ih, this);
            this.waitMiliSec(this.transition_wtime);
            f *= 2;
        }
        f = 64;
        while (f > 1) {
            fw = iw / f;
            fh = ih / f;
            wimg = this.createImage(fw, fh);
            wg = wimg.getGraphics();
            wg.drawImage(img2, 0, 0, fw, fh, this);
            g.drawImage(wimg, 0, 0, iw, ih, this);
            this.waitMiliSec(this.transition_wtime);
            f /= 2;
        }
        g.drawImage(img2, 0, 0, this);
    }

    private void EffectWipe(Graphics g, Image img1, Image img2, int mode, int STEP) {
        int iw = this.width;
        int ih = this.height;
        Image bbuf = this.createImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        int p = iw / STEP;
        if (mode == 0) {
            int i = 0;
            while (i < iw) {
                bg.drawImage(img1, -i, 0, iw, ih, this);
                bg.drawImage(img2, iw - i, 0, iw, ih, this);
                g.drawImage(bbuf, 0, 0, this);
                this.waitMiliSec(this.transition_wtime);
                i += p;
            }
        } else if (mode == 1) {
            int i = iw;
            while (i > 0) {
                bg.drawImage(img1, iw - i, 0, iw, ih, this);
                bg.drawImage(img2, -i, 0, iw, ih, this);
                g.drawImage(bbuf, 0, 0, this);
                this.waitMiliSec(this.transition_wtime);
                i -= p;
            }
        } else {
            Image bbuf2 = this.createImage(iw, ih);
            Graphics bg2 = bbuf2.getGraphics();
            bg2.drawImage(img1, 0, 0, this);
            int i = 0;
            while (i < iw) {
                bg.drawImage(img2, 0, 0, this);
                bg.drawImage(bbuf2, i, 0, this);
                g.drawImage(bbuf, 0, 0, this);
                bg2.copyArea(p, 0, iw - i, ih, -p, 0);
                this.waitMiliSec(this.transition_wtime);
                i += p;
            }
        }
        g.drawImage(img2, 0, 0, this);
    }

    private void EffectZoomin(Graphics g, Image img1, Image img2, int STEP) {
        int iw = this.width;
        int ih = this.height;
        int i = 0;
        while (i < STEP) {
            int w = iw * i / STEP;
            int h = ih * i / STEP;
            int x = (iw - w) / 2;
            int y = (ih - h) / 2;
            g.drawImage(img2, x, y, w, h, this);
            this.waitMiliSec(this.transition_wtime);
            i += i / 10 + 1;
        }
        g.drawImage(img2, 0, 0, this);
    }

    private void EffectBook(Graphics g, Image img1, Image img2, int mode, int STEP) {
        int iw = this.width;
        int ih = this.height;
        int hw = iw / 2;
        int dx = iw / STEP;
        Image bbuf = this.createImage(iw, ih);
        Graphics bg = bbuf.getGraphics();
        Image left1 = this.createImage(hw, ih);
        Graphics bk = left1.getGraphics();
        bk.drawImage(img1, 0, 0, this);
        Image right1 = this.createImage(hw, ih);
        bk = right1.getGraphics();
        bk.drawImage(img1, -hw, 0, this);
        Image left2 = this.createImage(hw, ih);
        bk = left2.getGraphics();
        bk.drawImage(img2, 0, 0, this);
        Image right2 = this.createImage(hw, ih);
        bk = right2.getGraphics();
        bk.drawImage(img2, -hw, 0, this);
        if (mode == 0) {
            int x = 0;
            while (x < hw) {
                bg.drawImage(left1, 0, 0, this);
                bg.drawImage(right2, hw, 0, this);
                bg.drawImage(right1, hw, 0, hw - x, ih, this);
                g.drawImage(bbuf, 0, 0, this);
                this.waitMiliSec(this.transition_wtime);
                x += dx;
            }
            x = 0;
            while (x < hw) {
                bg.drawImage(left1, 0, 0, this);
                bg.drawImage(right2, hw, 0, this);
                bg.drawImage(left2, hw - x, 0, x, ih, this);
                g.drawImage(bbuf, 0, 0, this);
                this.waitMiliSec(this.transition_wtime);
                x += dx;
            }
        } else {
            int x = hw;
            while (x > 0) {
                bg.drawImage(left2, 0, 0, this);
                bg.drawImage(right1, hw, 0, this);
                bg.drawImage(left1, hw - x, 0, x, ih, this);
                g.drawImage(bbuf, 0, 0, this);
                this.waitMiliSec(this.transition_wtime);
                x -= dx;
            }
            x = hw;
            while (x > 0) {
                bg.drawImage(left2, 0, 0, this);
                bg.drawImage(right1, hw, 0, this);
                bg.drawImage(right2, hw, 0, hw - x, ih, this);
                g.drawImage(bbuf, 0, 0, this);
                this.waitMiliSec(this.transition_wtime);
                x -= dx;
            }
        }
        g.drawImage(img2, 0, 0, this);
    }
}

