/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsImage {
    Vector<int[]> transColors;
    Rectangle posSize;
    String filename;
    BufferedImage image;
    boolean view;
    boolean viewwm;

    public jongsImage() {
        this.resetTransColor();
        this.posSize = new Rectangle();
        this.view = false;
        this.viewwm = true;
    }

    public void setImage(BufferedImage img, ImageObserver io) {
        this.resetTransColor();
        this.posSize.x = 0;
        this.posSize.y = 0;
        this.posSize.width = img.getWidth();
        this.posSize.height = img.getHeight();
        this.image = new BufferedImage(this.posSize.width, this.posSize.height, 6);
        Graphics g = this.image.getGraphics();
        g.drawImage(img, 0, 0, io);
    }

    public void setFileName(String fname) {
        this.filename = fname;
    }

    public void setPoint(int x, int y) {
        this.posSize.x = x;
        this.posSize.y = y;
    }

    public void setPoint(Point p) {
        this.posSize.x = p.x;
        this.posSize.y = p.y;
    }

    public void setSize(int w, int h) {
        this.posSize.width = w;
        this.posSize.height = h;
    }

    public void setView(boolean v) {
        this.view = v;
    }

    public void setViewWithMouse(boolean v) {
        this.viewwm = v;
    }

    public int getX() {
        return this.posSize.x;
    }

    public int getY() {
        return this.posSize.y;
    }

    public int getWidth() {
        return this.posSize.width;
    }

    public int getHeight() {
        return this.posSize.height;
    }

    public boolean getView() {
        return this.view;
    }

    public boolean getViewWithMouse() {
        return this.viewwm;
    }

    public void setTransColor(int tc) {
        if (this.image.getColorModel().getTransparency() == 3) {
            int[] col = new int[]{tc};
            this.transColors.add(col);
            this.setTransImage(tc);
        }
    }

    public void setTransColor(int x, int y, int alpha) {
        int tc = this.image.getRGB(x, y) & 0xFFFFFF;
        this.setTransColor(tc |= alpha << 24);
    }

    public void setTransColor(int color, int alpha) {
        int tc = color & 0xFFFFFF;
        this.setTransColor(tc |= alpha << 24);
    }

    public void setTransColors(Vector<int[]> tcs) {
        int n = 0;
        while (n < tcs.size()) {
            this.transColors.add(tcs.get(n));
            int tc = tcs.get(n)[0];
            this.setTransImage(tc);
            ++n;
        }
    }

    public void resetTransColor() {
        this.transColors = new Vector();
    }

    public void setTransImage(int tc) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int color = tc & 0xFFFFFF;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int col0 = this.image.getRGB(x, y) & 0xFFFFFF;
                if (col0 == color) {
                    this.image.setRGB(x, y, tc);
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean readImage(String filename, ImageObserver iob) {
        try {
            BufferedImage bimg = ImageIO.read(new File("./" + filename));
            this.setImage(bimg, iob);
            this.setFileName(filename);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public boolean checkImageClick(int x, int y) {
        if (!this.view) {
            return false;
        }
        if (!this.posSize.contains(x, y)) {
            System.out.println(String.valueOf(this.filename) + "not contain x:" + x + "y:" + y);
            return false;
        }
        int px = x - this.posSize.x;
        int py = y - this.posSize.y;
        int bx = px * this.posSize.width / this.image.getWidth();
        int by = py * this.posSize.height / this.image.getHeight();
        System.out.println("bx:" + bx + "by:" + by);
        int col0 = this.image.getRGB(bx, by) >> 24;
        System.out.println("bx:" + bx + "by:" + by + "=>col0:" + col0);
        if (col0 == 0) {
            return false;
        }
        System.out.println(String.valueOf(this.filename) + "contain x:" + x + "y:" + y);
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.filename);
        sb.append(" ");
        sb.append(this.posSize.x);
        sb.append(" ");
        sb.append(this.posSize.y);
        sb.append(" ");
        sb.append(this.posSize.width);
        sb.append(" ");
        sb.append(this.posSize.height);
        sb.append(" ");
        if (this.view) {
            sb.append("1 ");
        } else {
            sb.append("0 ");
        }
        if (this.viewwm) {
            sb.append("1 ");
        } else {
            sb.append("0 ");
        }
        int n = 0;
        while (n < this.transColors.size()) {
            int tc = this.transColors.get(n)[0];
            sb.append(Integer.toHexString(tc));
            ++n;
        }
        sb.append("(");
        return sb.toString();
    }
}

