/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsImage {
    private Vector<int[]> transColors;
    private BufferedImage image;
    private Rectangle posSize;
    private String filename;
    boolean view;
    boolean shiftview;
    private String text;
    private Font txtFont;
    private Point txtPos;
    private Color txtColor;

    public jongsImage() {
        this.resetTransColor();
        this.posSize = new Rectangle();
        this.view = false;
        this.shiftview = true;
        this.text = null;
        this.txtFont = null;
        this.txtColor = null;
        this.txtPos = null;
    }

    public void setImage(BufferedImage img, ImageObserver io) {
        this.resetTransColor();
        this.posSize.x = 0;
        this.posSize.y = 0;
        this.posSize.width = img.getWidth();
        this.posSize.height = img.getHeight();
        this.image = new BufferedImage(this.posSize.width, this.posSize.height, 6);
        Graphics g = this.image.getGraphics();
        g.drawImage(img, 0, 0, io);
        this.text = null;
        this.txtFont = null;
        this.txtColor = null;
        this.txtPos = null;
        this.view = false;
        this.shiftview = true;
    }

    public void setCanvas(int w, int h, int color) {
        this.posSize.x = 0;
        this.posSize.y = 0;
        this.posSize.width = w;
        this.posSize.height = h;
        this.image = new BufferedImage(this.posSize.width, this.posSize.height, 6);
        Graphics g = this.image.getGraphics();
        g.setColor(new Color(color));
        g.fillRect(0, 0, w, h);
        this.text = null;
        this.txtFont = null;
        this.txtColor = null;
        this.txtPos = null;
        this.view = false;
        this.shiftview = true;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setFileName(String fname) {
        this.filename = fname;
    }

    public void setPoint(int x, int y) {
        this.posSize.x = x;
        this.posSize.y = y;
    }

    public void setPoint(Point p) {
        this.posSize.x = p.x;
        this.posSize.y = p.y;
    }

    public void setSize(int w, int h) {
        this.posSize.width = w;
        this.posSize.height = h;
    }

    public void setTextParam(String fntname, int style, int size, int fcol) {
        this.txtFont = new Font(fntname, style, size);
        this.txtColor = new Color(fcol);
        this.text = "";
    }

    public void setText(String t) {
        this.text = t;
        Graphics g = this.image.getGraphics();
        g.setFont(this.txtFont);
        FontMetrics fm = g.getFontMetrics(this.txtFont);
        int px = (this.posSize.width - fm.stringWidth(t)) / 2;
        int py = (this.posSize.height + fm.getHeight()) / 2 - fm.getHeight() / 4;
        this.txtPos = new Point(px, py);
    }

    public void drawText(Graphics g) {
        if (this.text == null || this.txtFont == null || this.txtColor == null) {
            return;
        }
        if (this.text.trim().length() == 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int px = this.posSize.x + this.txtPos.x;
        int py = this.posSize.y + this.txtPos.y;
        g2.setFont(this.txtFont);
        g2.setColor(Color.WHITE);
        g2.drawString(this.text, px + 1, py + 1);
        g2.drawString(this.text, px - 1, py + 1);
        g2.drawString(this.text, px + 1, py - 1);
        g2.drawString(this.text, px - 1, py - 1);
        g2.setColor(this.txtColor);
        g2.drawString(this.text, px, py);
    }

    public void setView(boolean v) {
        this.view = v;
    }

    public void setShiftView(boolean v) {
        this.shiftview = v;
    }

    public int getX() {
        return this.posSize.x;
    }

    public int getY() {
        return this.posSize.y;
    }

    public int getWidth() {
        return this.posSize.width;
    }

    public int getHeight() {
        return this.posSize.height;
    }

    public boolean getView() {
        return this.view;
    }

    public boolean getShiftView() {
        return this.shiftview;
    }

    public void setTransColor(int tc) {
        if (this.image.getColorModel().getTransparency() == 3) {
            int[] col = new int[]{tc};
            this.transColors.add(col);
            this.setTransImage(tc);
        }
    }

    public void setTransColor(int x, int y, int alpha) {
        int tc = this.image.getRGB(x, y) & 0xFFFFFF;
        this.setTransColor(tc |= alpha << 24);
    }

    public void setTransColor(int color, int alpha) {
        int tc = color & 0xFFFFFF;
        this.setTransColor(tc |= alpha << 24);
    }

    public void setTransColors(Vector<int[]> tcs) {
        int n = 0;
        while (n < tcs.size()) {
            this.transColors.add(tcs.get(n));
            int tc = tcs.get(n)[0];
            this.setTransImage(tc);
            ++n;
        }
    }

    public void resetTransColor() {
        this.transColors = new Vector();
    }

    public void setTransImage(int tc) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int color = tc & 0xFFFFFF;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int col0 = this.image.getRGB(x, y) & 0xFFFFFF;
                if (col0 == color) {
                    this.image.setRGB(x, y, tc);
                }
                ++x;
            }
            ++y;
        }
    }

    public boolean checkImageClick(int x, int y) {
        if (!this.view) {
            return false;
        }
        if (!this.posSize.contains(x, y)) {
            return false;
        }
        int px = x - this.posSize.x;
        int py = y - this.posSize.y;
        int bx = this.posSize.width != this.image.getWidth() ? px * this.image.getWidth() / this.posSize.width : px;
        int by = this.posSize.height != this.image.getHeight() ? py * this.image.getHeight() / this.posSize.height : py;
        if (bx < 0 || bx >= this.image.getWidth()) {
            return false;
        }
        if (by < 0 || by >= this.image.getHeight()) {
            return false;
        }
        int col0 = this.image.getRGB(bx, by) >> 24;
        return col0 != 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(this.filename);
        sb.append(" ");
        sb.append(this.posSize.x);
        sb.append(" ");
        sb.append(this.posSize.y);
        sb.append(" ");
        sb.append(this.posSize.width);
        sb.append(" ");
        sb.append(this.posSize.height);
        sb.append(" ");
        if (this.view) {
            sb.append("1 ");
        } else {
            sb.append("0 ");
        }
        if (this.shiftview) {
            sb.append("1 ");
        } else {
            sb.append("0 ");
        }
        int n = 0;
        while (n < this.transColors.size()) {
            int tc = this.transColors.get(n)[0];
            sb.append(Integer.toHexString(tc));
            ++n;
        }
        sb.append("(");
        return sb.toString();
    }
}

