/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class jongsSound
implements MetaEventListener,
LineListener {
    private static final int MIDI_END = 47;
    private static final int MIDI_MAX = 128;
    private static final int AUDIO_MAX = 128;
    private static final int CLIP_MAX = 128;
    Sequencer MIDIsequencer;
    Synthesizer MIDIsynthesizer;
    Sequence MIDIsequence;
    HashMap<String, Sequence> MIDIFiles;
    HashMap<String, Clip> CLIPFiles;
    HashMap<String, AudioClip> AUDIOFiles;

    public jongsSound() {
        this.initSequencer();
        this.MIDIFiles = new HashMap(128);
        this.AUDIOFiles = new HashMap(128);
        this.CLIPFiles = new HashMap(128);
    }

    private int initSequencer() {
        try {
            this.MIDIsequencer = MidiSystem.getSequencer();
            this.MIDIsequencer.open();
            this.MIDIsequencer.addMetaEventListener(this);
            if (!(this.MIDIsequencer instanceof Synthesizer)) {
                this.MIDIsynthesizer = MidiSystem.getSynthesizer();
                this.MIDIsynthesizer.open();
                Receiver synthReceiver = this.MIDIsynthesizer.getReceiver();
                Transmitter seqTransmitter = this.MIDIsequencer.getTransmitter();
                seqTransmitter.setReceiver(synthReceiver);
            } else {
                this.MIDIsynthesizer = (Synthesizer)((Object)this.MIDIsequencer);
            }
        }
        catch (MidiUnavailableException mue) {
            return 8;
        }
        return 0;
    }

    public void meta(MetaMessage mm) {
        if (mm.getType() == 47 && this.MIDIsequencer != null && this.MIDIsequencer.isOpen()) {
            this.MIDIsequencer.setMicrosecondPosition(0L);
            this.MIDIsequencer.start();
        }
    }

    public int MIDIload(String filename) {
        if (this.MIDIFiles.size() >= 128) {
            return 8;
        }
        if (this.MIDIFiles.containsKey(filename)) {
            this.MIDIsequence = this.MIDIFiles.get(filename);
            this.MIDIstop();
            return 0;
        }
        File MidiFile = new File("./" + filename);
        try {
            this.MIDIsequence = MidiSystem.getSequence(MidiFile);
        }
        catch (InvalidMidiDataException e) {
            return 1;
        }
        catch (IOException e) {
            return 2;
        }
        catch (NullPointerException e) {
            return 3;
        }
        this.MIDIstop();
        return 0;
    }

    public int CLIPload(String filename) {
        if (this.CLIPFiles.size() >= 128) {
            return 8;
        }
        if (this.CLIPFiles.containsKey(filename)) {
            return 0;
        }
        Clip clip = this.getClip(filename);
        if (clip == null) {
            return 8;
        }
        return 0;
    }

    public int CLIPLoop(String filename) {
        if (this.CLIPFiles.containsKey(filename)) {
            Clip clip = this.CLIPFiles.get(filename);
            clip.start();
            return 0;
        }
        if (this.CLIPFiles.size() >= 128) {
            return 8;
        }
        Clip clip = this.getClip(filename);
        if (clip == null) {
            return 8;
        }
        clip.start();
        return 0;
    }

    private Clip getClip(String filename) {
        Clip clip;
        File audioFile = new File("./" + filename);
        try {
            AudioInputStream aistr = AudioSystem.getAudioInputStream(audioFile.toURI().toURL());
            AudioFormat aform = aistr.getFormat();
            if (aform.getEncoding() == AudioFormat.Encoding.ULAW || aform.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat newform = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, aform.getSampleRate(), aform.getSampleSizeInBits() * 2, aform.getChannels(), aform.getFrameSize() * 2, aform.getFrameRate(), true);
                aistr = AudioSystem.getAudioInputStream(newform, aistr);
                aform = newform;
            }
            DataLine.Info dlinfo = new DataLine.Info(Clip.class, aform);
            clip = (Clip)AudioSystem.getLine(dlinfo);
            clip.addLineListener(this);
            clip.open(aistr);
            aistr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
            return null;
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return null;
        }
        this.CLIPFiles.put(filename, clip);
        return clip;
    }

    public void CLIPStop(String filename) {
        if (this.CLIPFiles.containsKey(filename)) {
            Clip clip = this.CLIPFiles.get(filename);
            clip.stop();
        }
    }

    public int MIDIplay(String filename) {
        int retc = this.MIDIload(filename);
        if (retc == 0) {
            this.Midiplay();
            return 0;
        }
        return 8;
    }

    public int Midiplay() {
        if (this.MIDIsequence == null) {
            return 8;
        }
        return this.MIDIplay(this.MIDIsequence);
    }

    public int MIDIplay(Sequence seq) {
        this.MIDIstop();
        if (this.MIDIsequencer != null && seq != null) {
            try {
                this.MIDIsequencer.setSequence(seq);
                this.MIDIsequencer.start();
            }
            catch (InvalidMidiDataException imd) {
                return 8;
            }
            return 0;
        }
        return 8;
    }

    public void MIDIstop() {
        if (this.MIDIsequencer == null) {
            return;
        }
        if (this.MIDIsequencer.isRunning()) {
            this.MIDIsequencer.stop();
        }
    }

    public void MIDIclose() {
        this.MIDIstop();
        if (this.MIDIsequencer != null) {
            this.MIDIsequencer.removeMetaEventListener(this);
            this.MIDIsequencer.close();
        }
        this.MIDIsequencer = null;
    }

    public void update(LineEvent le) {
        if (le.getType() == LineEvent.Type.STOP) {
            Clip clip = (Clip)le.getSource();
            clip.stop();
            clip.setFramePosition(0);
        }
    }

    public int AUDIOload(String filename) {
        if (this.AUDIOFiles.size() >= 128) {
            return 8;
        }
        if (this.AUDIOFiles.containsKey(filename)) {
            return 0;
        }
        AudioClip clip = this.getAudioClip(filename);
        if (clip == null) {
            return 8;
        }
        return 0;
    }

    public int AUDIOPlay(String filename) {
        if (this.AUDIOFiles.containsKey(filename)) {
            AudioClip clip = this.AUDIOFiles.get(filename);
            clip.play();
            return 0;
        }
        if (this.AUDIOFiles.size() >= 128) {
            return 8;
        }
        AudioClip clip = this.getAudioClip(filename);
        if (clip == null) {
            return 8;
        }
        clip.play();
        return 0;
    }

    public int AUDIOLoop(String filename) {
        if (this.AUDIOFiles.containsKey(filename)) {
            AudioClip clip = this.AUDIOFiles.get(filename);
            clip.loop();
            return 0;
        }
        AudioClip clip = this.getAudioClip(filename);
        if (clip == null) {
            return 8;
        }
        clip.loop();
        return 0;
    }

    private AudioClip getAudioClip(String filename) {
        AudioClip clip;
        File audioFile = new File("./" + filename);
        try {
            clip = Applet.newAudioClip(audioFile.toURI().toURL());
        }
        catch (NullPointerException ne) {
            return null;
        }
        catch (MalformedURLException mue) {
            return null;
        }
        this.AUDIOFiles.put(filename, clip);
        return clip;
    }

    public void AUDIOStop(String filename) {
        if (this.AUDIOFiles.containsKey(filename)) {
            AudioClip clip = this.AUDIOFiles.get(filename);
            clip.stop();
        }
    }
}

