/*
 * Decompiled with CFR 0.152.
 */
package jongs;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import jongs.jongsDisplay;
import jongs.jongsImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jongsDisplayManagement {
    public static final int POS_UPPER = Integer.MAX_VALUE;
    public static final int POS_LOWER = 0x7FFFFFFE;
    public static final int POS_MIDDLE = 0x7FFFFFFD;
    public static final int POS_LEFT = 0x7FFFFFFC;
    public static final int POS_RIGHT = 0x7FFFFFFB;
    public static final int POS_CENTER = 0x7FFFFFFA;
    HashMap<String, int[]> positionMap;
    jongsImage[] cellImages;
    BufferedImage disp_buf00 = null;
    Graphics gdb00;
    BufferedImage disp_buf02 = null;
    Graphics gdb02;
    Frame dispFrame;
    jongsDisplay disp;
    Thread dispThread;
    String Text;
    Rectangle selectArea00;
    int[] selectColor00;
    Font selectFont00;
    Rectangle[] selectBtnArea;
    BufferedImage[][] selectBtnImage;

    public jongsDisplayManagement() {
        this.initJDM(800, 600);
    }

    public jongsDisplayManagement(int n, int n2) {
        this.initJDM(n, n2);
    }

    private void initJDM(int n, int n2) {
        this.initPositionCode();
        this.createDisplay(n, n2);
        this.setSelectArea(n / 10, n2 / 2, n * 8 / 10, n2 / 5, 3, 2, 10, 0);
        this.setSelectColor(0xFFFFFF, 0xAAAAFF, 0xFFFFCC, 68);
        this.setSelectFont("Dialog", "bold", 14);
    }

    private void initPositionCode() {
        this.positionMap = new HashMap();
        this.positionMap.put("_upper", this.getIntArray(Integer.MAX_VALUE));
        this.positionMap.put("_lower", this.getIntArray(0x7FFFFFFE));
        this.positionMap.put("_top", this.getIntArray(Integer.MAX_VALUE));
        this.positionMap.put("_bottom", this.getIntArray(0x7FFFFFFE));
        this.positionMap.put("_middle", this.getIntArray(0x7FFFFFFD));
        this.positionMap.put("_left", this.getIntArray(0x7FFFFFFC));
        this.positionMap.put("_right", this.getIntArray(0x7FFFFFFB));
        this.positionMap.put("_center", this.getIntArray(0x7FFFFFFA));
    }

    public int[] getIntArray(int n) {
        int[] nArray = new int[]{n};
        return nArray;
    }

    public void waitMiliSec(int n) {
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = n;
        while (l2 < System.currentTimeMillis() - l) {
        }
    }

    public BufferedImage loadImage(String string, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(new File("./" + string));
        }
        catch (IOException iOException) {
            return null;
        }
        return bufferedImage;
    }

    public int checkCellClick(int n, int n2) {
        for (int i = this.cellImages.length - 1; i >= 0; --i) {
            if (this.cellImages[i] == null || !this.cellImages[i].checkImageClick(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean diaplayBusy() {
        boolean bl = this.disp.commandCode != 0 || this.disp.busy;
        return bl;
    }

    public int visibleCellNum() {
        int n = 0;
        for (int i = 0; i < this.cellImages.length; ++i) {
            if (this.cellImages[i] == null || !this.cellImages[i].view) continue;
            ++n;
        }
        return n;
    }

    public void createDisplay(int n, int n2) {
        this.dispFrame = new Frame();
        this.dispFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.dispFrame.setSize(n + 6, n2 + 20);
        this.disp = new jongsDisplay(n, n2);
        this.dispFrame.add(this.disp);
        this.dispThread = new Thread(this.disp);
        this.dispFrame.setVisible(true);
        this.disp_buf00 = new BufferedImage(n, n2, 4);
        this.gdb00 = this.disp_buf00.getGraphics();
        this.disp_buf02 = new BufferedImage(n, n2, 4);
        this.gdb02 = this.disp_buf02.getGraphics();
        this.dispThread.start();
    }

    public void dispose() {
        this.dispFrame.dispose();
    }

    public void drawImageBuf() {
        Graphics graphics = this.gdb00;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.disp_buf00.getWidth(), this.disp_buf00.getHeight());
        for (int i = 0; i < this.cellImages.length; ++i) {
            if (this.cellImages[i] == null || !this.cellImages[i].view) continue;
            jongsImage jongsImage2 = this.cellImages[i];
            graphics.drawImage(jongsImage2.getImage(), jongsImage2.getX(), jongsImage2.getY(), jongsImage2.getWidth(), jongsImage2.getHeight(), this.disp);
            jongsImage2.drawText(graphics);
        }
    }

    public void drawShiftImageBuf() {
        Graphics graphics = this.gdb02;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.disp_buf02.getWidth(), this.disp_buf02.getHeight());
        for (int i = 0; i < this.cellImages.length; ++i) {
            if (this.cellImages[i] == null || !this.cellImages[i].view || !this.cellImages[i].shiftview) continue;
            jongsImage jongsImage2 = this.cellImages[i];
            graphics.drawImage(jongsImage2.getImage(), jongsImage2.getX(), jongsImage2.getY(), jongsImage2.getWidth(), jongsImage2.getHeight(), this.disp);
            jongsImage2.drawText(graphics);
        }
    }

    public void setShiftView(int n) {
        if (this.cellImages[n] != null) {
            this.cellImages[n].shiftview = true;
        }
    }

    public void setShiftHide(int n) {
        if (this.cellImages[n] != null) {
            this.cellImages[n].shiftview = false;
        }
    }

    public int getPositionCode(String string) {
        String string2 = string.trim().toLowerCase();
        if (this.positionMap.containsKey(string2)) {
            return this.positionMap.get(string2)[0];
        }
        return 0;
    }

    public Point changePosition(int n, int n2, int n3) {
        switch (n2) {
            case 0x7FFFFFFC: {
                n2 = 0;
                break;
            }
            case 0x7FFFFFFB: {
                int n4 = this.cellImages[n].getWidth();
                n2 = this.disp.width - n4;
                break;
            }
            case 0x7FFFFFFA: {
                int n5 = this.cellImages[n].getWidth();
                n2 = (this.disp.width - n5) / 2;
            }
        }
        switch (n3) {
            case 0x7FFFFFFF: {
                n3 = 0;
                break;
            }
            case 0x7FFFFFFE: {
                int n6 = this.cellImages[n].getHeight();
                n3 = this.disp.height - n6;
                break;
            }
            case 0x7FFFFFFD: {
                int n7 = this.cellImages[n].getHeight();
                n3 = (this.disp.height - n7) / 2;
            }
        }
        Point point = new Point(n2, n3);
        return point;
    }

    public void viewDisplay() {
        this.drawImageBuf();
        this.drawShiftImageBuf();
        this.disp.viewDisplay(this.disp_buf00, this.disp_buf02);
    }

    public void viewDisplay(String string) {
        this.setCellView(string);
        this.drawImageBuf();
        this.drawShiftImageBuf();
        this.disp.viewDisplay(this.disp_buf00, this.disp_buf02);
    }

    public void setDisplaySize(int n, int n2) {
        this.createDisplay(n, n2);
    }

    public void transitionDisplay(String string) {
        this.drawImageBuf();
        this.drawShiftImageBuf();
        this.disp.transitionDisplay(this.disp_buf00, this.disp_buf02, string);
    }

    public void transitionDisplay(String string, String string2) {
        this.setCellView(string);
        this.drawImageBuf();
        this.drawShiftImageBuf();
        this.disp.transitionDisplay(this.disp_buf00, this.disp_buf02, string2);
    }

    public int getTransitionCode(String string) {
        return this.disp.getTransitionCode(string);
    }

    public void setCellNumber(int n) {
        this.cellImages = new jongsImage[n];
    }

    public boolean setCellImage(int n, String string) {
        BufferedImage bufferedImage;
        if (this.cellImages[n] == null) {
            this.cellImages[n] = new jongsImage();
            this.cellImages[n].setPoint(0, 0);
        }
        if ((bufferedImage = this.loadImage(string, this.disp)) == null) {
            return false;
        }
        this.cellImages[n].setImage(bufferedImage, this.disp);
        this.cellImages[n].setFileName(string);
        return true;
    }

    public void setTransColor(int n, int n2) {
        if (this.cellImages[n] != null) {
            this.cellImages[n].setTransColor(n2);
        }
    }

    public void setTransColor(int n, int n2, int n3) {
        if (this.cellImages[n] != null) {
            int n4 = n3 << 24 | n2 & 0xFFFFFF;
            this.cellImages[n].setTransColor(n4);
        }
    }

    public void setTransColor(int n, int n2, int n3, int n4) {
        if (this.cellImages[n] != null) {
            this.cellImages[n].setTransColor(n2, n3, n4);
        }
    }

    public void setCellPosition(int n, int n2, int n3) {
        if (this.cellImages[n] != null) {
            Point point = this.changePosition(n, n2, n3);
            this.cellImages[n].setPoint(point);
        }
    }

    public void setCellSize(int n, int n2, int n3) {
        if (this.cellImages[n] != null) {
            this.cellImages[n].setSize(n2, n3);
        }
    }

    public void setCellCanvas(int n, int n2, int n3, int n4) {
        if (this.cellImages[n] == null) {
            this.cellImages[n] = new jongsImage();
            this.cellImages[n].setPoint(0, 0);
        }
        this.cellImages[n] = new jongsImage();
        this.cellImages[n].setCanvas(n2, n3, n4);
    }

    public void setCellTextParameter(int n, String string, String string2, int n2, int n3) {
        if (this.cellImages[n] != null) {
            int n4 = string2.length() == 0 ? 0 : (string2.equals("plain") ? 0 : (string2.equals("italic") ? 2 : (string2.equals("bold") ? 1 : 0)));
            this.cellImages[n].setTextParam(string, n4, n2, n3);
        }
    }

    public void setCellText(int n, String string) {
        if (this.cellImages[n] != null) {
            this.cellImages[n].setText(string);
        }
    }

    public void setCellView(String string) {
        for (int i = 0; i < string.length() && i < this.cellImages.length; ++i) {
            char c = string.charAt(i);
            if (this.cellImages[i] == null) continue;
            if (c == '0') {
                this.cellImages[i].setView(false);
                continue;
            }
            if (c != '1') continue;
            this.cellImages[i].setView(true);
        }
    }

    public void setCellView(int n) {
        int n2 = n;
        for (int i = 0; i < 32 && i < this.cellImages.length; ++i) {
            int n3 = n2 & 1;
            if (this.cellImages[i] != null) {
                if (n3 == 0) {
                    this.cellImages[i].setView(false);
                } else if (n3 == 1) {
                    this.cellImages[i].setView(true);
                }
            }
            n2 >>= 1;
        }
    }

    public void setCellView(int n, int n2) {
        if (n < this.cellImages.length && this.cellImages[n] != null) {
            if (n2 == 0) {
                this.cellImages[n].setView(false);
            } else if (n2 == 1) {
                this.cellImages[n].setView(true);
            }
        }
    }

    public void setCellView(int n, String string) {
        if (n < this.cellImages.length && this.cellImages[n] != null) {
            if (string.trim().toLowerCase().equals("false")) {
                this.cellImages[n].setView(false);
            } else if (string.trim().toLowerCase().equals("true")) {
                this.cellImages[n].setView(true);
            }
        }
    }

    public void setFontColor(int n, int n2) {
        this.disp.setFontColor(n, n2);
    }

    public void setTextFont(String string, String string2, int n) {
        String string3 = string.trim();
        String string4 = string2.trim().toLowerCase();
        int n2 = 0;
        int n3 = n;
        if (string3.length() == 0) {
            string3 = this.disp.textFont.getFontName();
        }
        n2 = string4.length() == 0 ? this.disp.textFont.getStyle() : (string4.equals("plain") ? 0 : (string4.equals("italic") ? 2 : (string4.equals("bold") ? 1 : 0)));
        if (n3 == 0) {
            n3 = this.disp.textFont.getSize();
        }
        this.disp.setTextFont(new Font(string3, n2, n3));
    }

    public void setTextArea(int n, int n2, int n3, int n4) {
        this.disp.setTextArea(n, n2, n3, n4);
    }

    public void setTextInterval(int n, int n2) {
        this.disp.setTextInterval(n, n2);
    }

    public void drawText(String string) {
        this.disp.drawText(string);
    }

    public void drawWaitText(String string, int n) {
        this.disp.drawWaitText(string, n);
    }

    public void calcSelectButton(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = n * n2;
        int n6 = (rectangle.width - n3 * (n - 1)) / n;
        int n7 = (rectangle.height - n4 * (n2 - 1)) / n2;
        if (n6 < 0) {
            n6 = rectangle.width / n;
            n3 = 0;
        }
        if (n7 < 0) {
            n7 = rectangle.height / n2;
            n4 = 0;
        }
        this.selectBtnArea = new Rectangle[n5];
        int n8 = 0;
        int n9 = rectangle.y;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = rectangle.x;
            int n12 = 0;
            while (n12 < n) {
                this.selectBtnArea[n8] = new Rectangle(n11, n9, n6, n7);
                ++n8;
                ++n12;
                n11 += n6 + n3;
            }
            ++n10;
            n9 += n7 + n4;
        }
        this.disp.setSelectButton(this.selectBtnArea);
    }

    public void setSelectParam(Vector<String> vector) {
        int n = vector.size();
        this.disp.setSelectArea(this.selectArea00);
        this.disp.setSelectColor(this.selectColor00);
        this.disp.setSelectText(vector, 0, n);
        this.disp.setSelectFont(this.selectFont00);
        if (this.disp.selectbtn.length < n) {
            if (this.selectArea00.width > this.selectArea00.height) {
                this.calcSelectButton(this.selectArea00, n, 1, 0, 0);
            } else {
                this.calcSelectButton(this.selectArea00, 1, n, 0, 0);
            }
        }
        this.createBtnImages(vector);
        this.disp.setSelectBtnImage(this.selectBtnImage);
        this.disp.selectClick();
    }

    public BufferedImage createTransButton(int n, int n2, int n3, boolean bl, String string, int n4, Font font) {
        int n5 = 0xFF000000 & n3;
        int n6 = 0xFFFFFF & n3;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 6);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(n6));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.draw3DRect(1, 1, n - 2, n2 - 2, bl);
        graphics2D.draw3DRect(2, 2, n - 4, n2 - 4, bl);
        if (n5 != 0 && n5 != -16777216) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n7 = bufferedImage.getRGB(j, i) & 0xFFFFFF | n5;
                    bufferedImage.setRGB(j, i, n7);
                }
            }
        }
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n8 = fontMetrics.getHeight();
        int n9 = n8 + (n2 - n8) / 2;
        int n10 = fontMetrics.stringWidth(string);
        int n11 = (n - n10) / 2;
        graphics2D.setColor(new Color(n4));
        graphics2D.drawString(string, n11, n9);
        return bufferedImage;
    }

    public void createBtnImages(Vector<String> vector) {
        int n = vector.size();
        if (n > this.selectBtnArea.length) {
            n = this.selectBtnArea.length;
        }
        this.selectBtnImage = new BufferedImage[n][3];
        for (int i = 0; i < n; ++i) {
            int n2 = this.selectBtnArea[i].x;
            int n3 = this.selectBtnArea[i].y;
            int n4 = this.selectBtnArea[i].width;
            int n5 = this.selectBtnArea[i].height;
            this.selectBtnImage[i][0] = new BufferedImage(n4, n5, 6);
            this.selectBtnImage[i][1] = new BufferedImage(n4, n5, 6);
            this.selectBtnImage[i][2] = new BufferedImage(n4, n5, 6);
            Graphics graphics = this.selectBtnImage[i][0].getGraphics();
            graphics.drawImage(this.disp_buf00, -n2, -n3, this.disp);
            BufferedImage bufferedImage = this.createTransButton(n4, n5, this.selectColor00[0], true, vector.get(i), this.selectColor00[3], this.selectFont00);
            graphics.drawImage(bufferedImage, 0, 0, this.disp);
            graphics = this.selectBtnImage[i][1].getGraphics();
            graphics.drawImage(this.disp_buf00, -n2, -n3, this.disp);
            bufferedImage = this.createTransButton(n4, n5, this.selectColor00[1], true, vector.get(i), this.selectColor00[3], this.selectFont00);
            graphics.drawImage(bufferedImage, 0, 0, this.disp);
            graphics = this.selectBtnImage[i][2].getGraphics();
            graphics.drawImage(this.disp_buf00, -n2, -n3, this.disp);
            bufferedImage = this.createTransButton(n4, n5, this.selectColor00[2], false, vector.get(i), this.selectColor00[3], this.selectFont00);
            graphics.drawImage(bufferedImage, 0, 0, this.disp);
        }
    }

    public void setSelectArea(int n, int n2, int n3, int n4) {
        this.selectArea00 = new Rectangle(n, n2, n3, n4);
        this.disp.setSelectArea(this.selectArea00);
        this.calcSelectButton(this.selectArea00, 1, 1, 0, 0);
    }

    public void setSelectArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.selectArea00 = new Rectangle(n, n2, n3, n4);
        this.disp.setSelectArea(this.selectArea00);
        this.calcSelectButton(this.selectArea00, n5, n6, 0, 0);
    }

    public void setSelectArea(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.selectArea00 = new Rectangle(n, n2, n3, n4);
        this.disp.setSelectArea(this.selectArea00);
        this.calcSelectButton(this.selectArea00, n5, n6, n7, n8);
    }

    public void setSelectColor(int n, int n2, int n3, int n4) {
        this.selectColor00 = new int[4];
        this.selectColor00[0] = n;
        this.selectColor00[1] = n2;
        this.selectColor00[2] = n3;
        this.selectColor00[3] = n4;
        this.disp.setSelectColor(this.selectColor00);
    }

    public void setSelectFont(String string, String string2, int n) {
        String string3 = string.trim();
        String string4 = string2.trim().toLowerCase();
        int n2 = 0;
        int n3 = n;
        if (string3.length() == 0) {
            string3 = this.selectFont00.getFontName();
        }
        n2 = string4.length() == 0 ? this.disp.textFont.getStyle() : (string4.equals("plain") ? 0 : (string4.equals("italic") ? 2 : (string4.equals("bold") ? 1 : 0)));
        if (n3 == 0) {
            n3 = 10;
        }
        this.selectFont00 = new Font(string3, n2, n3);
    }

    public int getSelectButton() {
        return this.disp.selectButton;
    }

    public String getSelectText() {
        return this.disp.selectText;
    }

    public void cellClick() {
        this.disp.cellClick();
    }

    public int getSelectCell() {
        int n;
        int n2 = this.checkCellClick(this.disp.releasex, this.disp.releasey);
        if (n2 != (n = this.checkCellClick(this.disp.pressx, this.disp.pressy))) {
            this.disp.cellClick();
            n2 = -1;
        }
        return n2;
    }
}

