package jongs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector ;
import java.util.HashMap ;
import java.io.File ;
import java.io.IOException;

import javax.imageio.ImageIO;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

import java.awt.RenderingHints;
import java.awt.FontMetrics;
import java.awt.Graphics2D;


// 
// JONGS - Java Open Novels Game Script
// 
//    JongsDisplayManagement.java 
//
//  Copyright 2007  DENZI TOMIZKA
//
//  ver 1.00 Create by DENZI TOMIZKA 2007.5.25
//  ver 1.01           DENZI TOMIZKA 2007.5.28
//  ver 1.02           DENZI TOMIZKA 2007.5.31
//  ver 1.03           DENZI TOMIZKA 2007.6.07
//  ver 1.04           DENZI TOMIZKA 2007.6.13
//  ver 1.05           DENZI TOMIZKA 2007.6.14
//
/*
 *-----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *----------------------------------------------------------------------
 */


public class jongsDisplayManagement {

	//Zʒu̒萔
	public final static int POS_UPPER      =0x7fffffff ;
	public final static int POS_LOWER      =0x7ffffffe ;
	public final static int POS_MIDDLE     =0x7ffffffd ;
	public final static int POS_LEFT       =0x7ffffffc ;
	public final static int POS_RIGHT      =0x7ffffffb ;
	public final static int POS_CENTER     =0x7ffffffa ;

	//摜Zn
	HashMap <String , int[]> positionMap ;
	jongsImage [] cellImages ;
	//ʃobt@
	BufferedImage disp_buf00 = null ; //Pʃobt@
	Graphics   gdb00  ;	
	//ʃobt@
	BufferedImage disp_buf02 = null ; //Shiftʃobt@
	Graphics   gdb02  ;	
	
	//Display{
	Frame dispFrame ;
	jongsDisplay disp ;
	Thread dispThread;
	
	//
	String Text;
	
	//Inp[^
	Rectangle selectArea00 ;
	int [] selectColor00 ;
	Font selectFont00;
	Rectangle[] selectBtnArea ;
	//VolatileImage [][] selectBtnImage ;
	BufferedImage [][] selectBtnImage ;

	
	public jongsDisplayManagement() {
		initJDM(800 , 600);
	}

	public jongsDisplayManagement(int w , int h) {
		initJDM(w , h);
	}
	
	private void initJDM( int w , int h ) {
		initPositionCode();
		createDisplay(w , h);
		
		//I{^̃fBtHgp[^
		this.setSelectArea(w/10 , h/2 , (w * 8) / 10 , h / 5 , 3 , 2 , 10 , 0 );
		this.setSelectColor( 0xffffff , 0xaaaaff , 0xffffcc , 0x000044 );
		this.setSelectFont("Dialog","bold",14);
	
	}
	
	/**
	 *^E{n\̓o^ 
	 */
	private void initPositionCode() {		
		// ʒu萔\̓o^
		positionMap = new HashMap <String , int[] >();
		positionMap.put("_upper", this.getIntArray(POS_UPPER) ); 
		positionMap.put("_lower", this.getIntArray(POS_LOWER) ); 
		positionMap.put("_top", this.getIntArray(POS_UPPER) ); 
		positionMap.put("_bottom", this.getIntArray(POS_LOWER) ); 
		positionMap.put("_middle", this.getIntArray(POS_MIDDLE) ); 
		positionMap.put("_left", this.getIntArray(POS_LEFT) ); 
		positionMap.put("_right", this.getIntArray(POS_RIGHT) ); 
		positionMap.put("_center", this.getIntArray(POS_CENTER) ); 
	}

	public int[] getIntArray(int i ){
		int [] a = new int[1];
		a[0] = i;
		return a ;
	}

	public void waitMiliSec(int w) {
		if (w == 0 ) return ;
		long start = System.currentTimeMillis();
		long wtime = w;
		while ( wtime < (System.currentTimeMillis() - start) ) ;	
	}	
	
	
	/**
	 * 摜ǂݍ
	 * @param filename
	 * @return
	 */
	public BufferedImage loadImage(String filename,ImageObserver iob) {
		BufferedImage bimg ;
		try {
		    bimg = ImageIO.read(new File("./"+filename));		    
		} catch (IOException ioe) {
		    return null ;
		}
		return bimg ;
	}
	
	
	/**
	 * Ww肵AZNbNĂȂ΃ZԍԂ
	 * @param zx
	 * @param zy
	 * @return YZȂ -1
	 */
	public int checkCellClick(int zx , int zy ) {
		//ɍڂĂZ`FbN
		for (int n = (this.cellImages.length-1) ; n >= 0  ; n--  ) {
			if ( this.cellImages[n] != null ) {
				if ( this.cellImages[n].checkImageClick(zx, zy) == true) 
					return n ;
			}
		}
		return -1 ;
	}


	
	public boolean diaplayBusy() {
		boolean busy = ( disp.commandCode != 0 || disp.busy == true);
		return busy;
	}
	
	/**
	 * Ԃ̃Z𐔂
	 * @return
	 */
	public int visibleCellNum() {
		int n , v ;
		for ( n = v = 0 ; n < this.cellImages.length ; n++) {
			if ( cellImages[n] != null )
				if ( cellImages[n].view == true ) v++;
		}
		return v;
	}
	
	
	
	/*****************************************************************/
	/*****************************************************************/
	/*****ʌn̏*************************************************/
	/*****************************************************************/
	/*****************************************************************/
	/**
	 * ʂďo
	 * @param w
	 * @param h
	 */
	public void createDisplay(int w , int h) {
		this.dispFrame = new Frame();
		//WindowI
		this.dispFrame.addWindowListener(new WindowAdapter(){
            public void windowClosing(WindowEvent e){
            	System.exit(0);
            }
        });
		this.dispFrame.setSize(w+6, h+20);
		this.disp = new jongsDisplay(w , h);
		this.dispFrame.add(disp);
		this.dispThread = new Thread(disp);
		
		//this.dispFrame.setUndecorated(true);
		this.dispFrame.setVisible(true);
		
		//ꎟʃobt@쐬
        disp_buf00 = new BufferedImage(w, h, BufferedImage.TYPE_INT_BGR);
        gdb00 = disp_buf00.getGraphics();
        disp_buf02 = new BufferedImage(w, h, BufferedImage.TYPE_INT_BGR);
        gdb02 = disp_buf02.getGraphics();
        this.dispThread.start();
	}
	
	/**
	 * ʂj
	 *
	 */
	public void dispose() {
		this.dispFrame.dispose();
	}
	
	
	/**
	 * ꎟʃobt@`悷
	 */
	public void drawImageBuf() {
		int n ;
		Graphics dbg = this.gdb00;
		jongsImage ji ;
		dbg.setColor(Color.black);
		dbg.fillRect(0, 0, disp_buf00.getWidth(), disp_buf00.getHeight());
		for ( n = 0 ; n < this.cellImages.length ; n++ ) {
			if ( this.cellImages[n] != null && this.cellImages[n].view ) {
				ji = this.cellImages[n];
				dbg.drawImage(ji.getImage(), ji.getX(), ji.getY(), ji.getWidth(), ji.getHeight(), disp);
				ji.drawText(dbg);
			}
		}
	}

	/**
	 * Shiftʃobt@`悷
	 */
	public void drawShiftImageBuf() {
		int n ;
		Graphics dbg = this.gdb02;
		jongsImage ji ;
		dbg.setColor(Color.black);
		dbg.fillRect(0, 0, disp_buf02.getWidth(), disp_buf02.getHeight());
		for ( n = 0 ; n < this.cellImages.length ; n++ ) {
			if ( this.cellImages[n] != null && this.cellImages[n].view && this.cellImages[n].shiftview) {
				ji = this.cellImages[n];
				dbg.drawImage(ji.getImage(), ji.getX(), ji.getY(), ji.getWidth(), ji.getHeight(), disp);
				ji.drawText(dbg);
			} 
		}
	}

	/**
	 * w肳ꂽZSHIFTŕ\ݒɂ
	 * @param cell
	 */
	public void setShiftView(int cell) {
		if (  this.cellImages[cell] != null  ) {
			this.cellImages[cell].shiftview = true ;
		}
	}
	
	/**
	 * w肳ꂽZSHIFTŏݒɂ
	 * @param cell
	 */
	public void setShiftHide(int cell) {
		if (  this.cellImages[cell] != null  ) {
			this.cellImages[cell].shiftview = false ;
			//System.out.println("setShiftHide:hide_cell="+cell+":"+this.cellImages[cell].shiftview);
		}
	}
	
	/**
	 * ʒuR[h}bvʒuR[h𓾂
	 * @param tr
	 * @return
	 */
	public int getPositionCode(String tr) {
		String tstr = tr.trim().toLowerCase();
		if ( positionMap.containsKey(tstr) ) {
			return positionMap.get(tstr)[0];
		}
		return 0 ;
	}

	
	/**
	 * ʒuR[hvZAʒuW𓾂
	 * @param cell
	 * @param x
	 * @param y
	 * @return Point vZW
	 */
	public Point changePosition(int cell , int x , int y ) {
		int w , h ;
		switch (x) {
		case POS_LEFT:
			x = 0 ;
			break ;
		case POS_RIGHT:
			w = this.cellImages[cell].getWidth();
			x = disp.width - w;
			break ;
		case POS_CENTER:
			w = this.cellImages[cell].getWidth();
			x = (disp.width - w) / 2 ;
			break ;
		}

		switch (y) {
		case POS_UPPER:
			y = 0 ;
			break ;
		case POS_LOWER:
			h = this.cellImages[cell].getHeight();
			y = disp.height - h ;
			break ;
		case POS_MIDDLE:
			h = this.cellImages[cell].getHeight();
			y = ( disp.height - h  ) / 2;
			break ;
		}

		Point pt = new Point(x,y);
		return pt;
	}
	
	/**
	 * ʂ\zʂɕ`悷B
	 */
	public void viewDisplay() {
		this.drawImageBuf();
		this.drawShiftImageBuf();
		disp.viewDisplay(this.disp_buf00,this.disp_buf02);
	}
		

	/**
	 * Z̕\\ZbgA
	 * ʂ\zʂɕ`悷B
	 */
	public void viewDisplay(String flagStr) {
		this.setCellView(flagStr);
		this.drawImageBuf();
		this.drawShiftImageBuf();
		disp.viewDisplay(this.disp_buf00,this.disp_buf02);
	}
	
	public void setDisplaySize(int w , int h) {
		this.createDisplay(w, h);
	}

	
	/**
	 * ʂ\zgVWʂɕ`悷B
	 *
	 */
	public void transitionDisplay(String tstr ) {
		this.drawImageBuf();
		this.drawShiftImageBuf();
		disp.transitionDisplay(this.disp_buf00 , this.disp_buf02 , tstr );
	}
	
	/**
	 * Z̕\\ZbgA
	 * ʂ\zgVWʂɕ`悷B
	 */
	public void transitionDisplay(String flagStr, String tstr ) {
		this.setCellView(flagStr);
		this.drawImageBuf();
		this.drawShiftImageBuf();
		disp.transitionDisplay(this.disp_buf00 , this.disp_buf02 , tstr );
	}
	
	
	/**
	 * ʂɓo^ĂgVWʂ̗\ꂩ
	 * gVWR[h𓾂
	 * @param tr
	 * @return
	 */
	public int getTransitionCode( String tr ) {
		return disp.getTransitionCode(tr);
	}
	
	
	/*****************************************************************/
	/*****************************************************************/
	/*****Zn̏*************************************************/
	/*****************************************************************/
	/*****************************************************************/

	/**
	 * SẴZ肷
	 * @param cn
	 */
	public void setCellNumber(int cn ){
		cellImages = new jongsImage[cn];
	}
	
	/**
	 * wZԍɉ摜ǂݍ
	 * @param cell
	 * @param filename
	 * @return
	 */
	public boolean setCellImage(int cell,String filename) {
		BufferedImage bimg ;
		if (this.cellImages[cell] == null) {
			this.cellImages[cell] = new jongsImage();
			this.cellImages[cell].setPoint(0, 0);
		}	
		bimg = this.loadImage(filename, disp);	
		if (bimg == null) return false ;
		cellImages[cell].setImage(bimg, disp);
		cellImages[cell].setFileName(filename);
		return true ;
	}
	
	/**
	 * wZԍ̓ߐFRGBAŒڐݒ肷P
	 * @param cell
	 * @param tc
	 */
	public void setTransColor(int cell , int tc ) {
		if (this.cellImages[cell] != null) {
			cellImages[cell].setTransColor(tc);
		}
	}
	
	/**
	 * wZԍ̓ߐFRGBAlŐݒ肷
	 * @param cell
	 * @param col
	 * @param alpha
	 */
	public void setTransColor(int cell , int col , int alpha) {
		int tc ;
		if (this.cellImages[cell] != null) {
			tc = ( alpha << 24 ) | (col & 0x00ffffff);
			cellImages[cell].setTransColor(tc);
		}
	}

	
	/**
	 * wZԍ̓ߐFWw肷
	 * @param cell
	 * @param x
	 * @param y
	 * @param alpha
	 */
	public void setTransColor(int cell , int x , int y , int alpha) {
		if (this.cellImages[cell] != null) {
			cellImages[cell].setTransColor(x,y,alpha);
		}
	}

	/**
	 * wZԍ̍Wݒ肷
	 * @param cell
	 * @param x
	 * @param y
	 */
	public void setCellPosition(int cell , int x , int y ) {
		Point pt ;
		if (this.cellImages[cell] != null) {
			pt = this.changePosition(cell, x, y);
			cellImages[cell].setPoint(pt);
		}
	}

	/**
	 * wZԍ̃TCYݒ肷
	 * @param cell
	 * @param x
	 * @param y
	 */
	public void setCellSize(int cell , int w , int h ) {
		if (this.cellImages[cell] != null) {
			cellImages[cell].setSize(w, h);
		}
	}
	
	/**
	 * ZɎwTCYAwF̋`C[WU
	 * @param cell
	 * @param w
	 * @param h
	 * @param color
	 */
	public void setCellCanvas( int cell , int w , int h , int color) {
		if (this.cellImages[cell] == null) {
			this.cellImages[cell] = new jongsImage();
			this.cellImages[cell].setPoint(0, 0);
		}	
		this.cellImages[cell] = new jongsImage();
		this.cellImages[cell].setCanvas(w, h, color);		
	}
	
	
	/**
	 * ZɏeLXg̃tHgƐFw肷
	 * @param cell
	 * @param fname
	 * @param stl
	 * @param size
	 * @param fcol
	 * @param fx
	 * @param fy
	 */
	public void setCellTextParameter( int cell , String fname , String stl , int size,  int fcol ) {
		int style ;
		if (this.cellImages[cell] != null) {
			if ( stl.length() == 0 ) {
				style = Font.PLAIN;
			} else {
				if (stl.equals("plain")) style = Font.PLAIN;
				else if (stl.equals("italic")) style = Font.ITALIC;
				else if (stl.equals("bold")) style = Font.BOLD;
				else style = Font.PLAIN;
			}
			
			this.cellImages[cell].setTextParam(fname, style, size, fcol );
		}		
	}
	
	
	/**
	 * Zɕ`悷eLXgZbg
	 * @param cell
	 * @param txt
	 */
	public void setCellText( int cell , String txt ) {
		if (this.cellImages[cell] != null) {
			this.cellImages[cell].setText(txt);
		}
	}
	

	
	/**
	 * tOݒ蕶ɏ]AZ̕\tOݒ肷
	 * @param flagStr
	 */
	public void setCellView(String flagStr) {
		for ( int n = 0 ; n < flagStr.length() && n < this.cellImages.length ; n++ ){
			char c = flagStr.charAt(n);
			if (this.cellImages[n] != null) {
				if (c == '0') this.cellImages[n].setView(false) ;
				else if (c == '1') this.cellImages[n].setView(true) ;				
			}
		}
	}
	
	/**
	 * ZԍƃtOݒwɂɏ]AZ̕\tOݒ肷
	 * @param flag
	 */
	public void setCellView(int flag) {
		int flagHex = flag ;
		for ( int n = 0 ; n < 32 && n < this.cellImages.length ; n++ ){
			int c = flagHex & 0x00000001 ;	
			if (this.cellImages[n] != null) {
				if (c == 0) this.cellImages[n].setView(false) ;
				else if (c == 1 )  this.cellImages[n].setView(true) ;				
			}
			flagHex = flagHex >> 1;
		}
	}		
	public void setCellView(int cell , int val) {
		if ( cell < this.cellImages.length && this.cellImages[cell] != null) {
			if (val == 0) this.cellImages[cell].setView(false) ;
			else if (val == 1 )  this.cellImages[cell].setView(true) ;
		}
	}
	public void setCellView(int cell , String val) {
		if ( cell < this.cellImages.length &&  this.cellImages[cell] != null) {
			if (val.trim().toLowerCase().equals("false")) 
				this.cellImages[cell].setView(false) ;
			else if (val.trim().toLowerCase().equals("true") ) 
				this.cellImages[cell].setView(true) ;
		}
	}


	/*****************************************************************/
	/*****************************************************************/
	/*****eLXgn̏*********************************************/
	/*****************************************************************/
	/*****************************************************************/
	
	/**
	 * ʂɃeLXg̃tHgFݒ肷
	 * @param fc1 F
	 * @param fc2 F
	 */
	public void setFontColor( int fc1 , int fc2 ) {
		disp.setFontColor(fc1, fc2);
	}
	
	/**
	 * ʂɃeLXg̃tHgݒ肷
	 * @param n
	 * @param s
	 * @param sz
	 */
	public void setTextFont(String n , String s , int sz ) {
		String name = n.trim() ;
		String stl = s.trim().toLowerCase() ;
		int style = 0 ;
		int size = sz ;

		if ( name.length() == 0 ) {
			name = disp.textFont.getFontName();
		}
		
		if ( stl.length() == 0 ) {
			style = disp.textFont.getStyle();
		} else {
			if (stl.equals("plain")) style = Font.PLAIN;
			else if (stl.equals("italic")) style = Font.ITALIC;
			else if (stl.equals("bold")) style = Font.BOLD;
			else style = Font.PLAIN;
		}
		
		if (size == 0 ) size= disp.textFont.getSize();
		
		disp.setTextFont(new Font(name,style,size));
	}
	
	
	/**
	 * ʂɃeLXg̕\̈Zbg
	 * @param x
	 * @param y
	 * @param w
	 * @param h
	 */
	public void setTextArea(int x , int y ,int w , int h) {
		disp.setTextArea(x, y, w, h);
	}

	/**
	 * ʂɃeLXg̕ԃItZbgݒ肷
	 * @param ls 
	 * @param lh s
	 */
	public void setTextInterval(int ls, int lh) {
		disp.setTextInterval(ls, lh);
	}
	
	/**
	 * ʂɕoCxg҂
	 * @param txt
	 */
	public void drawText(String txt) {
		disp.drawText(txt);
	}
	
	/**
	 * ʂɕoAw莞ԑ҂ 
	 * @param txt
	 */	
	public void drawWaitText(String txt,int time) {
		disp.drawWaitText(txt,time);
	}
	

	/*****************************************************************/
	/*****************************************************************/
	/*****In̏*************************************************/
	/*****************************************************************/
	/*****************************************************************/	
	
	/**
	 * I{^̕\GA`
	 * @param xnum  w{^
	 * @param ynum  x{^
	 * @param xspan w{^Ԋu
	 * @param yspan x{^Ԋu
	 */
	public void calcSelectButton( Rectangle Area ,  int xnum , int ynum , int xspan , int yspan ) {
		int bx , by , bn , bpx , bpy ;
		int bnum = xnum * ynum ;
		int bwid =  ( Area.width - xspan * (xnum-1) ) / xnum ;
		int bhei =  ( Area.height - yspan * (ynum-1) ) / ynum ;
		if ( bwid < 0 ) {
			bwid = Area.width / xnum ;
			xspan = 0 ;
		}
		if ( bhei < 0 ) {
			bhei = Area.height / ynum ;
			yspan = 0 ;
		}
		
		this.selectBtnArea = new Rectangle [bnum] ;
		bn = 0 ;
		for ( bpy = Area.y , by = 0 ; by < ynum ; by ++ , bpy += bhei + yspan) {
			for ( bpx = Area.x , bx = 0 ; bx < xnum ; bx ++ , bpx += bwid + xspan) {
				this.selectBtnArea[bn] = new Rectangle(bpx , bpy , bwid , bhei);
				bn++ ;
			}
		}
		disp.setSelectButton(this.selectBtnArea);
	}
	
	/**
	 * VECTOR̓eIƂđIɂ͂
	 * @param vct
	 */
	public void setSelectParam( Vector<String> vct  ) {
		int selnum = vct.size();
		disp.setSelectArea(this.selectArea00);
		disp.setSelectColor(this.selectColor00);
		disp.setSelectText(vct,0,selnum);
		disp.setSelectFont(this.selectFont00);
		if ( disp.selectbtn.length < selnum ) {
			if ( selectArea00.width > selectArea00.height )
				calcSelectButton( selectArea00 ,  selnum  , 1 , 0 , 0 ) ;
			else
				calcSelectButton( selectArea00 ,  1 , selnum  , 0 , 0 ) ;
		}
		this.createBtnImages(vct);
		disp.setSelectBtnImage(this.selectBtnImage);
		disp.selectClick();	
	}

	/**
	 * w肳ꂽTCYAFiAt@܁jA{^ʉAtHgAtHgFAeLXgŃ{^摜쐬
	 * @param w
	 * @param h
	 * @param col
	 * @param flag
	 * @param txt
	 * @param tcol
	 * @param tfont
	 * @return
	 */
	public BufferedImage createTransButton(int w, int h , int col , boolean flag , String txt ,int tcol, Font tfont ) {
		int xx , yy , col0 , fw , fh , fx , fy ;
		int alpha = 0xff000000 &  col ;
		int rgb = 0x00ffffff & col ;
		BufferedImage btn = new BufferedImage(w,h, BufferedImage.TYPE_4BYTE_ABGR);
		//System.out.print(":Color:"+Integer.toHexString(alpha));
		//System.out.print(":alpha:"+Integer.toHexString(alpha));
		//System.out.println(":RGB:"+Integer.toHexString(alpha));
		
		
		//if ( alpha == 0 ) col = 0xff000000 | col ;
		//for ( yy = 0 ; yy < h ; yy ++ ) {
		//	for ( xx = 0 ; xx < w ; xx ++ ) {
		//		btn.setRGB(xx, yy, col);
		//	}
		//}
		
		
		Graphics2D g2 = (Graphics2D ) btn.getGraphics();

		g2.setColor(new Color(rgb));
		g2.fillRect(0, 0, w, h);
		g2.draw3DRect(1,1,w-2,h-2, flag );
		g2.draw3DRect(2,2,w-4,h-4, flag );
		if ( alpha != 0 && alpha != 0xff000000 ) {
			for ( yy = 0 ; yy < h ; yy ++ ) {
				for ( xx = 0 ; xx < w ; xx ++ ) {
					col0 = ( btn.getRGB(xx, yy) & 0x00ffffff ) | alpha ;
					btn.setRGB(xx, yy, col0);
				}
			}
		}
		
		g2.setFont(tfont);
		FontMetrics fm = g2.getFontMetrics(tfont);
		g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
		fh = fm.getHeight();
		fy = fh + ( h - fh )/ 2;
		fw = fm.stringWidth(txt);
		fx = (w - fw) / 2 ;
		g2.setColor(new Color(tcol));
		g2.drawString(txt, fx , fy);
		return btn ;
	}

	/**
	 * w肳ꂽʒuƃTCYɑI{^̃C[W쐬B
	 * @param vct
	 */
	public void createBtnImages( Vector<String> vct  ) {
		int bn , biw , bih , bix , biy ;
		Graphics gp ;
		BufferedImage tbtn ;
		int bnum = vct.size();
		if (  bnum > this.selectBtnArea.length ) 
			bnum =  this.selectBtnArea.length;

		//this.selectBtnImage = new VolatileImage[bnum][3] ;
		this.selectBtnImage = new BufferedImage[bnum][3] ;
		
		for ( bn = 0 ; bn < bnum ; bn ++ ) {
			bix = this.selectBtnArea[bn].x ;
			biy = this.selectBtnArea[bn].y ;
			biw = this.selectBtnArea[bn].width ;
			bih = this.selectBtnArea[bn].height ;
			//this.selectBtnImage[bn][0] = this.createTransButton(biw,bih,selectColor00[0],true,vct.get(bn),selectColor00[3],selectFont00);
			//this.selectBtnImage[bn][1] = this.createTransButton(biw,bih,selectColor00[1],true,vct.get(bn),selectColor00[3],selectFont00);
			//this.selectBtnImage[bn][2] = this.createTransButton(biw,bih,selectColor00[2],true,vct.get(bn),selectColor00[3],selectFont00);
			//this.selectBtnImage[bn][0] = disp.createVolatileImage(biw,bih);
			//this.selectBtnImage[bn][1] = disp.createVolatileImage(biw,bih);
			//this.selectBtnImage[bn][2] = disp.createVolatileImage(biw,bih);
			this.selectBtnImage[bn][0] =  new BufferedImage(biw,bih, BufferedImage.TYPE_4BYTE_ABGR);
			this.selectBtnImage[bn][1] =  new BufferedImage(biw,bih, BufferedImage.TYPE_4BYTE_ABGR);
			this.selectBtnImage[bn][2] =  new BufferedImage(biw,bih, BufferedImage.TYPE_4BYTE_ABGR);
			//
			gp = this.selectBtnImage[bn][0].getGraphics();
			gp.drawImage(this.disp_buf00,-bix,-biy,disp);
			tbtn = this.createTransButton(biw,bih,selectColor00[0],true,vct.get(bn),selectColor00[3],selectFont00);
			gp.drawImage(tbtn,0,0,disp);
			//
			gp = this.selectBtnImage[bn][1].getGraphics();
			gp.drawImage(this.disp_buf00,-bix,-biy,disp);
			tbtn = this.createTransButton(biw,bih,selectColor00[1],true,vct.get(bn),selectColor00[3],selectFont00);
			gp.drawImage(tbtn,0,0,disp);
			//
			gp = this.selectBtnImage[bn][2].getGraphics();
			gp.drawImage(this.disp_buf00,-bix,-biy,disp);
			tbtn = this.createTransButton(biw,bih,selectColor00[2],false,vct.get(bn),selectColor00[3],selectFont00);
			gp.drawImage(tbtn,0,0,disp);
		}
	}

	
	/**
	 * ʂɃZNg{^̕\̈Zbg
	 * @param x
	 * @param y
	 * @param w
	 * @param h
	 */
	public void setSelectArea(int x , int y ,int w , int h) {
		selectArea00 = new Rectangle(x, y, w, h) ;
		disp.setSelectArea(selectArea00);
		calcSelectButton( selectArea00 ,  1 , 1 , 0 , 0 ) ;		
	}

	/**
	 * ʂɃZNg{^̕\̈Zbg
	 */
	public void setSelectArea(int x , int y ,int w , int h , int xbnum , int ybnum ) {
		selectArea00 = new Rectangle(x, y, w, h) ;
		disp.setSelectArea(selectArea00);
		calcSelectButton( selectArea00 ,  xbnum , ybnum , 0 , 0 ) ;		
	}

	/**
	 * ʂɃZNg{^̕\̈Zbg
	 */
	public void setSelectArea(int x , int y ,int w , int h , int xbnum , int ybnum , int xspan , int yspan ) {
		selectArea00 = new Rectangle(x, y, w, h) ;
		disp.setSelectArea(selectArea00);
		calcSelectButton( selectArea00 ,  xbnum , ybnum , xspan , yspan ) ;		
	}

	
	
	/**
	 * ʂɃZNg{^̐FZbg
	 * @param c1 ʏF
	 * @param c2 IF
	 * @param c3 F
	 * @param c4 F
	 */
	public void setSelectColor(int c1 , int c2 ,int c3 , int c4) {
		selectColor00 = new int [4] ;
		selectColor00[0] = c1 ;
		selectColor00[1] = c2 ;
		selectColor00[2] = c3 ;
		selectColor00[3] = c4 ;
		disp.setSelectColor(selectColor00);
	}
	
	/**
	 * ʂɃeLXg̃tHgݒ肷
	 * @param n
	 * @param s
	 * @param sz
	 */
	public void setSelectFont(String n , String s , int sz ) {
		String name = n.trim() ;
		String stl = s.trim().toLowerCase() ;
		int style = 0 ;
		int size = sz ;

		if ( name.length() == 0 ) {
			name = this.selectFont00.getFontName();
		}
		
		if ( stl.length() == 0 ) {
			style = disp.textFont.getStyle();
		} else {
			if (stl.equals("plain")) style = Font.PLAIN;
			else if (stl.equals("italic")) style = Font.ITALIC;
			else if (stl.equals("bold")) style = Font.BOLD;
			else style = Font.PLAIN;
		}
		
		if (size == 0 ) size = 10 ;
		
		this.selectFont00 = new Font(name,style,size);
	}
	
	
	/**
	 * {^ZNg̕ԋplԂ
	 * @return
	 */
	public int getSelectButton() {
		return disp.selectButton ;
	}

	public String getSelectText() {
		return disp.selectText ;
	}
	
	/**
	 * ʂɃZ̃NbNvR}h𑗂
	 *
	 */
	public void cellClick() {
		disp.cellClick();
	}
	
	/**
	 * NbNꂽZԍ𓾂
	 * @return
	 */
	public int getSelectCell() {
		int cellvalue , press ;
		//SZɑ΂NbNʒu`FbN
		cellvalue = this.checkCellClick(disp.releasex , disp.releasey );
		press = this.checkCellClick(disp.pressx , disp.pressy );
		//}EX̃vXƃ[XCxg̉ӏZłȂ
		//NbNꂽƂ݂ȂȂ
		if ( cellvalue != press ) {
			disp.cellClick();
			cellvalue = -1;
		}
		return cellvalue ;
	}
	
}
