﻿CREATE OR REPLACE VIEW rv_storage AS 
SELECT s.ad_client_id,
    s.ad_org_id,
    s.m_product_id,
    p.value,
    p.name,
    p.description,
    p.upc,
    p.sku,
    p.c_uom_id,
    p.m_product_category_id,
    p.classification,
    p.weight,
    p.volume,
    p.versionno,
    p.guaranteedays,
    p.guaranteedaysmin,
    s.m_locator_id,
    l.m_warehouse_id,
    l.x,
    l.y,
    l.z,
    s.qtyonhand,
    s.qtyreserved,
    CASE WHEN COALESCE(lt.IsAvailableForReservation,'Y')='Y' THEN s.qtyonhand ELSE 0 END - s.qtyreserved                                    AS qtyavailable,
    s.qtyordered,
    s.datelastinventory,
    s.m_attributesetinstance_id,
    asi.m_attributeset_id,
    asi.serno,
    asi.lot,
    asi.m_lot_id,
    asi.guaranteedate,
    daysbetween(asi.guaranteedate, getdate())                      AS shelflifedays,
    daysbetween(asi.guaranteedate, getdate()) - p.guaranteedaysmin AS goodfordays,
    CASE WHEN COALESCE(p.guaranteedays, 0) > 0 THEN round(daysbetween(asi.guaranteedate, getdate()) / p.guaranteedays * 100, 0) ELSE NULL END                                                        AS 
    shelfliferemainingpct,
    s.isactive                                                     AS m_storage_isactive,
    s.updated                                                      AS m_storage_updated,
    s.updatedby                                                    AS m_storage_updatedby,
    l.ad_org_id                                                    AS m_locator_ad_org_id,
    l.isactive                                                     AS m_locator_isactive,
    l.isdefault,
    l.priorityno,
    l.value                                                        AS m_locator_value,
    p.ad_org_id                                                    AS m_product_ad_org_id,
    p.copyfrom                                                     AS m_product_copyfrom,
    p.created                                                      AS m_product_created,
    p.createdby                                                    AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.descriptionurl,
    p.discontinued                                                 AS m_product_discontinued,
    p.discontinuedat                                               AS m_product_discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.help,
    p.imageurl,
    p.isactive                                                     AS m_product_isactive,
    p.isbom,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                                                    AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id                                            AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id                                    AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id                                                 AS m_product_m_locator_id,
    p.processing                                                   AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                                                  AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                                                      AS m_product_updated,
    p.updatedby                                                    AS m_product_updatedby,
    asi.ad_org_id                                                  AS m_asi_ad_org_id,
    asi.created                                                    AS m_asi_created,
    asi.createdby                                                  AS m_asi_createdby,
    asi.description                                                AS m_asi_description,
    asi.isactive                                                   AS m_asi_isactive,
    asi.updated                                                    AS m_asi_updated,
    asi.updatedby                                                  AS m_asi_updatedby 
FROM m_storage s 
        JOIN m_locator l 
        ON s.m_locator_id = l.m_locator_id 
        LEFT JOIN m_locatortype lt
        ON l.m_locatortype_id = lt.m_locatortype_id 
        JOIN m_product p 
        ON s.m_product_id = p.m_product_id 
        LEFT JOIN m_attributesetinstance asi 
        ON s.m_attributesetinstance_id = asi.m_attributesetinstance_id
;
