/******************************************************************************
 * Product: iDempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.KeyNamePair;

/** Generated Interface for PA_ReportLine
 *  @author iDempiere (generated) 
 *  @version Release 3.1
 */
public interface I_PA_ReportLine 
{

    /** TableName=PA_ReportLine */
    public static final String Table_Name = "PA_ReportLine";

    /** AD_Table_ID=448 */
    public static final int Table_ID = 448;

    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);

    /** AccessLevel = 3 - Client - Org 
     */
    BigDecimal accessLevel = BigDecimal.valueOf(3);

    /** Load Meta Data */

    /** Column name AD_Client_ID */
    public static final String COLUMNNAME_AD_Client_ID = "AD_Client_ID";

	/** Get Client.
	  * Client/Tenant for this installation.
	  */
	public int getAD_Client_ID();

    /** Column name AD_Org_ID */
    public static final String COLUMNNAME_AD_Org_ID = "AD_Org_ID";

	/** Set Organization.
	  * Organizational entity within client
	  */
	public void setAD_Org_ID (int AD_Org_ID);

	/** Get Organization.
	  * Organizational entity within client
	  */
	public int getAD_Org_ID();

    /** Column name CalculationType */
    public static final String COLUMNNAME_CalculationType = "CalculationType";

	/** Set Calculation	  */
	public void setCalculationType (String CalculationType);

	/** Get Calculation	  */
	public String getCalculationType();

    /** Column name Created */
    public static final String COLUMNNAME_Created = "Created";

	/** Get Created.
	  * Date this record was created
	  */
	public Timestamp getCreated();

    /** Column name CreatedBy */
    public static final String COLUMNNAME_CreatedBy = "CreatedBy";

	/** Get Created By.
	  * User who created this records
	  */
	public int getCreatedBy();

    /** Column name Description */
    public static final String COLUMNNAME_Description = "Description";

	/** Set Description.
	  * Optional short description of the record
	  */
	public void setDescription (String Description);

	/** Get Description.
	  * Optional short description of the record
	  */
	public String getDescription();

    /** Column name GL_Budget_ID */
    public static final String COLUMNNAME_GL_Budget_ID = "GL_Budget_ID";

	/** Set Budget.
	  * General Ledger Budget
	  */
	public void setGL_Budget_ID (int GL_Budget_ID);

	/** Get Budget.
	  * General Ledger Budget
	  */
	public int getGL_Budget_ID();

	public org.compiere.model.I_GL_Budget getGL_Budget() throws RuntimeException;

    /** Column name IsActive */
    public static final String COLUMNNAME_IsActive = "IsActive";

	/** Set Active.
	  * The record is active in the system
	  */
	public void setIsActive (boolean IsActive);

	/** Get Active.
	  * The record is active in the system
	  */
	public boolean isActive();

    /** Column name IsInverseDebitCreditOnly */
    public static final String COLUMNNAME_IsInverseDebitCreditOnly = "IsInverseDebitCreditOnly";

	/** Set Inverse Operation for Debit/Credit Only Column.
	  * Apply inverse operation to debit or credit only column
	  */
	public void setIsInverseDebitCreditOnly (boolean IsInverseDebitCreditOnly);

	/** Get Inverse Operation for Debit/Credit Only Column.
	  * Apply inverse operation to debit or credit only column
	  */
	public boolean isInverseDebitCreditOnly();

    /** Column name IsPrinted */
    public static final String COLUMNNAME_IsPrinted = "IsPrinted";

	/** Set Printed.
	  * Indicates if this document / line is printed
	  */
	public void setIsPrinted (boolean IsPrinted);

	/** Get Printed.
	  * Indicates if this document / line is printed
	  */
	public boolean isPrinted();

    /** Column name LineType */
    public static final String COLUMNNAME_LineType = "LineType";

	/** Set Line Type	  */
	public void setLineType (String LineType);

	/** Get Line Type	  */
	public String getLineType();

    /** Column name Name */
    public static final String COLUMNNAME_Name = "Name";

	/** Set Name.
	  * Alphanumeric identifier of the entity
	  */
	public void setName (String Name);

	/** Get Name.
	  * Alphanumeric identifier of the entity
	  */
	public String getName();

    /** Column name Oper_1_ID */
    public static final String COLUMNNAME_Oper_1_ID = "Oper_1_ID";

	/** Set Operand 1.
	  * First operand for calculation
	  */
	public void setOper_1_ID (int Oper_1_ID);

	/** Get Operand 1.
	  * First operand for calculation
	  */
	public int getOper_1_ID();

	public org.compiere.model.I_PA_ReportLine getOper_1() throws RuntimeException;

    /** Column name Oper_2_ID */
    public static final String COLUMNNAME_Oper_2_ID = "Oper_2_ID";

	/** Set Operand 2.
	  * Second operand for calculation
	  */
	public void setOper_2_ID (int Oper_2_ID);

	/** Get Operand 2.
	  * Second operand for calculation
	  */
	public int getOper_2_ID();

	public org.compiere.model.I_PA_ReportLine getOper_2() throws RuntimeException;

    /** Column name PAAmountType */
    public static final String COLUMNNAME_PAAmountType = "PAAmountType";

	/** Set Amount Type.
	  * PA Amount Type for reporting
	  */
	public void setPAAmountType (String PAAmountType);

	/** Get Amount Type.
	  * PA Amount Type for reporting
	  */
	public String getPAAmountType();

    /** Column name PAPeriodType */
    public static final String COLUMNNAME_PAPeriodType = "PAPeriodType";

	/** Set Period Type.
	  * PA Period Type
	  */
	public void setPAPeriodType (String PAPeriodType);

	/** Get Period Type.
	  * PA Period Type
	  */
	public String getPAPeriodType();

    /** Column name PA_ReportLine_ID */
    public static final String COLUMNNAME_PA_ReportLine_ID = "PA_ReportLine_ID";

	/** Set Report Line	  */
	public void setPA_ReportLine_ID (int PA_ReportLine_ID);

	/** Get Report Line	  */
	public int getPA_ReportLine_ID();

    /** Column name PA_ReportLineSet_ID */
    public static final String COLUMNNAME_PA_ReportLineSet_ID = "PA_ReportLineSet_ID";

	/** Set Report Line Set	  */
	public void setPA_ReportLineSet_ID (int PA_ReportLineSet_ID);

	/** Get Report Line Set	  */
	public int getPA_ReportLineSet_ID();

	public org.compiere.model.I_PA_ReportLineSet getPA_ReportLineSet() throws RuntimeException;

    /** Column name PA_ReportLine_UU */
    public static final String COLUMNNAME_PA_ReportLine_UU = "PA_ReportLine_UU";

	/** Set PA_ReportLine_UU	  */
	public void setPA_ReportLine_UU (String PA_ReportLine_UU);

	/** Get PA_ReportLine_UU	  */
	public String getPA_ReportLine_UU();

    /** Column name PostingType */
    public static final String COLUMNNAME_PostingType = "PostingType";

	/** Set PostingType.
	  * The type of posted amount for the transaction
	  */
	public void setPostingType (String PostingType);

	/** Get PostingType.
	  * The type of posted amount for the transaction
	  */
	public String getPostingType();

    /** Column name SeqNo */
    public static final String COLUMNNAME_SeqNo = "SeqNo";

	/** Set Sequence.
	  * Method of ordering records;
 lowest number comes first
	  */
	public void setSeqNo (int SeqNo);

	/** Get Sequence.
	  * Method of ordering records;
 lowest number comes first
	  */
	public int getSeqNo();

    /** Column name Updated */
    public static final String COLUMNNAME_Updated = "Updated";

	/** Get Updated.
	  * Date this record was updated
	  */
	public Timestamp getUpdated();

    /** Column name UpdatedBy */
    public static final String COLUMNNAME_UpdatedBy = "UpdatedBy";

	/** Get Updated By.
	  * User who updated this records
	  */
	public int getUpdatedBy();
}
