/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import net.osdn.pdf_brewer.instruction.Align;
import net.osdn.pdf_brewer.instruction.Box;
import net.osdn.pdf_brewer.instruction.Image;
import net.osdn.pdf_brewer.instruction.Instruction;
import net.osdn.pdf_brewer.instruction.Line;
import net.osdn.pdf_brewer.instruction.LineStyle;
import net.osdn.pdf_brewer.instruction.Media;
import net.osdn.pdf_brewer.instruction.Rect;
import net.osdn.pdf_brewer.instruction.text.Font;
import net.osdn.pdf_brewer.instruction.text.LineHeight;
import net.osdn.pdf_brewer.instruction.text.Text;
import net.osdn.pdf_brewer.instruction.text.TextAlign;
import net.osdn.util.yaml.CharsetDetector;
import net.osdn.util.yaml.Yaml;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class BrewerData {
    private String title;
    private String author;
    private PDRectangle mediaBox;
    private List<Instruction> instructions = new ArrayList<Instruction>();

    public BrewerData(String path) throws IOException, TemplateException {
        this(new File(path));
    }

    public BrewerData(File file) throws IOException, TemplateException {
        List<String> lines;
        String s = file.getName().toLowerCase();
        if (s.endsWith(".pb")) {
            lines = CharsetDetector.readAllLines((File)file);
        } else if (s.endsWith("yml")) {
            lines = this.processYaml(file);
        } else {
            throw new IllegalArgumentException();
        }
        for (String line : lines) {
            String first;
            Map.Entry<Integer, List<Object>> result = BrewerData.parse(line);
            int indent = result.getKey();
            List<Object> tokens = result.getValue();
            if (tokens.size() < 1 || !(tokens.get(0) instanceof String) || (first = (String)tokens.remove(0)).charAt(0) != '\\') continue;
            first = first.substring(1).toLowerCase();
            try {
                if (first.equals("media")) {
                    if (this.mediaBox != null) continue;
                    Media media = new Media(indent, tokens);
                    this.mediaBox = media.getRectangle();
                    continue;
                }
                if (first.equals("align")) {
                    this.instructions.add(new Align(indent, tokens));
                    continue;
                }
                if (first.equals("box")) {
                    this.instructions.add(new Box(indent, tokens));
                    continue;
                }
                if (first.equals("image")) {
                    this.instructions.add(new Image(indent, tokens));
                    continue;
                }
                if (first.equals("line")) {
                    this.instructions.add(new Line(indent, tokens));
                    continue;
                }
                if (first.equals("line-style")) {
                    this.instructions.add(new LineStyle(indent, tokens));
                    continue;
                }
                if (first.equals("rect")) {
                    this.instructions.add(new Rect(indent, tokens));
                    continue;
                }
                if (first.equals("font")) {
                    this.instructions.add(new Font(indent, tokens));
                    continue;
                }
                if (first.equals("line-height")) {
                    this.instructions.add(new LineHeight(indent, tokens));
                    continue;
                }
                if (first.equals("text")) {
                    String text = BrewerData.getRawText(first, line);
                    if (text.length() <= 0) continue;
                    this.instructions.add(new Text(indent, text));
                    continue;
                }
                if (!first.equals("text-align")) continue;
                this.instructions.add(new TextAlign(indent, tokens));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map.Entry<Integer, List<Object>> parse(String line) {
        LinkedList<Object> tokens = new LinkedList<Object>();
        StringBuilder indent = new StringBuilder();
        int i = 0;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') {
                indent.append(c);
                continue;
            }
            if (c != '\u3000') break;
            indent.append(' ');
            indent.append(' ');
        }
        line = line.substring(i);
        for (String from : new String[]{"   \t", "  \t", " \t"}) {
            i = 0;
            while ((i = indent.indexOf(from, i)) != -1) {
                indent.replace(i, i + from.length(), "\t");
                ++i;
            }
        }
        for (String from : new String[]{"   ", "  ", " "}) {
            i = 0;
            while ((i = indent.indexOf(from, i)) != -1) {
                indent.replace(i, i + from.length(), "\t");
                ++i;
            }
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(line);
            while (scanner.hasNext()) {
                String s = scanner.next();
                try {
                    double d = Double.parseDouble(s);
                    if (d == 0.0 && s.charAt(0) == '-') {
                        d = -4.9E-324;
                    }
                    tokens.add(d);
                }
                catch (NumberFormatException e) {
                    tokens.add(s);
                }
            }
        }
        return new AbstractMap.SimpleEntry<Integer, List<Object>>(indent.length(), tokens);
    }

    private static String getRawText(String first, String line) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') {
                indent.append(c);
                continue;
            }
            if (c != '\u3000') break;
            indent.append(' ');
            indent.append(' ');
        }
        String text = line.substring(i + first.length() + 2);
        text = text.replace("\\n", "\n");
        text = text.replace('\t', ' ');
        return text;
    }

    public static File getApplicationDirectory(Class<?> cls) {
        try {
            ProtectionDomain pd = cls.getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL location = cs.getLocation();
            URI uri = location.toURI();
            String path = uri.getPath();
            File file = new File(path);
            return file.getParentFile();
        }
        catch (Exception e) {
            try {
                return new File(".").getCanonicalFile();
            }
            catch (IOException e1) {
                return new File(".").getAbsoluteFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> processYaml(File file) throws IOException, TemplateException {
        ArrayList<String> lines = new ArrayList<String>();
        File appDir = BrewerData.getApplicationDirectory(BrewerData.class);
        Configuration freeMarker = new Configuration(Configuration.VERSION_2_3_26);
        freeMarker.setDefaultEncoding("UTF-8");
        freeMarker.setDirectoryForTemplateLoading(new File(appDir, "templates"));
        Yaml yml = new Yaml(file);
        Template template = null;
        Object obj = yml.get("template");
        if (obj instanceof String) {
            String filename = (String)obj;
            template = freeMarker.getTemplate(filename);
        }
        if (template == null) {
            return null;
        }
        obj = yml.get("title");
        if (obj instanceof String) {
            this.title = (String)obj;
        }
        if ((obj = yml.get("author")) instanceof String) {
            this.author = (String)obj;
        }
        StringWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            writer = new StringWriter();
            template.process((Object)yml.getMap(), (Writer)writer);
            reader = new BufferedReader(new StringReader(writer.toString()));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return lines;
    }
}

