/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.client;

import com.JRcServer.JRCommandException;
import com.JRcServer.JRcConnectCommon;
import com.JRcServer.JRcParameter;
import com.JRcServer.JRcProtocolDef;
import com.JRcServer.JRcResponseBean;
import com.JRcServer.client.JRcClientDriver;
import com.JRcServer.client.JRcClientSession;
import com.JRcServer.client.JRcConnection;
import com.JRcServer.client.JRcResult;
import com.JRcServer.client.JRcResultImple;
import com.JRcServer.client.JRcSerializableSession;
import com.JRcServer.commons.conv.Base64;
import com.JRcServer.commons.def.BaseDef;
import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;
import com.JRcServer.commons.exception.ConvertException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.IOCom;
import com.JRcServer.commons.net.ConnectTimeoutException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.BinResourceOutputStream;
import com.JRcServer.commons.resource.ConvertResourceParam;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.CharTable;
import com.JRcServer.commons.util.ConvertParam;
import com.JRcServer.commons.util.array.ObjectArray;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;

class JRcConnectionImple
implements JRcConnection {
    private static final int WAIT_CONNECT_TIME = 2500;
    private static final long RECONNECT_TIME = 5000L;
    private static final int SEND_BUFFER = 512;
    private static final String BASE64_HEADER = "base64-";
    private static final String LFILE_HEADER = "file-";
    private JRcSerializableSession session = null;
    private ResourceType resType = null;
    private Socket socket = null;
    private int timeout = -1;
    private CharTable table = null;
    private String serviceName = null;
    private long beforeExecTime = -1L;
    private final Synchronized sync = new Synchronized();

    private JRcConnectionImple() {
    }

    public JRcConnectionImple(boolean cacheMode, String applicationName, InetAddress addr, int port, int timeout) throws InputException, AccessException {
        try {
            this.sync.create();
            this.socket = new Socket();
            JRcConnectCommon.setSocketOption((Socket)this.socket);
            this.socket.bind(null);
            this.socket.connect(new InetSocketAddress(addr, port), 2500);
            this.session = (JRcSerializableSession)JRcSerializableSession.getJRcClientSession(applicationName, addr, port);
            this.resType = cacheMode ? new ResourceType(2, JRcClientDriver.CACHE_DIR) : new ResourceType();
            this.timeout = timeout <= 0 ? -1 : timeout;
            this.table = new CharTable();
            this.serviceName = null;
            this.beforeExecTime = System.currentTimeMillis();
        }
        catch (InputException in) {
            this.close();
            throw in;
        }
        catch (Exception e) {
            this.close();
            throw new AccessException((Throwable)e);
        }
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        if (this.table != null) {
            try {
                this.table.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.session != null) {
            try {
                JRcSerializableSession.setJRcClientSession(this.session);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.table = null;
        this.session = null;
        this.resType = null;
        this.socket = null;
        this.timeout = -1;
        this.serviceName = null;
        this.sync.clear();
    }

    public synchronized void retry() throws AccessException {
        Socket soc = null;
        if (this.session == null || !this.session.isUseObject()) {
            throw new AccessException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        try {
            soc = new Socket(InetAddress.getByName(this.session.getHostName()), this.session.getPort());
            JRcConnectCommon.setSocketOption((Socket)soc);
        }
        catch (Exception e) {
            try {
                soc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AccessException((Throwable)e);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = soc;
        soc = null;
    }

    public void closeConnection() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
    }

    public synchronized void createService(String name) throws InputException {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        this.serviceName = name;
        this.table.clear();
    }

    public synchronized void clearService() {
        if (this.session != null || this.session.isUseObject()) {
            this.serviceName = null;
            if (this.table != null) {
                this.table.clear();
            } else {
                this.table = new CharTable();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized JRcResult execution() throws JRCommandException, ExecutionException {
        JRcResultImple ret;
        JRcResponseBean bean;
        block20: {
            bean = null;
            ret = null;
            try {
                try {
                    if (this.session == null) throw new JRCommandException(0x40000000, "\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
                    if (!this.session.isUseObject()) {
                        throw new JRCommandException(0x40000000, "\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    if (this.serviceName == null) throw new JRCommandException(0x40000000, "\u554f\u3044\u5408\u308f\u305b\u305f\u3044\u30b5\u30fc\u30d3\u30b9\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                    if (this.serviceName.length() <= 0) {
                        throw new JRCommandException(0x40000000, "\u554f\u3044\u5408\u308f\u305b\u305f\u3044\u30b5\u30fc\u30d3\u30b9\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                    }
                    if (this.isClosed() || this.beforeExecTime != -1L && System.currentTimeMillis() - this.beforeExecTime >= 5000L) {
                        this.retry();
                        this.beforeExecTime = System.currentTimeMillis();
                    }
                    if ((bean = this.executionService()) == null) {
                        throw new JRCommandException(0x40000000, "\u51e6\u7406\u7d50\u679c\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                    }
                    if ((bean.getResult() & 0xF0000000) == 0x10000000) {
                        if (bean.getSessionID() >= 0L) {
                            this.session.setSessionID(bean.getSessionID());
                        }
                        ret = new JRcResultImple(bean);
                        bean.destroy();
                        bean = null;
                    } else {
                        if (bean.getResultMessage() != null) {
                            throw new JRCommandException(bean.getResult(), bean.getResultMessage());
                        }
                        if ((bean.getResult() & 0xF0000000) == 0x20000000) {
                            throw new JRCommandException(bean.getResult(), "\u4ee5\u4e0b\u306e\u8b66\u544a\u30b3\u30fc\u30c9\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f[0x" + Integer.toHexString(bean.getResult()) + "]");
                        }
                        if ((bean.getResult() & 0xF0000000) == 0x40000000) {
                            throw new JRCommandException(bean.getResult(), "\u4ee5\u4e0b\u306e\u7570\u5e38\u30b3\u30fc\u30c9\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f[0x" + Integer.toHexString(bean.getResult()) + "]");
                        }
                    }
                    this.beforeExecTime = System.currentTimeMillis();
                }
                catch (ConnectTimeoutException ct) {
                    this.closeConnection();
                    throw new JRCommandException(0x40000001, "\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u306b\u3088\u308a\u5207\u65ad\u3057\u307e\u3059");
                }
                catch (JRCommandException je) {
                    throw je;
                }
                catch (ExecutionException ee) {
                    this.closeConnection();
                    throw ee;
                }
                catch (AccessException ae) {
                    this.closeConnection();
                    throw new JRCommandException(0x40000000, (BaseException)ae);
                }
                catch (Exception e) {
                    this.closeConnection();
                    throw new ExecutionException((Throwable)e, 254);
                }
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                if (bean != null) {
                    bean.destroy();
                }
                bean = null;
                throw throwable;
            }
            {
                Object var4_10 = null;
                if (bean == null) break block20;
            }
            bean.destroy();
        }
        bean = null;
        return ret;
    }

    public JRcResult execution(String command) throws JRCommandException, ExecutionException {
        String[] cmd = null;
        ObjectArray ary = null;
        if (command == null || (command = command.trim()).length() <= 0) {
            throw new JRCommandException(0x40000000, "\u6307\u5b9a\u3055\u308c\u305f\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059>" + command);
        }
        this.clearService();
        cmd = new String[]{command};
        if (cmd[0].startsWith("?")) {
            cmd[0] = cmd[0].substring(1);
            ary = JRcConnectionImple.convertURLDecoder(cmd);
            cmd = null;
        } else {
            ary = JRcConnectionImple.convertBase(cmd);
            cmd = null;
        }
        this.commandAnalysisByCommand(ary);
        return this.execution();
    }

    public synchronized void removeParameter(String key) {
        if ((this.session != null || this.session.isUseObject()) && this.table != null) {
            try {
                this.table.remove(JRcConnectionImple.convertKey(key));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void setParameterToBinary(String key, byte[] value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null || value.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setBinary(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized byte[] getParameterToBinary(String key) {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getBinary();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToString(String key, String value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null || value.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setString(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized String getParameterToString(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getString();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToBoolean(String key, Boolean value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setBoolean(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Boolean getParameterToBoolean(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getBoolean();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToShort(String key, Short value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setShort(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Short getParameterToShort(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getShort();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToInteger(String key, Integer value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setInteger(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Integer getParameterToInteger(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getInteger();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToLong(String key, Long value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setLong(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Long getParameterToLong(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getLong();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToFloat(String key, Float value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setFloat(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Float getParameterToFloat(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getFloat();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToDouble(String key, Double value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setDouble(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Double getParameterToDouble(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getDouble();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToDecimal(String key, BigDecimal value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setDecimal(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized BigDecimal getParameterToDecimal(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getDecimal();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void setParameterToTimestamp(String key, Date value) throws InputException {
        JRcParameter param = null;
        if ((key = JRcConnectionImple.convertKey(key)) == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.session == null || !this.session.isUseObject()) {
            throw new InputException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        if (this.table != null) {
            if (this.table.isData(key)) {
                throw new InputException("\u8a2d\u5b9a\u5bfe\u8c61\u306e\u30ad\u30fc\u540d[" + key + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
            }
            param = new JRcParameter();
            param.setTimestamp(value);
            this.table.add(key, (Object)param);
        }
    }

    public synchronized Date getParameterToTimestamp(String key) throws ConvertException {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getTimestamp();
        }
        catch (ConvertException ce) {
            throw ce;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized int getParameterType(String key) {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return -1;
        }
        try {
            return ((JRcParameter)this.table.get(key)).getType();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public synchronized String[] getParameterKeys() {
        if (this.session == null || !this.session.isUseObject() || this.table == null) {
            return null;
        }
        return this.table.getNames();
    }

    public synchronized int getParameterSize() {
        if (this.session == null || !this.session.isUseObject() || this.table == null) {
            return 0;
        }
        return this.table.size();
    }

    public synchronized boolean isParameterName(String key) {
        if ((key = JRcConnectionImple.convertKey(key)) == null || this.session == null || !this.session.isUseObject() || this.table == null) {
            return false;
        }
        return this.table.isData(key);
    }

    public synchronized JRcClientSession getJRcClientSession() {
        return this.session == null || !this.session.isUseObject() ? null : this.session;
    }

    public synchronized String getApplicationName() {
        return this.session == null || !this.session.isUseObject() ? null : this.session.getApplicationName();
    }

    public synchronized long getSessionID() {
        return this.session == null || !this.session.isUseObject() ? -1L : this.session.getSessionID();
    }

    public synchronized InetAddress getServerAddress() {
        InetAddress ret = null;
        if (this.session == null || !this.session.isUseObject()) {
            ret = null;
        } else {
            try {
                ret = InetAddress.getByName(this.session.getHostName());
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public synchronized int getServerPort() {
        return this.session == null || !this.session.isUseObject() ? -1 : this.session.getPort();
    }

    public synchronized InetAddress getLocalAddress() {
        if (this.session == null || !this.session.isUseObject() || this.socket == null) {
            return null;
        }
        return this.socket.getLocalAddress();
    }

    public synchronized int getLocalPort() {
        if (this.session == null || !this.session.isUseObject() || this.socket == null) {
            return -1;
        }
        return this.socket.getLocalPort();
    }

    public synchronized ResourceType getResourceType() {
        if (this.session == null || !this.session.isUseObject()) {
            return null;
        }
        return this.resType;
    }

    public synchronized boolean isClosed() {
        if (this.session == null || !this.session.isUseObject() || this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    private static final String convertKey(String key) {
        if (key == null || (key = key.trim().toLowerCase()).length() <= 0) {
            return null;
        }
        return key;
    }

    private static final String[] convertKeyValue(String string) {
        String[] ret = null;
        int pnt = string.indexOf("=");
        ret = new String[]{string.substring(0, pnt), string.substring(pnt + 1, string.length())};
        return ret;
    }

    /*
     * Exception decompiling
     */
    private static final ObjectArray convertURLDecoder(String[] command) throws JRCommandException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 457->460)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static final ObjectArray convertBase(String[] command) throws JRCommandException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 334->337)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void convertPossibleParameter(String[] kv) throws JRCommandException, Exception {
        String key = null;
        String value = null;
        String file = null;
        Date d = null;
        SimpleDateFormat s = null;
        key = kv[0];
        value = kv[1];
        if (value.length() > BASE64_HEADER.length() && BASE64_HEADER.equals(value.substring(0, BASE64_HEADER.length()).toLowerCase())) {
            String base64 = value.substring(BASE64_HEADER.length());
            if (!Base64.isBase64((String)base64)) {
                throw new JRCommandException(0x40000000, "Base64\u30c7\u30b3\u30fc\u30c9\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            this.setParameterToBinary(key, Base64.decode((String)base64));
            return;
        }
        if (value.length() > LFILE_HEADER.length() && LFILE_HEADER.equals(value.substring(0, LFILE_HEADER.length()).toLowerCase())) {
            file = value.substring(LFILE_HEADER.length());
            if (file.indexOf(":") == -1 && !file.startsWith("/") && !file.startsWith("\\")) {
                file = JRcClientDriver.WORK_DIR + BaseDef.FILE_SEPARATOR + file;
            }
            if (!IOCom.isFileExists((String)(file = IOCom.getName((String)file)))) {
                throw new JRCommandException(0x40000000, "\u5bfe\u8c61\u30d5\u30a1\u30a4\u30eb[" + file + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            this.setParameterToBinary(key, IOCom.getFile((String)file));
            return;
        }
        try {
            long lng = Long.parseLong(value);
            try {
                int integer = Integer.parseInt(value);
                if (lng == (long)integer) {
                    this.setParameterToInteger(key, new Integer(integer));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setParameterToLong(key, new Long(lng));
            return;
        }
        catch (Exception lng) {
            try {
                if (value.indexOf(".") >= 0) {
                    try {
                        Double v = new Double(value);
                        this.setParameterToDouble(key, v);
                        return;
                    }
                    catch (Exception v) {}
                }
            }
            catch (Exception v) {
                // empty catch block
            }
            try {
                String v = value.toLowerCase();
                if (v.equals("true")) {
                    this.setParameterToBoolean(key, new Boolean(true));
                    return;
                }
                if (v.equals("false")) {
                    this.setParameterToBoolean(key, new Boolean(false));
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value.indexOf("/") >= 0 || value.indexOf("-") >= 0 || value.indexOf("\u5e74") >= 0 || value.indexOf("\u6708") >= 0 || value.indexOf("\u65e5") >= 0) {
                try {
                    s = new SimpleDateFormat("yyyy/MM/dd,HH:mm:ss");
                    d = s.parse(value);
                    this.setParameterToTimestamp(key, d);
                    return;
                }
                catch (Exception exception) {
                    try {
                        s = new SimpleDateFormat("yyyy-MM-dd,HH:mm:ss");
                        d = s.parse(value);
                        this.setParameterToTimestamp(key, d);
                        return;
                    }
                    catch (Exception exception2) {
                        try {
                            s = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5,HH:mm:ss");
                            d = s.parse(value);
                            this.setParameterToTimestamp(key, d);
                            return;
                        }
                        catch (Exception exception3) {
                            try {
                                s = new SimpleDateFormat("yyyy/MM/dd");
                                d = s.parse(value);
                                this.setParameterToTimestamp(key, d);
                                return;
                            }
                            catch (Exception exception4) {
                                try {
                                    s = new SimpleDateFormat("yyyy-MM-dd");
                                    d = s.parse(value);
                                    this.setParameterToTimestamp(key, d);
                                    return;
                                }
                                catch (Exception exception5) {
                                    try {
                                        s = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                                        d = s.parse(value);
                                        this.setParameterToTimestamp(key, d);
                                        return;
                                    }
                                    catch (Exception exception6) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.setParameterToString(key, value);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private final void commandAnalysisByCommand(ObjectArray ary) throws JRCommandException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 114->118)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final JRcResponseBean executionService() throws ConnectTimeoutException, ExecutionException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [6 : 257->260)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void createSend(ResourceType type, OutputStream stream) throws AccessException {
        bin = null;
        binRes = null;
        binStream = null;
        paramNames = null;
        param = null;
        try {
            try {
                binRes = Resource.createBinResource((ResourceType)type, (int)1);
                binStream = new BufferedOutputStream((OutputStream)new BinResourceOutputStream(binRes));
                binStream.write(ConvertParam.convertLong((long)this.session.getSessionID()));
                bin = this.session.getApplicationName().getBytes("UTF8");
                len = bin.length;
                binStream.write(ConvertParam.convertInt((int)len));
                binStream.write(bin);
                bin = this.serviceName.getBytes("UTF8");
                len = bin.length;
                binStream.write(ConvertParam.convertInt((int)len));
                binStream.write(bin);
                len = this.table.size();
                binStream.write(ConvertParam.convertInt((int)len));
                if (len > 0) {
                    paramNames = this.table.getNames();
                    i = 0;
                    while (i < len) {
                        param = (JRcParameter)this.table.get(paramNames[i]);
                        if (param == null || param.getBinary() == null || param.getBinary().length <= 0) {
                            binStream.write(ConvertParam.convertInt((int)len));
                            binStream.write(255);
                            binStream.write(ConvertParam.convertInt((int)len));
                        } else {
                            bin = paramNames[i].getBytes("UTF8");
                            paramNameLen = bin.length;
                            binStream.write(ConvertParam.convertInt((int)paramNameLen));
                            binStream.write(bin);
                            param.exportOutputStream(binStream);
                        }
                        ++i;
                    }
                }
                binStream.flush();
                binStream.close();
                binStream = null;
                bin = new byte[512];
                len = 10 + binRes.size();
                stream.write(JRcProtocolDef.RCV_HEADER);
                stream.write(ConvertParam.convertInt((int)len));
                cnt = 0;
                while (true) {
                    block15: {
                        if ((len = binRes.getBinary(bin, cnt)) > 0) break block15;
                        stream.flush();
                        break;
                    }
                    stream.write(bin, 0, len);
                    cnt += len;
                }
            }
            catch (Exception e) {
                throw new AccessException((Throwable)e);
            }
        }
        catch (Throwable var14_13) {
            var13_14 = null;
            if (binStream != null) {
                try {
                    binStream.close();
                }
                catch (Exception var15_16) {
                    // empty catch block
                }
            }
            binStream = null;
            throw var14_13;
        }
        {
            var13_15 = null;
            if (binStream == null) return;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 413->421)] { 
lbl71:
        // 1 sources

        binStream.close();
        return;
lbl73:
        // 1 sources

        catch (Exception var15_17) {
            // empty catch block
        }
    }

    private final JRcResponseBean getAnalysis(ResourceType resType, BinResource binary) throws AccessException {
        byte[] bin = null;
        BinResource data = null;
        JRcResponseBean ret = null;
        try {
            bin = binary.getBinary(0, 6);
            if (bin[0] != JRcProtocolDef.SEND_HEADER[0] || bin[1] != JRcProtocolDef.SEND_HEADER[1] || bin[2] != JRcProtocolDef.SEND_HEADER[2] || bin[3] != JRcProtocolDef.SEND_HEADER[3] || bin[4] != JRcProtocolDef.SEND_HEADER[4] || bin[5] != JRcProtocolDef.SEND_HEADER[5]) {
                throw new AccessException("\u53d7\u4fe1\u30d7\u30ed\u30c8\u30b3\u30eb\u30d8\u30c3\u30c0\u306f\u4e0d\u6b63\u3067\u3059");
            }
            bin = null;
            int pnt = 10;
            ret = new JRcResponseBean();
            ret.setMode((binary.get(pnt) & 1) == 1);
            int len = ConvertResourceParam.convertInt((int)(++pnt), (BinResource)binary);
            pnt += 4;
            if (len > 0) {
                ret.setCharset(ConvertResourceParam.convertString((int)pnt, (int)len, (BinResource)binary, (String)"UTF8"));
                pnt += len;
            } else {
                ret.setCharset("UTF8");
            }
            len = ConvertResourceParam.convertInt((int)pnt, (BinResource)binary);
            pnt += 4;
            if (len > 0) {
                ret.setMimeType(ConvertResourceParam.convertString((int)pnt, (int)len, (BinResource)binary, (String)"UTF8"));
                pnt += len;
            }
            ret.setResult(ConvertResourceParam.convertInt((int)pnt, (BinResource)binary));
            len = ConvertResourceParam.convertInt((int)(pnt += 4), (BinResource)binary);
            pnt += 4;
            if (len > 0) {
                ret.setResultMessage(ConvertResourceParam.convertString((int)pnt, (int)len, (BinResource)binary, (String)"UTF8"));
                pnt += len;
            }
            ret.setSessionID(ConvertResourceParam.convertLong((int)pnt, (BinResource)binary));
            len = ConvertResourceParam.convertInt((int)(pnt += 8), (BinResource)binary);
            pnt += 4;
            if (len > 0) {
                data = Resource.createBinResource((ResourceType)resType, (int)len);
                binary.getBinary(data, pnt, 0, len);
                ret.setBinary(data);
                pnt += len;
            }
        }
        catch (AccessException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new AccessException((Throwable)e);
        }
        return ret;
    }
}

