/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer;

import com.JRcServer.commons.exception.ConvertException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.ConvertResourceParam;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.util.ConvertParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class JRcParameter
implements Serializable {
    private static final long serialVersionUID;
    private static final String CHARSET = "UTF8";
    private int type = -1;
    private byte[] value = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.JRcParameter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID((String)clazz.getName());
    }

    public JRcParameter() {
    }

    public JRcParameter(int type, byte[] value) throws InputException {
        if (type != 1 && type != 2 && type != 3 && type != 4 && type != 5 && type != 6 && type != 7 && type != 8 && type != 9 && type != 10 || value == null || value.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.type = type;
        this.value = value;
    }

    protected final void finalize() throws Exception {
        this.type = -1;
        this.value = null;
    }

    public void setBinary(byte[] o) throws InputException {
        if (o == null || o.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.type = 1;
        this.value = o;
    }

    public byte[] getBinary() {
        return this.value;
    }

    public void setString(String o) throws InputException {
        if (o == null || o.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = o.getBytes(CHARSET);
            this.type = 2;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public String getString() throws ConvertException {
        String ret = null;
        try {
            ret = new String(this.value, CHARSET);
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setBoolean(Boolean o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertBoolean((boolean)o);
            this.type = 3;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Boolean getBoolean() throws ConvertException {
        Boolean ret = null;
        try {
            ret = new Boolean(ConvertParam.convertBoolean((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setShort(Short o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertShort((short)o);
            this.type = 4;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Short getShort() throws ConvertException {
        Short ret = null;
        try {
            ret = new Short(ConvertParam.convertShort((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setInteger(Integer o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertInt((int)o);
            this.type = 5;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Integer getInteger() throws ConvertException {
        Integer ret = null;
        try {
            ret = new Integer(ConvertParam.convertInt((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setLong(Long o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertLong((long)o);
            this.type = 6;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Long getLong() throws ConvertException {
        Long ret = null;
        try {
            ret = new Long(ConvertParam.convertLong((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setFloat(Float o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertFloat((float)o.floatValue());
            this.type = 7;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Float getFloat() throws ConvertException {
        Float ret = null;
        try {
            ret = new Float(ConvertParam.convertFloat((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setDouble(Double o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertDouble((double)o);
            this.type = 8;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Double getDouble() throws ConvertException {
        Double ret = null;
        try {
            ret = new Double(ConvertParam.convertDouble((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setDecimal(BigDecimal o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertDecimal((BigDecimal)o);
            this.type = 9;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public BigDecimal getDecimal() throws ConvertException {
        BigDecimal ret = null;
        try {
            ret = ConvertParam.convertDecimal((int)0, (byte[])this.value);
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public void setTimestamp(Date o) throws InputException {
        if (o == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.value = ConvertParam.convertLong((long)o.getTime());
            this.type = 10;
        }
        catch (Exception e) {
            throw new InputException((Throwable)e);
        }
    }

    public Date getTimestamp() throws ConvertException {
        Date ret = null;
        try {
            ret = new Date(ConvertParam.convertLong((int)0, (byte[])this.value));
        }
        catch (Exception e) {
            throw new ConvertException((Throwable)e);
        }
        return ret;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void exportOutputStream(OutputStream outputStream) throws IOException {
        void var2_2;
        int len;
        if (this.value == null || (len = this.value.length) <= 0) {
            return;
        }
        outputStream.write(this.type & 0xFF);
        outputStream.write(ConvertParam.convertInt((int)var2_2));
        outputStream.write(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public int exportResource(int pnt, BinResource binary) {
        void var3_4;
        int len;
        int ret = -1;
        if (pnt < 0 || binary == null) {
            return -1;
        }
        if (this.value == null || (len = this.value.length) <= 0) {
            return pnt;
        }
        binary.set(pnt, this.type & 0xFF);
        ConvertResourceParam.convertInt((BinResource)binary, (int)(++pnt), (int)var3_4);
        binary.setBinary(pnt += 4, this.value);
        ret = pnt + var3_4;
        return ret;
    }

    public int importResource(int pnt, BinResource binary) {
        int ret = -1;
        byte[] paramValue = null;
        if (binary == null || pnt < 0 || pnt >= binary.size()) {
            return -1;
        }
        try {
            int paramType = binary.get(pnt) & 0xFF;
            int len = ConvertResourceParam.convertInt((int)(++pnt), (BinResource)binary);
            if (len <= 0 || len + (pnt += 4) > binary.size()) {
                ret = -1;
            } else {
                paramValue = binary.getBinary(pnt, len);
                this.type = paramType;
                this.value = paramValue;
                ret = pnt + len;
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }
}

