/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.conv;

import com.JRcServer.commons.conv.Asc64Def;
import com.JRcServer.commons.conv.CodeCommon;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.NotEqualInfoException;

public class Asc64 {
    public static final byte[] rounds(String string) throws Exception {
        byte[] ret = null;
        if (string == null || string.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ret = string.getBytes("UTF8");
        int len = ret.length;
        int i = 0;
        while (i < len) {
            ret[i] = (byte)(ret[i] & 0x3F);
            ++i;
        }
        return ret;
    }

    public static final byte[] rounds(byte[] binary) throws InputException {
        byte[] ret = null;
        if (binary == null || binary.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ret = binary;
        int len = ret.length;
        int i = 0;
        while (i < len) {
            ret[i] = (byte)(ret[i] & 0x3F);
            ++i;
        }
        return ret;
    }

    public static final int[] convertAsciiByAsc64(byte[] asc) throws InputException {
        int len;
        int[] ret = null;
        if (asc == null || (len = asc.length) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ret = new int[len];
        try {
            int i = 0;
            while (i < len) {
                ret[i] = Asc64Def.convertASC_BY_ASC64((char)(asc[i] & 0xFF)) & 0x3F;
                ++i;
            }
        }
        catch (Exception e) {
            ret = null;
            throw new InputException(e);
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static final String convertAsc64ByAscii(int[] asc64) throws InputException, NotEqualInfoException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 95->98)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final byte[] convertAsc64ByEnc(int[] asc64) throws InputException {
        int len;
        byte[] ret = null;
        if (asc64 == null || (len = asc64.length) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int binLen = len * 2 / 8;
        binLen = len - binLen + 2;
        ret = new byte[binLen];
        int pause = ~(len & 0xFF) & 0xFF;
        pause = CodeCommon.flipBit0xff(pause);
        ret[0] = (byte)pause;
        pause = ~((len & 0xFF00) >> 8) & 0xFF;
        pause = CodeCommon.flipBit0xff(pause);
        ret[1] = (byte)pause;
        int i = 0;
        int j = 2;
        int k = 0;
        while (i < len) {
            pause = asc64[i];
            switch (k) {
                case 0: {
                    pause ^= 0xFFFFFFFF;
                    pause = CodeCommon.flipBit0x3f(pause);
                    ret[j] = (byte)(pause & 0x3F);
                    break;
                }
                case 1: {
                    int n = j++;
                    ret[n] = (byte)(ret[n] | (byte)((pause & 3) << 6 & 0xC0));
                    ret[j] = (byte)((pause & 0x3C) >> 2 & 0xF);
                    break;
                }
                case 2: {
                    pause = ~pause & 0x3F;
                    int n = j++;
                    ret[n] = (byte)(ret[n] | (byte)((pause & 0xF) << 4 & 0xF0));
                    ret[j] = (byte)((pause & 0x30) >> 4 & 3);
                    break;
                }
                case 3: {
                    pause = CodeCommon.flipBit0x3f(pause);
                    int n = j++;
                    ret[n] = (byte)(ret[n] | (byte)((pause & 0x3F) << 2 & 0xFC));
                    k = -1;
                }
            }
            ++i;
            ++k;
        }
        return ret;
    }

    public static final int[] convertEncByAsc64(byte[] enc) throws InputException {
        int len;
        int[] ret = null;
        if (enc == null || (len = enc.length) <= 2) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int pause = enc[0] & 0xFF;
        pause = ~pause & 0xFF;
        pause = CodeCommon.flipBit0xff(pause);
        int intLen = pause & 0xFF;
        pause = enc[1] & 0xFF;
        pause = ~pause & 0xFF;
        pause = CodeCommon.flipBit0xff(pause);
        ret = new int[intLen |= (pause & 0xFF) << 8 & 0xFF00];
        int i = 2;
        int j = 0;
        int k = 0;
        while (i < len) {
            byte binInt = enc[i];
            switch (k) {
                case 0: {
                    pause = binInt & 0x3F;
                    ret[j] = CodeCommon.flipBit0x3f(pause ^= 0xFFFFFFFF);
                    ++j;
                    pause = (binInt & 0xC0) >> 6 & 3;
                    break;
                }
                case 1: {
                    ret[j] = pause |= (binInt & 0xF) << 2 & 0x3C;
                    ++j;
                    pause = (binInt & 0xF0) >> 4 & 0xF;
                    break;
                }
                case 2: {
                    ret[j] = ~(pause |= (binInt & 3) << 4 & 0x30) & 0x3F;
                    pause = (binInt & 0xFC) >> 2 & 0x3F;
                    ret[++j] = CodeCommon.flipBit0x3f(pause);
                    ++j;
                    k = -1;
                }
            }
            ++i;
            ++k;
        }
        return ret;
    }

    public static final boolean isAsc64(String string) {
        boolean ret;
        try {
            int len = string.length();
            int i = 0;
            ret = true;
            while (i < len) {
                if (Asc64Def.convertASC_BY_ASC64(string.charAt(i)) == -1) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private Asc64() {
    }
}

