/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.FileAccessException;
import com.JRcServer.commons.io.RandomIO;
import com.JRcServer.commons.thread.Synchronized;

public class ArrayIO {
    private static final int PAUSE_LENGTH = 512;
    private RandomIO m_io = null;
    private final byte[] m_element = new byte[1];
    private final Synchronized m_sync = new Synchronized();

    public ArrayIO() {
    }

    public ArrayIO(String fileName) throws InputException, FileAccessException {
        try {
            this.create(fileName);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public ArrayIO(String fileName, int length) throws InputException, FileAccessException {
        try {
            this.create(fileName, length);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(String fileName) throws InputException, FileAccessException {
        try {
            this.clear();
            this.m_sync.create();
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_io = new RandomIO(fileName, false);
            }
        }
        catch (NullPointerException nul) {
            this.clear();
        }
        catch (InputException in) {
            this.clear();
            throw in;
        }
        catch (FileAccessException fa) {
            this.clear();
            throw fa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(String fileName, long length) throws InputException, FileAccessException {
        try {
            this.clear();
            this.m_sync.create();
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_io = new RandomIO(fileName, true);
                this.m_io.setLength(length);
            }
        }
        catch (NullPointerException nul) {
            this.clear();
        }
        catch (InputException in) {
            this.clear();
            throw in;
        }
        catch (FileAccessException fa) {
            this.clear();
            throw fa;
        }
    }

    public final void clear() {
        if (this.m_io != null) {
            this.m_io.close();
        }
        this.m_io = null;
        this.m_sync.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte getElement(int no) throws InputException {
        byte ret;
        byte[] tmp = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    tmp = this.m_element;
                    this.m_io.read(tmp, (long)no);
                    ret = tmp[0];
                }
            }
            catch (NullPointerException nul) {
                ret = 0;
            }
            catch (InputException in) {
                throw in;
            }
            catch (FileAccessException fa) {
                throw new InputException(fa);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var5_10 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setElement(byte info, int no) throws InputException {
        byte[] tmp = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    tmp = this.m_element;
                    tmp[0] = info;
                    this.m_io.write(tmp, no);
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InputException in) {
                throw in;
            }
            catch (FileAccessException fa) {
                throw new InputException(fa);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var5_10 = null;
        }
        tmp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] get(int point, int size) throws InputException {
        byte[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = new byte[size];
                this.m_io.read(ret, (long)point);
            }
        }
        catch (NullPointerException nul) {
            ret = null;
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            ret = null;
            throw new InputException(ai);
        }
        catch (InputException in) {
            ret = null;
            throw in;
        }
        catch (FileAccessException fa) {
            ret = null;
            throw new InputException(fa);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int get(byte[] binary, int point) throws InputException {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_io.read(binary, (long)point);
            }
        }
        catch (NullPointerException nul) {
            ret = 0;
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw new InputException(ai);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw new InputException(fa);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int get(byte[] binary, int point, int length) throws InputException {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_io.read(binary, point, length);
            }
        }
        catch (NullPointerException nul) {
            ret = 0;
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw new InputException(ai);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw new InputException(fa);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(byte[] binary, int point) throws InputException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_io.write(binary, point);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw new InputException(fa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(byte[] binary, int point, int length) throws InputException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_io.write(binary, point, 0, length);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw new InputException(fa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean equals(byte[] binary, int point) throws InputException {
        boolean ret;
        byte[] tmp = null;
        try {
            try {
                int len;
                Object object = this.m_sync.get();
                synchronized (object) {
                    len = binary.length;
                    tmp = this.get(point, len);
                }
                int i = 0;
                ret = true;
                while (i < len) {
                    block10: {
                        if (binary[i] == tmp[i]) break block10;
                        ret = false;
                        break;
                    }
                    ++i;
                }
            }
            catch (NullPointerException nul) {
                ret = false;
            }
            catch (InputException in) {
                throw in;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLength() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_io.getLength();
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLength(long newLength) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_io.setLength(newLength);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getFileName() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_io.getFileName();
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_io.isOpen();
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void arraycopy(ArrayIO src, int srcPos, ArrayIO dest, int destPos, int length) throws InputException {
        byte[] tmp = null;
        try {
            int pauseLength = 512;
            tmp = new byte[pauseLength];
            int len = length / pauseLength;
            int etc = length % pauseLength;
            int i = 0;
            int next = 0;
            while (true) {
                int getLength;
                block7: {
                    if (i < len) break block7;
                    if (etc != 0) {
                        getLength = src.get(tmp, srcPos + next, etc);
                        dest.set(tmp, destPos + next, getLength);
                    }
                    break;
                }
                getLength = src.get(tmp, srcPos + next);
                dest.set(tmp, destPos + next, getLength);
                next += getLength;
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        tmp = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void arraycopy(byte[] src, int srcPos, ArrayIO dest, int destPos, int length) throws InputException {
        byte[] tmp = null;
        try {
            try {
                tmp = new byte[length];
                System.arraycopy(src, srcPos, tmp, 0, length);
                dest.set(tmp, destPos);
            }
            catch (IndexOutOfBoundsException ind) {
                throw new InputException(ind);
            }
            catch (NullPointerException nul) {
                throw new InputException(nul);
            }
            catch (InputException in) {
                throw in;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        tmp = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void arraycopy(ArrayIO src, int srcPos, byte[] dest, int destPos, int length) throws InputException {
        byte[] tmp = null;
        try {
            try {
                tmp = src.get(srcPos, length);
                System.arraycopy(tmp, 0, dest, destPos, length);
            }
            catch (IndexOutOfBoundsException ind) {
                throw new InputException(ind);
            }
            catch (NullPointerException nul) {
                throw new InputException(nul);
            }
            catch (InputException in) {
                throw in;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        tmp = null;
    }
}

