/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.FileAccessException;
import com.JRcServer.commons.io.ReadEnterIndex;
import com.JRcServer.commons.util.convert.ConvertToIndexNo;
import com.JRcServer.commons.util.read.ReadCsv;
import com.JRcServer.commons.util.read.ReadElement;

public class CatCSV {
    private final ReadElement m_oneLine = new ReadElement();
    private ReadEnterIndex m_index = null;
    private ReadCsv m_csv = null;
    private int m_next = -1;

    private CatCSV() {
    }

    public CatCSV(String name) throws InputException, FileAccessException {
        this(name, null);
    }

    public CatCSV(String name, String catCd) throws InputException, FileAccessException {
        this.m_index = new ReadEnterIndex(true, name);
        this.m_csv = new ReadCsv(this.m_index, catCd);
    }

    public CatCSV(String name, String catCd, String charset) throws InputException, FileAccessException {
        this.m_index = new ReadEnterIndex(true, name, charset);
        this.m_csv = new ReadCsv(this.m_index, catCd);
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() {
        if (this.m_csv != null) {
            this.m_csv.clear();
        }
        this.m_csv = null;
        if (this.m_index != null) {
            this.m_index.close();
        }
        this.m_index = null;
        this.m_oneLine.clear();
        this.m_next = -1;
    }

    public final boolean next() {
        boolean ret;
        try {
            ++this.m_next;
            this.m_oneLine.clear();
            this.m_csv.getIndex(this.m_next, this.m_oneLine);
            ret = true;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public final boolean setLine(int no) {
        boolean ret;
        try {
            this.m_next = no;
            this.m_oneLine.clear();
            this.m_csv.getIndex(this.m_next, this.m_oneLine);
            ret = true;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public final ConvertToIndexNo getResult() {
        return this.m_oneLine;
    }

    public final int getReadLine() {
        return this.m_next;
    }

    public final int getMaxLine() {
        int ret;
        try {
            ret = this.m_index.size();
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public final boolean isUse() {
        return this.m_csv != null;
    }
}

