/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.FileAccessException;
import com.JRcServer.commons.io.IOCom;
import com.JRcServer.commons.io.RandomInputStream;
import com.JRcServer.commons.io.RandomOutputStream;
import com.JRcServer.commons.io.env.EnvRandomAccessFile;
import com.JRcServer.commons.thread.Synchronized;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RandomIO {
    private static final int ONE_BUFFER_LENGTH = 65536;
    private static final long ONE_BUFFER_MASK = 65535L;
    private static final long ONE_BUFFER_SHIFT = 16L;
    private EnvRandomAccessFile m_fp = null;
    private String m_name = null;
    private final Synchronized m_sync = new Synchronized();
    private final byte[] m_buf = new byte[65536];

    public RandomIO() {
    }

    public RandomIO(String fileName, boolean newFlg) throws FileAccessException, InputException {
        try {
            this.open(fileName, newFlg);
        }
        catch (FileAccessException fa) {
            throw fa;
        }
        catch (InputException in) {
            throw in;
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(String fileName, boolean newFlg) throws FileAccessException, InputException {
        if (fileName == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.close();
            this.m_sync.create();
            Object object = this.m_sync.get();
            synchronized (object) {
                if (newFlg && IOCom.isFileExists(fileName)) {
                    IOCom.deleteFile(fileName);
                }
                this.m_fp = new EnvRandomAccessFile(fileName, "rw");
                long len = this.m_fp.length();
                if (!newFlg && len > 0L) {
                    this.m_fp.seek(len);
                }
                this.m_name = fileName;
            }
        }
        catch (NullPointerException t) {
            this.close();
        }
        catch (IllegalArgumentException ia) {
            this.close();
            throw new FileAccessException(ia);
        }
        catch (FileNotFoundException fno) {
            this.close();
            throw new FileAccessException(fno);
        }
        catch (AccessException ac) {
            this.close();
            throw new FileAccessException(ac);
        }
        catch (IOException io) {
            this.close();
            throw new FileAccessException(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                try {
                    this.m_fp.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_fp = null;
                this.m_name = null;
            }
        }
        catch (Exception io) {
            this.m_fp = null;
            this.m_name = null;
        }
        this.m_sync.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] read() throws InputException, FileAccessException {
        byte[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.read((int)this.m_fp.length());
            }
        }
        catch (NullPointerException nul) {
            ret = null;
        }
        catch (InputException in) {
            ret = null;
            throw in;
        }
        catch (FileAccessException fa) {
            ret = null;
            throw fa;
        }
        catch (IOException io) {
            ret = null;
            throw new FileAccessException(io);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] read(int size) throws InputException, FileAccessException {
        byte[] tmp = null;
        byte[] ret = null;
        if (size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    tmp = new byte[size];
                    int len = this.m_fp.read(tmp);
                    if (len != size) {
                        if (len <= 0) {
                            ret = null;
                        } else {
                            ret = new byte[len];
                            System.arraycopy(tmp, 0, ret, 0, len);
                        }
                    } else {
                        ret = tmp;
                    }
                }
            }
            catch (NullPointerException nul) {
                ret = null;
            }
            catch (IOException io) {
                ret = null;
                throw new FileAccessException(io);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(byte[] out) throws InputException, FileAccessException {
        int ret;
        byte[] tmp = null;
        if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        int outLen = out.length;
        if (outLen <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    ret = this.m_fp.read(out);
                }
            }
            catch (NullPointerException nul) {
                ret = 0;
            }
            catch (IOException io) {
                throw new FileAccessException(io);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] read(long point, int size) throws InputException, FileAccessException {
        byte[] tmp = null;
        byte[] ret = null;
        if (point < 0L) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    tmp = new byte[size];
                    this.m_fp.seek(point);
                    int len = this.m_fp.read(tmp);
                    if (len != size) {
                        if (len <= 0) {
                            ret = null;
                        } else {
                            ret = new byte[len];
                            System.arraycopy(tmp, 0, ret, 0, len);
                        }
                    } else {
                        ret = tmp;
                    }
                }
            }
            catch (NullPointerException nul) {
                ret = null;
            }
            catch (IOException io) {
                ret = null;
                throw new FileAccessException(io);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(byte[] out, long point) throws InputException, FileAccessException {
        int ret;
        byte[] tmp = null;
        if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        int outLen = out.length;
        if (outLen <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (point < 0L) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.m_fp.seek(point);
                    ret = this.m_fp.read(out);
                }
            }
            catch (NullPointerException nul) {
                ret = 0;
            }
            catch (IOException io) {
                throw new FileAccessException(io);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var10_11 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(byte[] out, long point, int offset) throws InputException, FileAccessException {
        int ret;
        byte[] tmp = null;
        if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        int outLen = out.length;
        if (outLen <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (point < 0L) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (offset < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    int len = outLen - offset;
                    this.m_fp.seek(point);
                    ret = this.m_fp.read(out, offset, len);
                }
            }
            catch (NullPointerException nul) {
                ret = 0;
            }
            catch (IOException io) {
                throw new FileAccessException(io);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var12_13 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(byte[] out, long point, int offset, int length) throws InputException, FileAccessException {
        int ret;
        int outLen;
        byte[] tmp = null;
        if (out == null || (outLen = out.length) <= 0 || point < 0L || offset < 0 || length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.seek(point);
                ret = this.m_fp.read(out, offset, length);
            }
        }
        catch (NullPointerException nul) {
            ret = 0;
        }
        catch (IOException io) {
            throw new FileAccessException(io);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] binary) throws InputException, FileAccessException {
        if (binary == null || binary.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.write(binary);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException io) {
            throw new FileAccessException(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] binary, int offset, int size) throws InputException, FileAccessException {
        if (binary == null || binary.length <= 0 || offset < 0 || size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.write(binary, offset, size);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException io) {
            throw new FileAccessException(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] binary, long point) throws InputException, FileAccessException {
        if (binary == null || binary.length <= 0 || point < 0L) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.seek(point);
                this.m_fp.write(binary);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException io) {
            throw new FileAccessException(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] binary, long point, int offset, int size) throws InputException, FileAccessException {
        if (binary == null || binary.length <= 0 || offset < 0 || size <= 0 || point < 0L) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.seek(point);
                this.m_fp.write(binary, offset, size);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException io) {
            throw new FileAccessException(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPoint(long point) throws FileAccessException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.seek(point);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException io) {
            throw new FileAccessException(io);
        }
    }

    /*
     * Exception decompiling
     */
    public final void setLength(long length) throws FileAccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 200->204)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getPoint() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_fp.getFilePointer();
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLength() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_fp.length();
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getFileName() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_name;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getInputStream(long seek) {
        RandomInputStream ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = new RandomInputStream(this, seek, this.getLength());
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InputStream getInputStream(long seek, long length) {
        RandomInputStream ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = new RandomInputStream(this, seek, length);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OutputStream getOutputStream(long seek) {
        RandomOutputStream ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = new RandomOutputStream(this);
                ret.setSeek(seek);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    public final Synchronized getSynchronized() {
        return this.m_sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_fp != null;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }
}

