/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.RandomIO;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.array.LongArray;
import java.io.IOException;
import java.io.InputStream;

class RandomInputStream
extends InputStream {
    private static final int READ_BUFFER = 1;
    private RandomIO m_fp = null;
    private long m_seek = 0L;
    private long m_length = 0L;
    private final LongArray m_mark = new LongArray();
    private final byte[] m_buf = new byte[1];
    private Synchronized m_sync = null;

    private RandomInputStream() {
    }

    public RandomInputStream(RandomIO fp) throws InputException {
        if (fp == null || !fp.isOpen()) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync = fp.getSynchronized();
        this.m_fp = fp;
        this.m_length = fp.getLength();
    }

    public RandomInputStream(RandomIO fp, long offset, long length) throws InputException {
        if (fp == null || !fp.isOpen()) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync = fp.getSynchronized();
        this.m_fp = fp;
        this.m_seek = offset;
        this.m_length = length;
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() {
        this.m_fp = null;
        this.m_sync = null;
        this.m_seek = 0L;
        this.m_length = 0L;
        this.m_mark.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read() throws IOException {
        int ret;
        byte[] buf = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_length <= this.m_seek) {
                    ret = -1;
                } else {
                    buf = this.m_buf;
                    int len = this.m_fp.read(buf, this.m_seek, 0, 1);
                    if (len < 0) {
                        ret = -1;
                    } else {
                        ret = buf[0] & 0xFF;
                        ++this.m_seek;
                    }
                }
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public final int read(byte[] binary) throws IOException {
        return this.read(binary, 0, binary.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(byte[] binary, int offset, int length) throws IOException {
        int ret;
        if ((offset | length | offset + length | binary.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (length == 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_length <= this.m_seek + (long)length ? (this.m_length <= this.m_seek ? -1 : this.m_fp.read(binary, this.m_seek, offset, (int)(this.m_length - this.m_seek))) : this.m_fp.read(binary, this.m_seek, offset, length);
                this.m_seek += (long)(ret <= 0 ? 0 : ret);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long skip(long n) throws IOException {
        long ret;
        block7: {
            ret = 0L;
            try {
                if (n <= 0L) break block7;
                Object object = this.m_sync.get();
                synchronized (object) {
                    long seek = this.m_seek;
                    long length = this.m_length;
                    if (length <= n + seek) {
                        ret = length - seek;
                        this.m_seek = length;
                    } else {
                        ret = n;
                        this.m_seek += n;
                    }
                }
            }
            catch (Exception t) {
                ret = 0L;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int available() throws IOException {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = (int)(this.m_length - this.m_seek);
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mark(int offset) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                long seek = this.m_seek + (long)offset;
                if (seek >= 0L && seek < this.m_length) {
                    this.m_mark.add(seek);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() throws IOException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_mark.size() == 0) {
                    throw new IOException("\u30de\u30fc\u30af\u3057\u305f\u4f4d\u7f6e\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                this.m_seek = this.m_mark.remove(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSeek() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_seek;
            }
        }
        catch (Exception t) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLength() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_length;
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    public final Synchronized getSynchronized() {
        return this.m_sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMarkSize() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_mark.size();
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }
}

