/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.exception.BaseException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.RandomIO;
import com.JRcServer.commons.thread.Synchronized;
import java.io.IOException;
import java.io.OutputStream;

class RandomOutputStream
extends OutputStream {
    private static final int WRITE_BUFFER = 1024;
    private static final int WRITE_MASK = -1024;
    private static final int WRITE_SHIFT = 10;
    private RandomIO m_fp = null;
    private long m_seek = 0L;
    private final byte[] m_buf = new byte[1024];
    private Synchronized m_sync = null;

    private RandomOutputStream() {
    }

    public RandomOutputStream(RandomIO fp) throws InputException {
        if (fp == null || !fp.isOpen()) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_fp = fp;
        this.m_sync = fp.getSynchronized();
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() {
        this.m_fp = null;
        this.m_sync = null;
        this.m_seek = 0L;
    }

    public final void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(int b) throws IOException {
        byte[] buf = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                buf = this.m_buf;
                buf[0] = (byte)(b & 0xFF);
                this.m_fp.write(buf, this.m_seek, 0, 1);
                ++this.m_seek;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] binary, int offset, int length) throws IOException {
        if ((offset | length | offset + length | binary.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (length == 0) {
            return;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.write(binary, this.m_seek, offset, length);
                this.m_seek += (long)length;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (BaseException be) {
            throw new IOException(be.getMessage());
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSeek(long seek) {
        if (seek < 0L) {
            return;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_seek = seek;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSeek() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_seek;
            }
        }
        catch (Exception t) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLength() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_fp.getLength();
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    public final Synchronized getSynchronized() {
        return this.m_sync;
    }
}

