/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io;

import com.JRcServer.commons.def.BaseDef;
import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.FileAccessException;
import com.JRcServer.commons.io.RandomIO;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.ReadIndex;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ReadEnterIndex
implements ReadIndex {
    private static final int READ_FILE_LENGTH = 1024;
    private static final int TYPE_ENTER_WINDOWS = 1;
    private static final int TYPE_ENTER_UNIX = 2;
    private static final int TYPE_ENTER_MACINTOSH = 3;
    private static final int TYPE_ENTER_NOT = -1;
    private long[] m_index = null;
    private int[] m_indexLength = null;
    private String m_name = null;
    private String m_charset = null;
    private boolean m_mode = false;
    private boolean m_getType = true;
    private RandomIO m_fp = null;
    private final Synchronized m_sync = new Synchronized();

    public ReadEnterIndex() {
    }

    public ReadEnterIndex(String name) throws InputException, FileAccessException {
        try {
            this.open(false, true, name, BaseDef.THIS_CHARSET);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public ReadEnterIndex(boolean mode, String name) throws InputException, FileAccessException {
        try {
            this.open(mode, true, name, BaseDef.THIS_CHARSET);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public ReadEnterIndex(String name, String charset) throws InputException, FileAccessException {
        try {
            this.open(false, true, name, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public ReadEnterIndex(boolean mode, String name, String charset) throws InputException, FileAccessException {
        try {
            this.open(mode, true, name, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public ReadEnterIndex(boolean mode, boolean getType, String name, String charset) throws InputException, FileAccessException {
        try {
            this.open(mode, getType, name, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void open(String name) throws InputException, FileAccessException {
        try {
            this.open(false, true, name, BaseDef.THIS_CHARSET);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public final void open(boolean mode, String name) throws InputException, FileAccessException {
        try {
            this.open(mode, true, name, BaseDef.THIS_CHARSET);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public final void open(String name, String charset) throws InputException, FileAccessException {
        try {
            this.open(false, true, name, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    public final void open(boolean mode, String name, String charset) throws InputException, FileAccessException {
        try {
            this.open(mode, true, name, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (FileAccessException fa) {
            throw fa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(boolean mode, boolean getType, String name, String charset) throws InputException, FileAccessException {
        if (name == null || charset == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp = new RandomIO(name, false);
                this.readIndex(this.m_fp, name, charset);
                if (!mode) {
                    this.m_fp.close();
                    this.m_fp = null;
                }
                this.m_mode = mode;
                this.m_getType = getType;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final void close() {
        this.m_sync.clear();
        try {
            this.m_fp.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_index = null;
        this.m_indexLength = null;
        this.m_name = null;
        this.m_charset = null;
        this.m_fp = null;
        this.m_mode = false;
        this.m_getType = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getIndex(int no) throws InputException, AccessException {
        Object ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (no < 0 || no >= this.m_index.length) {
                    throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
                }
                try {
                    ret = this.getIndexByData(this.m_mode, this.m_getType, this.m_index[no], this.m_indexLength[no]);
                }
                catch (IndexOutOfBoundsException io) {
                    throw new AccessException(io);
                }
                catch (FileAccessException fa) {
                    throw fa;
                }
            }
        }
        catch (NullPointerException nul) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_index.length;
            }
        }
        catch (NullPointerException nul) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isIndex() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_name != null;
            }
        }
        catch (NullPointerException nul) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readIndex(RandomIO fp, String name, String charset) throws FileAccessException {
        block37: {
            block36: {
                input = null;
                list = null;
                code = null;
                winEnter = null;
                unixEnter = null;
                macEnter = null;
                index = null;
                indexLen = null;
                list = new ArrayList<Long>();
                code = new byte[1024];
                try {
                    try {
                        winEnter = "\r\n".getBytes(charset);
                        unixEnter = "\n".getBytes(charset);
                        macEnter = "\r".getBytes(charset);
                        winEnterLen = winEnter.length;
                        unixEnterLen = unixEnter.length;
                        macEnterLen = macEnter.length;
                        input = new BufferedInputStream(fp.getInputStream(0L));
                        list.add(new Long(0L));
                        enterType = -1;
                        flg = false;
                        fileCount = 0L;
                        entLength = 0;
                        seekFirst = 0L;
                        fixEnter = 0;
                        enterCnt = 0;
                        block14: while (true) {
                            if ((len = input.read(code)) == -1) {
                                try {
                                    input.close();
                                }
                                catch (Exception var29_25) {
                                    // empty catch block
                                }
                                break;
                            }
                            i = 0;
                            j = seekFirst;
                            while (true) {
                                if (i >= len) {
                                    seekFirst += (long)len;
                                    continue block14;
                                }
                                flg = false;
                                ++fileCount;
                                if (enterType == 3 && code[i] == winEnter[macEnterLen]) {
                                    fixEnter = winEnterLen;
                                    entLength = winEnterLen;
                                    enterType = 1;
                                    flg = true;
                                } else {
                                    if (enterType != -1) {
                                        list.add(new Long(j - (long)fixEnter));
                                        list.add(new Long(j));
                                        enterCnt = 0;
                                        fixEnter = 0;
                                        enterType = -1;
                                        flg = true;
                                    }
                                    if (code[i] == macEnter[enterCnt]) {
                                        if (macEnterLen == ++enterCnt) {
                                            fixEnter = macEnterLen;
                                            entLength = macEnterLen;
                                            enterType = 3;
                                            flg = true;
                                        }
                                    } else if (code[i] == unixEnter[enterCnt]) {
                                        if (unixEnterLen == ++enterCnt) {
                                            fixEnter = unixEnterLen;
                                            entLength = unixEnterLen;
                                            enterType = 2;
                                            flg = true;
                                        }
                                    } else if (code[i] == winEnter[enterCnt]) {
                                        if (winEnterLen == ++enterCnt) {
                                            fixEnter = winEnterLen;
                                            entLength = winEnterLen;
                                            enterType = 1;
                                            flg = true;
                                        }
                                    } else {
                                        enterCnt = 0;
                                        fixEnter = 0;
                                        enterType = -1;
                                    }
                                }
                                ++i;
                                ++j;
                            }
                            break;
                        }
                        if (flg) {
                            list.add(new Long(fileCount - (long)entLength));
                        } else {
                            list.add(new Long(fileCount));
                        }
                        len = list.size() / 2;
                        index = new long[len];
                        indexLen = new int[len];
                        i = 0;
                        k = 0;
                        while (true) {
                            block35: {
                                if (i < len) break block35;
                                this.m_index = index;
                                this.m_indexLength = indexLen;
                                this.m_name = name;
                                this.m_charset = charset;
                                break;
                            }
                            index[i] = (Long)list.get(k);
                            indexLen[i] = (int)((Long)list.get(k + 1) - index[i]);
                            ++i;
                            k += 2;
                        }
                    }
                    catch (IOException io) {
                        throw new FileAccessException(io);
                    }
                    catch (Exception t) {
                        throw new FileAccessException(t);
                    }
                }
                catch (Throwable var31_29) {
                    var30_30 = null;
                    try {
                        input.close();
                    }
                    catch (Exception var32_32) {
                        // empty catch block
                    }
                    try {
                        list.clear();
                    }
                    catch (Exception var32_32) {
                        // empty catch block
                    }
                    input = null;
                    list = null;
                    code = null;
                    winEnter = null;
                    unixEnter = null;
                    macEnter = null;
                    index = null;
                    indexLen = null;
                    throw var31_29;
                }
                {
                    var30_31 = null;
                }
                ** try [egrp 3[TRYBLOCK] [5 : 625->633)] { 
lbl141:
                // 1 sources

                input.close();
                break block36;
lbl143:
                // 1 sources

                catch (Exception var32_33) {
                    // empty catch block
                }
            }
            ** try [egrp 4[TRYBLOCK] [6 : 635->643)] { 
lbl147:
            // 1 sources

            list.clear();
            break block37;
lbl149:
            // 1 sources

            catch (Exception var32_33) {
                // empty catch block
            }
        }
        input = null;
        list = null;
        code = null;
        winEnter = null;
        unixEnter = null;
        macEnter = null;
        index = null;
        indexLen = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object getIndexByData(boolean mode, boolean getType, long addr, int length) throws FileAccessException {
        Object ret = null;
        byte[] binary = null;
        RandomIO fp = null;
        if ((long)length <= 0L) {
            if (!getType) return new byte[0];
            return "";
        }
        try {
            try {
                fp = !mode ? new RandomIO(this.m_name, false) : this.m_fp;
                binary = new byte[length];
                fp.read(binary, addr);
                ret = getType ? new String(binary, this.m_charset) : (Object)binary;
            }
            catch (Exception t) {
                throw new FileAccessException(t);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!mode && fp != null) {
                fp.close();
            }
            fp = null;
            binary = null;
            throw throwable;
        }
        {
            Object var10_11 = null;
            if (!mode && fp != null) {
                fp.close();
            }
            fp = null;
        }
        binary = null;
        return ret;
    }
}

