/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io.env;

import com.JRcServer.commons.io.IODef;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EnvFileInputStream
extends InputStream {
    private FileInputStream m_in = null;

    private EnvFileInputStream() {
    }

    public EnvFileInputStream(File file) throws IOException {
        this.m_in = new FileInputStream(file);
    }

    public EnvFileInputStream(FileDescriptor fdObj) {
        this.m_in = new FileInputStream(fdObj);
    }

    public EnvFileInputStream(String name) throws IOException {
        this.m_in = new FileInputStream(IODef.convertEnvName(name));
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() throws IOException {
        if (this.m_in != null) {
            this.m_in.close();
        }
        this.m_in = null;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.m_in != null ? this.m_in.getFD() : null;
    }

    public final int read() throws IOException {
        return this.m_in != null ? this.m_in.read() : -1;
    }

    public final int read(byte[] binary) throws IOException {
        return this.m_in != null ? this.m_in.read(binary) : -1;
    }

    public final int read(byte[] binary, int offset, int length) throws IOException {
        return this.m_in != null ? this.m_in.read(binary, offset, length) : -1;
    }

    public final long skip(long n) throws IOException {
        return this.m_in != null ? this.m_in.skip(n) : -1L;
    }

    public final int available() throws IOException {
        return this.m_in != null ? this.m_in.available() : -1;
    }

    public final void mark(int offset) {
        if (this.m_in != null) {
            this.m_in.mark(offset);
        }
    }

    public final void reset() throws IOException {
        if (this.m_in != null) {
            this.m_in.reset();
        }
    }

    public final boolean markSupported() {
        return this.m_in != null ? this.m_in.markSupported() : false;
    }
}

