/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.io.env;

import com.JRcServer.commons.io.IODef;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EnvFileOutputStream
extends OutputStream {
    private FileOutputStream m_out = null;

    private EnvFileOutputStream() {
    }

    public EnvFileOutputStream(File file) throws IOException {
        this.m_out = new FileOutputStream(file);
    }

    public EnvFileOutputStream(FileDescriptor fdObj) {
        this.m_out = new FileOutputStream(fdObj);
    }

    public EnvFileOutputStream(String name) throws IOException {
        this.m_out = new FileOutputStream(IODef.convertEnvName(name));
    }

    public EnvFileOutputStream(String name, boolean append) throws IOException {
        this.m_out = new FileOutputStream(IODef.convertEnvName(name), append);
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() throws IOException {
        if (this.m_out != null) {
            this.m_out.close();
        }
    }

    public final void flush() throws IOException {
        if (this.m_out != null) {
            this.m_out.flush();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.m_out != null ? this.m_out.getFD() : null;
    }

    public final void write(int b) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(b);
        }
    }

    public final void write(byte[] b) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(b);
        }
    }

    public final void write(byte[] binary, int offset, int length) throws IOException {
        if (this.m_out != null) {
            this.m_out.write(binary, offset, length);
        }
    }
}

