/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.thread.Synchronized;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ConnectAddress {
    private static final String NOT_IPADDR = "NO-ADDRESS";
    private static final String NOT_PORT = "0";
    private static final String ST_SETCD = " (";
    private static final String ED_SETCD = ")";
    private InetAddress m_address = null;
    private int m_port = -1;
    private final Synchronized m_sync = new Synchronized();

    public ConnectAddress() {
    }

    public ConnectAddress(InetAddress address, int port) throws InputException {
        this.create(address, port);
    }

    public ConnectAddress(String host, int port) throws InputException {
        this.create(host, port);
    }

    public ConnectAddress(ConnectAddress obj) throws InputException {
        this.create(obj);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(InetAddress address, int port) throws InputException {
        if (address == null || port < 0 || port > 65535) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.clear();
            this.m_sync.create();
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_address = InetAddress.getByName(address.getHostAddress());
                this.m_port = port;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException il) {
            throw new InputException(il);
        }
        catch (UnknownHostException uh) {
            throw new InputException(uh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(String host, int port) throws InputException {
        if (host == null || port < 0 || port > 65535) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.clear();
            this.m_sync.create();
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_address = InetAddress.getByName(host);
                this.m_port = port;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException il) {
            throw new InputException(il);
        }
        catch (UnknownHostException uh) {
            throw new InputException(uh);
        }
    }

    public final void create(ConnectAddress obj) throws InputException {
        try {
            this.create(obj.getAddress(), obj.getPort());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InputException in) {
            throw in;
        }
    }

    public final void clear() {
        this.m_sync.clear();
        this.m_address = null;
        this.m_port = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InetAddress getAddress() {
        InetAddress ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = InetAddress.getByName(this.m_address.getHostAddress());
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPort() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_port;
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public final String toString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 119->122)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_address == null || this.m_port < 0;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }
}

