/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.NetConfig;
import com.JRcServer.commons.thread.Synchronized;

public abstract class NetAgentElement {
    protected boolean m_useFlg = false;
    protected boolean m_downFlg = true;
    private String m_adapter = null;
    protected String m_localAddress = null;
    protected final Synchronized m_sync = new Synchronized();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startAgent() {
        this.exitAgent();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_useFlg = true;
            }
        }
        catch (Exception t) {
            this.exitAgent();
        }
    }

    protected void exitAgent() {
        try {
            this.down();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        this.m_useFlg = false;
        this.m_downFlg = true;
        this.m_adapter = null;
        this.m_localAddress = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAdapter(String name) throws InputException {
        if (name == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_adapter = name;
            }
        }
        catch (Exception t) {
            this.m_adapter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restore(String addr) throws ExecutionException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_downFlg = false;
                this.m_localAddress = addr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void down() throws ExecutionException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_downFlg = true;
                if (NetConfig.getInstance().useObject()) {
                    this.m_localAddress = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLocalAddress() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_localAddress;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAdapter() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_adapter;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_useFlg;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDown() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_downFlg;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }
}

