/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetDef {
    public static final String DEF_CHARSET = "UTF8";
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final String NOT_ADDR = "0.0.0.0";
    public static final int PORT_MIN = 0;
    public static final int PORT_MAX = 65535;
    public static final int PORT_REG_MIN = 1024;
    public static final int PORT_REG_MAX = 49151;
    public static final int PORT_PRI_MIN = 49152;
    public static final int PORT_PRI_MAX = 65535;
    public static final int DEF_BUFLEN = 65535;
    public static final int UDP_MAXBYTE = 65535;
    public static final double NETWORK_SEND_BUFFER = 0.75;
    public static final double NETWORK_RECEIVE_BUFFER = 1.25;

    private NetDef() {
    }

    public static final InetAddress getByAddress(byte[] addr) throws UnknownHostException {
        int len;
        StringBuffer buf = null;
        InetAddress ret = null;
        if (addr == null || (len = addr.length) <= 0) {
            throw new UnknownHostException("\u5bfe\u8c61\u306e\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (len == 4) {
            buf = new StringBuffer();
            buf.append(addr[0] & 0xFF);
            buf.append(".");
            buf.append(addr[1] & 0xFF);
            buf.append(".");
            buf.append(addr[2] & 0xFF);
            buf.append(".");
            buf.append(addr[3] & 0xFF);
            ret = InetAddress.getByName(buf.toString());
            buf = null;
        } else if (len == 16) {
            int lenJ = (len /= 2) - 1;
            int i = 0;
            while (i < len) {
                buf.append(Integer.toHexString(addr[i << 1] << 8 & 0xFF00 | addr[(i << 1) + 1] & 0xFF));
                if (i < lenJ) {
                    buf.append(":");
                }
                ++i;
            }
            ret = InetAddress.getByName(buf.toString());
            buf = null;
        } else {
            throw new UnknownHostException("\u5bfe\u8c61\u306e\u6761\u4ef6\u306f\u30a2\u30c9\u30ec\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        return ret;
    }
}

