/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.UnsupportException;
import com.JRcServer.commons.net.NetConfig;
import com.JRcServer.commons.net.NowAddressThread;
import com.JRcServer.commons.util.CharTable;
import java.net.InetAddress;

public class NowAddress {
    private final NowAddressThread m_thread = new NowAddressThread();
    private static final NowAddress SNGL = new NowAddress();
    private volatile boolean m_createFlg = false;

    private NowAddress() {
    }

    protected final void finalize() throws Exception {
        try {
            this.m_thread.clear();
            this.m_createFlg = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final NowAddress getInstance() {
        SNGL.create();
        return SNGL;
    }

    public final void flush() {
        this.m_thread.flush();
    }

    public final void setInterval(int interval) throws InputException {
        this.m_thread.setInterval(interval);
    }

    public final int getInterval() {
        return this.m_thread.getInterval();
    }

    public final String getLocalAddress() {
        return (String)this.m_thread.getNow(1);
    }

    public final String getLocalHost() {
        return (String)this.m_thread.getNow(2);
    }

    public final String[] getAllLocalIpAddress() {
        return (String[])this.m_thread.getNow(3);
    }

    public final String getHostName(String addr) {
        String ret = null;
        CharTable tbl = null;
        if (addr == null) {
            return null;
        }
        tbl = (CharTable)this.m_thread.getNow(4);
        if (tbl == null) {
            return null;
        }
        ret = (String)tbl.get(addr);
        tbl = null;
        return ret;
    }

    public final String getLocalAdapter() throws UnsupportException {
        if (!NetConfig.getInstance().useObject()) {
            throw new UnsupportException("\u5a92\u4f53\u540d\u53d6\u5f97\u306f\u3053\u306eOS\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return NetConfig.getInstance().getAddressByAdapter(this.getLocalAddress());
    }

    public final String[] getAllLocalAdapter() throws UnsupportException {
        String[] addrs = null;
        String[] ret = null;
        if (!NetConfig.getInstance().useObject()) {
            throw new UnsupportException("\u5a92\u4f53\u540d\u53d6\u5f97\u306f\u3053\u306eOS\u3067\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        addrs = this.getAllLocalIpAddress();
        if (addrs != null) {
            int len = addrs.length;
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = NetConfig.getInstance().getAddressByAdapter(addrs[i]);
                addrs[i] = null;
                ++i;
            }
            addrs = null;
        } else {
            ret = null;
        }
        return ret;
    }

    public final boolean isUse(InetAddress addr) {
        boolean ret;
        try {
            ret = this.isUse(addr.getHostAddress());
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isUse(String addr) {
        Object ipAddr = null;
        String[] code = null;
        boolean ret = false;
        try {
            try {
                code = this.getAllLocalIpAddress();
                int len = code.length;
                int i = 0;
                while (i < len) {
                    block6: {
                        if (!addr.equalsIgnoreCase(code[i])) break block6;
                        ret = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception t) {
                ret = false;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ipAddr = null;
            code = null;
            throw throwable;
        }
        {
            Object var8_10 = null;
            ipAddr = null;
        }
        code = null;
        return ret;
    }

    private final synchronized void create() {
        if (!this.m_createFlg) {
            this.m_thread.create();
            this.m_createFlg = true;
        }
    }
}

