/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import java.util.Arrays;

public class RollID {
    private static final int DEF = 5;
    private int m_max = -1;
    private int[] m_roll = null;
    private int m_pnt = -1;
    private long m_lastTime = -1L;
    private int m_nowID = -1;
    private int m_beforeID = -1;

    public RollID() {
        this(-1);
    }

    public RollID(int max) {
        if (max <= 5) {
            max = 5;
        }
        this.m_max = max;
        this.m_roll = new int[max];
        this.m_pnt = -1;
        this.m_nowID = -1;
        this.m_beforeID = -1;
        Arrays.fill(this.m_roll, -1);
        this.m_lastTime = System.currentTimeMillis();
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.m_roll = null;
        this.m_max = -1;
        this.m_pnt = -1;
        this.m_lastTime = -1L;
        this.m_nowID = -1;
        this.m_beforeID = -1;
    }

    public final void addID(int id) {
        ++this.m_pnt;
        if (this.m_pnt >= this.m_max) {
            this.m_pnt = 0;
        }
        this.m_roll[this.m_pnt] = id;
        this.m_lastTime = System.currentTimeMillis();
    }

    public final void setID(int id) {
        ++this.m_pnt;
        if (this.m_pnt >= this.m_max) {
            this.m_pnt = 0;
        }
        this.m_beforeID = this.m_nowID;
        this.m_nowID = id;
        this.m_roll[this.m_pnt] = id;
        this.m_lastTime = System.currentTimeMillis();
    }

    public final int getID() {
        return this.m_nowID;
    }

    public final int getBeforeID() {
        return this.m_beforeID;
    }

    public final long getLastTime() {
        return this.m_lastTime;
    }

    public final boolean isID(int id) {
        int[] roll = null;
        int len = this.m_max;
        roll = this.m_roll;
        int i = 0;
        while (i < len) {
            if (id == roll[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

