/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.util.UtilCom;
import java.net.InetAddress;
import java.util.ArrayList;

public class SubnetMask {
    private int m_network;
    private int m_netmask;

    private SubnetMask() {
        this.m_network = 0;
        this.m_netmask = 0;
    }

    public SubnetMask(InetAddress addr, String mask) throws InputException, AccessException {
        this.m_network = 0;
        this.m_netmask = 0;
        if (addr == null || mask == null || mask.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.m_network = SubnetMask.convertAddrByInt(addr.getHostAddress());
            this.m_netmask = SubnetMask.convertAddrByInt(mask);
            if (this.m_network == 0 || this.m_netmask == 0) {
                throw new AccessException("\u6307\u5b9a\u3057\u305f\u30a2\u30c9\u30ec\u30b9[" + addr + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
        catch (AccessException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new AccessException(e);
        }
    }

    public SubnetMask(String addr, String mask) throws InputException, AccessException {
        this.m_network = 0;
        this.m_netmask = 0;
        if (addr == null || addr.length() <= 0 || mask == null || mask.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.m_network = SubnetMask.convertAddrByInt(addr);
            this.m_netmask = SubnetMask.convertAddrByInt(mask);
            if (this.m_network == 0 || this.m_netmask == 0) {
                throw new AccessException("\u6307\u5b9a\u3057\u305f\u30a2\u30c9\u30ec\u30b9[" + addr + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
        catch (AccessException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new AccessException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public SubnetMask(String addr) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 184->188)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getNetworkAddress() {
        return SubnetMask.getIntToAddr(this.m_network);
    }

    public String getSubnetmask() {
        return SubnetMask.getIntToAddr(this.m_netmask);
    }

    public String getRangeAddress(int no) {
        Object ret = null;
        int len = ~this.m_netmask - 1;
        if (no < 0 || no >= len) {
            return null;
        }
        return SubnetMask.getIntToAddr((this.m_network & this.m_netmask) + no + 1);
    }

    public int getRangeSize() {
        return ~this.m_netmask - 1;
    }

    public String toString() {
        StringBuffer buf = null;
        buf = new StringBuffer();
        buf.append("netaddress:");
        buf.append(SubnetMask.getIntToAddr(this.m_network));
        buf.append(" subnetmask:");
        buf.append(SubnetMask.getIntToAddr(this.m_netmask));
        return buf.toString();
    }

    public boolean isRange(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        return this.isRange(addr.getHostAddress());
    }

    public boolean isRange(String addr) {
        boolean ret = false;
        if (addr == null || addr.length() <= 0) {
            return false;
        }
        try {
            int iaddr = SubnetMask.convertAddrByInt(addr);
            if ((this.m_network & this.m_netmask) == (iaddr & this.m_netmask) && (this.m_netmask == -1 || (iaddr &= ~this.m_netmask) != 0 && iaddr != ~this.m_netmask)) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static final String getIntToAddr(int addr) {
        StringBuffer buf = null;
        buf = new StringBuffer();
        buf.append((addr & 0xFF000000) >> 24 & 0xFF);
        buf.append(".");
        buf.append((addr & 0xFF0000) >> 16 & 0xFF);
        buf.append(".");
        buf.append((addr & 0xFF00) >> 8 & 0xFF);
        buf.append(".");
        buf.append(addr & 0xFF);
        return buf.toString();
    }

    private static final String getAddr(String addr) throws AccessException {
        String ret = null;
        int pnt = addr.indexOf("/");
        if (pnt == -1) {
            return addr;
        }
        try {
            ret = addr.substring(0, pnt).trim();
        }
        catch (Exception e) {
            throw new AccessException(e);
        }
        return ret;
    }

    private static final int getAddrToMaskLength(String addr) throws AccessException {
        int ret;
        int pnt = addr.indexOf("/");
        if (pnt == -1) {
            return 0;
        }
        try {
            ret = Integer.parseInt(addr.substring(pnt + 1).trim());
        }
        catch (Exception e) {
            throw new AccessException(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final int convertAddrByInt(String addr) throws AccessException {
        int ret;
        ArrayList lst = null;
        try {
            try {
                lst = UtilCom.pauseString(addr, ".");
                ret = lst != null && lst.size() == 4 ? Integer.parseInt((String)lst.get(3)) & 0xFF | (Integer.parseInt((String)lst.get(2)) & 0xFF) << 8 | (Integer.parseInt((String)lst.get(1)) & 0xFF) << 16 | (Integer.parseInt((String)lst.get(0)) & 0xFF) << 24 : 0;
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (lst != null) {
                lst.clear();
            }
            lst = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
            if (lst != null) {
                lst.clear();
            }
            lst = null;
            return ret;
        }
    }

    private static final int getSubnet(int length) throws AccessException {
        int ret;
        switch (length) {
            case 0: {
                ret = 0;
                break;
            }
            case 1: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                ret = -1073741824;
                break;
            }
            case 3: {
                ret = -536870912;
                break;
            }
            case 4: {
                ret = -268435456;
                break;
            }
            case 5: {
                ret = -134217728;
                break;
            }
            case 6: {
                ret = -67108864;
                break;
            }
            case 7: {
                ret = -33554432;
                break;
            }
            case 8: {
                ret = -16777216;
                break;
            }
            case 9: {
                ret = -8388608;
                break;
            }
            case 10: {
                ret = -4194304;
                break;
            }
            case 11: {
                ret = -2097152;
                break;
            }
            case 12: {
                ret = -1048576;
                break;
            }
            case 13: {
                ret = -524288;
                break;
            }
            case 14: {
                ret = -262144;
                break;
            }
            case 15: {
                ret = -131072;
                break;
            }
            case 16: {
                ret = -65536;
                break;
            }
            case 17: {
                ret = Short.MIN_VALUE;
                break;
            }
            case 18: {
                ret = -16384;
                break;
            }
            case 19: {
                ret = -8192;
                break;
            }
            case 20: {
                ret = -4096;
                break;
            }
            case 21: {
                ret = -2048;
                break;
            }
            case 22: {
                ret = -1024;
                break;
            }
            case 23: {
                ret = -512;
                break;
            }
            case 24: {
                ret = -256;
                break;
            }
            case 25: {
                ret = -128;
                break;
            }
            case 26: {
                ret = -64;
                break;
            }
            case 27: {
                ret = -32;
                break;
            }
            case 28: {
                ret = -16;
                break;
            }
            case 29: {
                ret = -8;
                break;
            }
            case 30: {
                ret = -4;
                break;
            }
            case 31: {
                ret = -2;
                break;
            }
            case 32: {
                ret = -1;
                break;
            }
            default: {
                throw new AccessException("\u5bfe\u8c61\u30de\u30b9\u30af\u9577\u304c\u7bc4\u56f2\u5916\u3067\u3059(length:" + length + ")");
            }
        }
        return ret;
    }
}

