/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.SettingException;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.TcpProtocol;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.LoopThread;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.UtilCom;
import com.JRcServer.commons.util.array.ObjectArray;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;

class TcpMonServerThread
extends ExecutionThread {
    private static final int TIMEOUT_ACCEPT = 1500;
    private static final long ADD_NEXT_TIME = 5L;
    private static final int DEF_BACK_LOG = 50;
    private static final int TYPE_ACCEPT = 1;
    private static final int TYPE_MANAGER = 2;
    private static final long NOT_TIMEOUT = 0L;
    private static final long DEF_TIMEOUT = 60000L;
    public static final long MIN_TIMEOUT = 30000L;
    public static final long MAX_TIMEOUT = 3600000L;
    private ServerSocket m_server = null;
    private long m_timeout = 0L;
    private int m_connLength = 0;
    private int m_bufLen = -1;
    private final ObjectArray m_table = new ObjectArray();
    private final ObjectArray m_newConnect = new ObjectArray();
    private final LoopThread m_threadAC = new LoopThread();
    private final LoopThread m_threadMan = new LoopThread();
    private final Synchronized m_sync = new Synchronized();
    private final Synchronized m_syncAC = new Synchronized();
    private final Synchronized m_syncMan = new Synchronized();

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void open(int port) throws InputException, AccessException {
        this.open(port, 50, 60000L);
    }

    public final void open(int port, long timeout) throws InputException, AccessException {
        this.open(port, 50, timeout);
    }

    public final void open(int port, int backlog) throws InputException, AccessException {
        this.open(port, backlog, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(int port, int backlog, long timeout) throws InputException, AccessException {
        if (timeout != 0L && (timeout < 30000L || timeout > 3600000L) || port < 0 || port > 65535 || backlog <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        this.m_syncAC.create();
        this.m_syncMan.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_server = new ServerSocket(port, backlog);
                this.openTo(timeout, backlog);
            }
        }
        catch (IOException io) {
            this.close();
            throw new AccessException(io);
        }
        catch (AccessException ac) {
            this.close();
            throw ac;
        }
    }

    public final void open(int port, InetAddress addr) throws InputException, AccessException {
        this.open(port, 50, 60000L, addr);
    }

    public final void open(int port, long timeout, InetAddress addr) throws InputException, AccessException {
        this.open(port, 50, timeout, addr);
    }

    public final void open(int port, int backlog, InetAddress addr) throws InputException, AccessException {
        this.open(port, backlog, 60000L, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(int port, int backlog, long timeout, InetAddress addr) throws InputException, AccessException {
        if (timeout != 0L && (timeout < 30000L || timeout > 3600000L) || port < 0 || port > 65535 || addr == null || backlog <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        this.m_syncAC.create();
        this.m_syncMan.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_server = new ServerSocket(port, backlog, addr);
                this.openTo(timeout, backlog);
            }
        }
        catch (IOException io) {
            this.close();
            throw new AccessException(io);
        }
        catch (AccessException ac) {
            this.close();
            throw ac;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close() {
        Object var5_7;
        ObjectArray tbl = null;
        this.m_sync.clear();
        this.m_syncAC.clear();
        this.m_syncMan.clear();
        try {
            try {
                this.m_server.close();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.m_server = null;
            throw throwable;
        }
        {
            var5_7 = null;
            this.m_server = null;
            this.m_threadAC.clear();
            this.m_threadMan.clear();
        }
        try {
            try {
                tbl = this.m_table;
                int len = tbl.size();
                int i = 0;
                while (i < len) {
                    ((TcpProtocol)tbl.get(i)).disconnect();
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            var5_7 = null;
            tbl = null;
            throw throwable;
        }
        {
            var5_7 = null;
            tbl = null;
            this.m_newConnect.clear();
            this.m_table.clear();
            this.m_server = null;
            this.m_timeout = 0L;
            this.m_connLength = 0;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimeout(long timeout) throws InputException {
        if (timeout != 0L && (timeout < 30000L || timeout > 3600000L)) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_timeout = timeout;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBuffer(int bufLen) throws InputException {
        if (bufLen <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_bufLen = bufLen;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int getAccept(ObjectArray val) {
        Object[] objs = null;
        int len = 0;
        if (val == null) return len;
        val.clear();
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    len = this.m_newConnect.size();
                    objs = this.m_newConnect.getObjects();
                    this.m_newConnect.clear();
                }
                int i = 0;
                while (i < len) {
                    val.add(objs[i]);
                    objs[i] = null;
                    ++i;
                }
            }
            catch (Exception t) {
                len = 0;
                val.clear();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            objs = null;
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        objs = null;
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTimeout() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_timeout;
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxConnect() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_connLength;
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBuffer() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_bufLen;
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getBindAddress(ConnectAddress addr) {
        block8: {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    if (addr != null) {
                        addr.create(this.m_server.getInetAddress(), this.m_server.getLocalPort());
                    }
                }
            }
            catch (Exception t) {
                if (addr == null) break block8;
                try {
                    addr.clear();
                    addr.create("0.0.0.0", 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAccept() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_newConnect.size() != 0;
            }
        }
        catch (Exception t) {
            this.close();
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnect() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_server.getSoTimeout();
                ret = true;
            }
        }
        catch (Exception t) {
            this.close();
            ret = false;
        }
        return ret;
    }

    protected final void init(Object obj) throws ExecutionException {
    }

    protected final void exit(Object obj) throws ExecutionException {
    }

    protected final void stop(Object obj) throws ExecutionException {
    }

    protected final void execution(Object obj) throws ExecutionException {
        if (obj == null || !(obj instanceof Integer)) {
            throw new ExecutionException("\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u4e0d\u6b63\u3067\u3059", 254);
        }
        UtilCom.idleTime();
        switch ((Integer)obj) {
            case 1: {
                this.execAccept();
                break;
            }
            case 2: {
                this.execManager();
                break;
            }
            default: {
                throw new ExecutionException("\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u4e0d\u6b63\u3067\u3059", 254);
            }
        }
    }

    private final void openTo(long timeout, int backlog) throws AccessException {
        try {
            this.m_timeout = timeout;
            this.m_connLength = backlog;
            this.m_threadAC.create(this, new Integer(1));
            this.m_threadMan.create(this, new Integer(2));
            this.m_server.setSoTimeout(1500);
            this.m_threadAC.startThread();
            this.m_threadMan.startThread();
        }
        catch (SocketException soc) {
            throw new AccessException(soc);
        }
        catch (InputException in) {
            throw new AccessException(in);
        }
        catch (SettingException st) {
            throw new AccessException(st);
        }
    }

    /*
     * Exception decompiling
     */
    private final void execAccept() throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [9 : 151->155)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void execManager() throws ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [10 : 200->203)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

